// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.DescribeWhatIfAnalysisResponse
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeWhatIfAnalysisOperationDeserializer: HttpDeserializer.NonStreaming<DescribeWhatIfAnalysisResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeWhatIfAnalysisResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeWhatIfAnalysisError(context, call, payload)
        }
        val builder = DescribeWhatIfAnalysisResponse.Builder()

        if (payload != null) {
            deserializeDescribeWhatIfAnalysisOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeWhatIfAnalysisError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeWhatIfAnalysisOperationBody(builder: DescribeWhatIfAnalysisResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedTimeRemainingInMinutes"))
    val FORECASTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ForecastArn"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TIMESERIESSELECTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeSeriesSelector"))
    val WHATIFANALYSISARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WhatIfAnalysisArn"))
    val WHATIFANALYSISNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WhatIfAnalysisName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR)
        field(FORECASTARN_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TIMESERIESSELECTOR_DESCRIPTOR)
        field(WHATIFANALYSISARN_DESCRIPTOR)
        field(WHATIFANALYSISNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR.index -> builder.estimatedTimeRemainingInMinutes = deserializeLong()
                FORECASTARN_DESCRIPTOR.index -> builder.forecastArn = deserializeString()
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                TIMESERIESSELECTOR_DESCRIPTOR.index -> builder.timeSeriesSelector = deserializeTimeSeriesSelectorDocument(deserializer)
                WHATIFANALYSISARN_DESCRIPTOR.index -> builder.whatIfAnalysisArn = deserializeString()
                WHATIFANALYSISNAME_DESCRIPTOR.index -> builder.whatIfAnalysisName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
