// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.DataSource
import aws.sdk.kotlin.services.forecast.model.DescribeDatasetImportJobResponse
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.sdk.kotlin.services.forecast.model.ImportMode
import aws.sdk.kotlin.services.forecast.model.Statistics
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class DescribeDatasetImportJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDatasetImportJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDatasetImportJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDatasetImportJobError(context, call, payload)
        }
        val builder = DescribeDatasetImportJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeDatasetImportJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDatasetImportJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDatasetImportJobOperationBody(builder: DescribeDatasetImportJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATASIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("DataSize"))
    val DATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataSource"))
    val DATASETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DatasetArn"))
    val DATASETIMPORTJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DatasetImportJobArn"))
    val DATASETIMPORTJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DatasetImportJobName"))
    val ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedTimeRemainingInMinutes"))
    val FIELDSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("FieldStatistics"))
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Format"))
    val GEOLOCATIONFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GeolocationFormat"))
    val IMPORTMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ImportMode"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TimeZone"))
    val TIMESTAMPFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TimestampFormat"))
    val USEGEOLOCATIONFORTIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UseGeolocationForTimeZone"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DATASIZE_DESCRIPTOR)
        field(DATASOURCE_DESCRIPTOR)
        field(DATASETARN_DESCRIPTOR)
        field(DATASETIMPORTJOBARN_DESCRIPTOR)
        field(DATASETIMPORTJOBNAME_DESCRIPTOR)
        field(ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR)
        field(FIELDSTATISTICS_DESCRIPTOR)
        field(FORMAT_DESCRIPTOR)
        field(GEOLOCATIONFORMAT_DESCRIPTOR)
        field(IMPORTMODE_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TIMEZONE_DESCRIPTOR)
        field(TIMESTAMPFORMAT_DESCRIPTOR)
        field(USEGEOLOCATIONFORTIMEZONE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATASIZE_DESCRIPTOR.index -> builder.dataSize = deserializeDouble()
                DATASOURCE_DESCRIPTOR.index -> builder.dataSource = deserializeDataSourceDocument(deserializer)
                DATASETARN_DESCRIPTOR.index -> builder.datasetArn = deserializeString()
                DATASETIMPORTJOBARN_DESCRIPTOR.index -> builder.datasetImportJobArn = deserializeString()
                DATASETIMPORTJOBNAME_DESCRIPTOR.index -> builder.datasetImportJobName = deserializeString()
                ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR.index -> builder.estimatedTimeRemainingInMinutes = deserializeLong()
                FIELDSTATISTICS_DESCRIPTOR.index -> builder.fieldStatistics =
                    deserializer.deserializeMap(FIELDSTATISTICS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Statistics>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeStatisticsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                FORMAT_DESCRIPTOR.index -> builder.format = deserializeString()
                GEOLOCATIONFORMAT_DESCRIPTOR.index -> builder.geolocationFormat = deserializeString()
                IMPORTMODE_DESCRIPTOR.index -> builder.importMode = deserializeString().let { ImportMode.fromValue(it) }
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                TIMEZONE_DESCRIPTOR.index -> builder.timeZone = deserializeString()
                TIMESTAMPFORMAT_DESCRIPTOR.index -> builder.timestampFormat = deserializeString()
                USEGEOLOCATIONFORTIMEZONE_DESCRIPTOR.index -> builder.useGeolocationForTimeZone = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
