// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.paginators

import aws.sdk.kotlin.services.forecast.ForecastClient
import aws.sdk.kotlin.services.forecast.model.DatasetGroupSummary
import aws.sdk.kotlin.services.forecast.model.DatasetImportJobSummary
import aws.sdk.kotlin.services.forecast.model.DatasetSummary
import aws.sdk.kotlin.services.forecast.model.ExplainabilityExportSummary
import aws.sdk.kotlin.services.forecast.model.ExplainabilitySummary
import aws.sdk.kotlin.services.forecast.model.ForecastExportJobSummary
import aws.sdk.kotlin.services.forecast.model.ForecastSummary
import aws.sdk.kotlin.services.forecast.model.ListDatasetGroupsRequest
import aws.sdk.kotlin.services.forecast.model.ListDatasetGroupsResponse
import aws.sdk.kotlin.services.forecast.model.ListDatasetImportJobsRequest
import aws.sdk.kotlin.services.forecast.model.ListDatasetImportJobsResponse
import aws.sdk.kotlin.services.forecast.model.ListDatasetsRequest
import aws.sdk.kotlin.services.forecast.model.ListDatasetsResponse
import aws.sdk.kotlin.services.forecast.model.ListExplainabilitiesRequest
import aws.sdk.kotlin.services.forecast.model.ListExplainabilitiesResponse
import aws.sdk.kotlin.services.forecast.model.ListExplainabilityExportsRequest
import aws.sdk.kotlin.services.forecast.model.ListExplainabilityExportsResponse
import aws.sdk.kotlin.services.forecast.model.ListForecastExportJobsRequest
import aws.sdk.kotlin.services.forecast.model.ListForecastExportJobsResponse
import aws.sdk.kotlin.services.forecast.model.ListForecastsRequest
import aws.sdk.kotlin.services.forecast.model.ListForecastsResponse
import aws.sdk.kotlin.services.forecast.model.ListMonitorEvaluationsRequest
import aws.sdk.kotlin.services.forecast.model.ListMonitorEvaluationsResponse
import aws.sdk.kotlin.services.forecast.model.ListMonitorsRequest
import aws.sdk.kotlin.services.forecast.model.ListMonitorsResponse
import aws.sdk.kotlin.services.forecast.model.ListPredictorBacktestExportJobsRequest
import aws.sdk.kotlin.services.forecast.model.ListPredictorBacktestExportJobsResponse
import aws.sdk.kotlin.services.forecast.model.ListPredictorsRequest
import aws.sdk.kotlin.services.forecast.model.ListPredictorsResponse
import aws.sdk.kotlin.services.forecast.model.ListWhatIfAnalysesRequest
import aws.sdk.kotlin.services.forecast.model.ListWhatIfAnalysesResponse
import aws.sdk.kotlin.services.forecast.model.ListWhatIfForecastExportsRequest
import aws.sdk.kotlin.services.forecast.model.ListWhatIfForecastExportsResponse
import aws.sdk.kotlin.services.forecast.model.ListWhatIfForecastsRequest
import aws.sdk.kotlin.services.forecast.model.ListWhatIfForecastsResponse
import aws.sdk.kotlin.services.forecast.model.MonitorSummary
import aws.sdk.kotlin.services.forecast.model.PredictorBacktestExportJobSummary
import aws.sdk.kotlin.services.forecast.model.PredictorMonitorEvaluation
import aws.sdk.kotlin.services.forecast.model.PredictorSummary
import aws.sdk.kotlin.services.forecast.model.WhatIfAnalysisSummary
import aws.sdk.kotlin.services.forecast.model.WhatIfForecastExportSummary
import aws.sdk.kotlin.services.forecast.model.WhatIfForecastSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDatasetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetGroupsResponse]
 */
public fun ForecastClient.listDatasetGroupsPaginated(initialRequest: ListDatasetGroupsRequest = ListDatasetGroupsRequest { }): Flow<ListDatasetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetGroupsPaginated.listDatasetGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetGroupsResponse]
 */
public fun ForecastClient.listDatasetGroupsPaginated(block: ListDatasetGroupsRequest.Builder.() -> Unit): Flow<ListDatasetGroupsResponse> =
    listDatasetGroupsPaginated(ListDatasetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetGroupsPaginated]
 * to access the nested member [DatasetGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetGroupSummary]
 */
@JvmName("listDatasetGroupsResponseDatasetGroupSummary")
public fun Flow<ListDatasetGroupsResponse>.datasetGroups(): Flow<DatasetGroupSummary> =
    transform() { response ->
        response.datasetGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetImportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetImportJobsResponse]
 */
public fun ForecastClient.listDatasetImportJobsPaginated(initialRequest: ListDatasetImportJobsRequest = ListDatasetImportJobsRequest { }): Flow<ListDatasetImportJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetImportJobsPaginated.listDatasetImportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetImportJobsResponse]
 */
public fun ForecastClient.listDatasetImportJobsPaginated(block: ListDatasetImportJobsRequest.Builder.() -> Unit): Flow<ListDatasetImportJobsResponse> =
    listDatasetImportJobsPaginated(ListDatasetImportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetImportJobsPaginated]
 * to access the nested member [DatasetImportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetImportJobSummary]
 */
@JvmName("listDatasetImportJobsResponseDatasetImportJobSummary")
public fun Flow<ListDatasetImportJobsResponse>.datasetImportJobs(): Flow<DatasetImportJobSummary> =
    transform() { response ->
        response.datasetImportJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
public fun ForecastClient.listDatasetsPaginated(initialRequest: ListDatasetsRequest = ListDatasetsRequest { }): Flow<ListDatasetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetsPaginated.listDatasets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
public fun ForecastClient.listDatasetsPaginated(block: ListDatasetsRequest.Builder.() -> Unit): Flow<ListDatasetsResponse> =
    listDatasetsPaginated(ListDatasetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetsPaginated]
 * to access the nested member [DatasetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetSummary]
 */
@JvmName("listDatasetsResponseDatasetSummary")
public fun Flow<ListDatasetsResponse>.datasets(): Flow<DatasetSummary> =
    transform() { response ->
        response.datasets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListExplainabilitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExplainabilitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExplainabilitiesResponse]
 */
public fun ForecastClient.listExplainabilitiesPaginated(initialRequest: ListExplainabilitiesRequest = ListExplainabilitiesRequest { }): Flow<ListExplainabilitiesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExplainabilitiesPaginated.listExplainabilities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListExplainabilitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExplainabilitiesResponse]
 */
public fun ForecastClient.listExplainabilitiesPaginated(block: ListExplainabilitiesRequest.Builder.() -> Unit): Flow<ListExplainabilitiesResponse> =
    listExplainabilitiesPaginated(ListExplainabilitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExplainabilitiesPaginated]
 * to access the nested member [ExplainabilitySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExplainabilitySummary]
 */
@JvmName("listExplainabilitiesResponseExplainabilitySummary")
public fun Flow<ListExplainabilitiesResponse>.explainabilities(): Flow<ExplainabilitySummary> =
    transform() { response ->
        response.explainabilities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListExplainabilityExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExplainabilityExportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExplainabilityExportsResponse]
 */
public fun ForecastClient.listExplainabilityExportsPaginated(initialRequest: ListExplainabilityExportsRequest = ListExplainabilityExportsRequest { }): Flow<ListExplainabilityExportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExplainabilityExportsPaginated.listExplainabilityExports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListExplainabilityExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExplainabilityExportsResponse]
 */
public fun ForecastClient.listExplainabilityExportsPaginated(block: ListExplainabilityExportsRequest.Builder.() -> Unit): Flow<ListExplainabilityExportsResponse> =
    listExplainabilityExportsPaginated(ListExplainabilityExportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExplainabilityExportsPaginated]
 * to access the nested member [ExplainabilityExportSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExplainabilityExportSummary]
 */
@JvmName("listExplainabilityExportsResponseExplainabilityExportSummary")
public fun Flow<ListExplainabilityExportsResponse>.explainabilityExports(): Flow<ExplainabilityExportSummary> =
    transform() { response ->
        response.explainabilityExports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListForecastExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListForecastExportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListForecastExportJobsResponse]
 */
public fun ForecastClient.listForecastExportJobsPaginated(initialRequest: ListForecastExportJobsRequest = ListForecastExportJobsRequest { }): Flow<ListForecastExportJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listForecastExportJobsPaginated.listForecastExportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListForecastExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListForecastExportJobsResponse]
 */
public fun ForecastClient.listForecastExportJobsPaginated(block: ListForecastExportJobsRequest.Builder.() -> Unit): Flow<ListForecastExportJobsResponse> =
    listForecastExportJobsPaginated(ListForecastExportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listForecastExportJobsPaginated]
 * to access the nested member [ForecastExportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ForecastExportJobSummary]
 */
@JvmName("listForecastExportJobsResponseForecastExportJobSummary")
public fun Flow<ListForecastExportJobsResponse>.forecastExportJobs(): Flow<ForecastExportJobSummary> =
    transform() { response ->
        response.forecastExportJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListForecastsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListForecastsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListForecastsResponse]
 */
public fun ForecastClient.listForecastsPaginated(initialRequest: ListForecastsRequest = ListForecastsRequest { }): Flow<ListForecastsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listForecastsPaginated.listForecasts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListForecastsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListForecastsResponse]
 */
public fun ForecastClient.listForecastsPaginated(block: ListForecastsRequest.Builder.() -> Unit): Flow<ListForecastsResponse> =
    listForecastsPaginated(ListForecastsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listForecastsPaginated]
 * to access the nested member [ForecastSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ForecastSummary]
 */
@JvmName("listForecastsResponseForecastSummary")
public fun Flow<ListForecastsResponse>.forecasts(): Flow<ForecastSummary> =
    transform() { response ->
        response.forecasts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMonitorEvaluationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMonitorEvaluationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMonitorEvaluationsResponse]
 */
public fun ForecastClient.listMonitorEvaluationsPaginated(initialRequest: ListMonitorEvaluationsRequest): Flow<ListMonitorEvaluationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMonitorEvaluationsPaginated.listMonitorEvaluations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMonitorEvaluationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMonitorEvaluationsResponse]
 */
public fun ForecastClient.listMonitorEvaluationsPaginated(block: ListMonitorEvaluationsRequest.Builder.() -> Unit): Flow<ListMonitorEvaluationsResponse> =
    listMonitorEvaluationsPaginated(ListMonitorEvaluationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMonitorEvaluationsPaginated]
 * to access the nested member [PredictorMonitorEvaluation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PredictorMonitorEvaluation]
 */
@JvmName("listMonitorEvaluationsResponsePredictorMonitorEvaluation")
public fun Flow<ListMonitorEvaluationsResponse>.predictorMonitorEvaluations(): Flow<PredictorMonitorEvaluation> =
    transform() { response ->
        response.predictorMonitorEvaluations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMonitorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMonitorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMonitorsResponse]
 */
public fun ForecastClient.listMonitorsPaginated(initialRequest: ListMonitorsRequest = ListMonitorsRequest { }): Flow<ListMonitorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMonitorsPaginated.listMonitors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMonitorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMonitorsResponse]
 */
public fun ForecastClient.listMonitorsPaginated(block: ListMonitorsRequest.Builder.() -> Unit): Flow<ListMonitorsResponse> =
    listMonitorsPaginated(ListMonitorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMonitorsPaginated]
 * to access the nested member [MonitorSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MonitorSummary]
 */
@JvmName("listMonitorsResponseMonitorSummary")
public fun Flow<ListMonitorsResponse>.monitors(): Flow<MonitorSummary> =
    transform() { response ->
        response.monitors?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPredictorBacktestExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPredictorBacktestExportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPredictorBacktestExportJobsResponse]
 */
public fun ForecastClient.listPredictorBacktestExportJobsPaginated(initialRequest: ListPredictorBacktestExportJobsRequest = ListPredictorBacktestExportJobsRequest { }): Flow<ListPredictorBacktestExportJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPredictorBacktestExportJobsPaginated.listPredictorBacktestExportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPredictorBacktestExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPredictorBacktestExportJobsResponse]
 */
public fun ForecastClient.listPredictorBacktestExportJobsPaginated(block: ListPredictorBacktestExportJobsRequest.Builder.() -> Unit): Flow<ListPredictorBacktestExportJobsResponse> =
    listPredictorBacktestExportJobsPaginated(ListPredictorBacktestExportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPredictorBacktestExportJobsPaginated]
 * to access the nested member [PredictorBacktestExportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PredictorBacktestExportJobSummary]
 */
@JvmName("listPredictorBacktestExportJobsResponsePredictorBacktestExportJobSummary")
public fun Flow<ListPredictorBacktestExportJobsResponse>.predictorBacktestExportJobs(): Flow<PredictorBacktestExportJobSummary> =
    transform() { response ->
        response.predictorBacktestExportJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPredictorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPredictorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPredictorsResponse]
 */
public fun ForecastClient.listPredictorsPaginated(initialRequest: ListPredictorsRequest = ListPredictorsRequest { }): Flow<ListPredictorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPredictorsPaginated.listPredictors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPredictorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPredictorsResponse]
 */
public fun ForecastClient.listPredictorsPaginated(block: ListPredictorsRequest.Builder.() -> Unit): Flow<ListPredictorsResponse> =
    listPredictorsPaginated(ListPredictorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPredictorsPaginated]
 * to access the nested member [PredictorSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PredictorSummary]
 */
@JvmName("listPredictorsResponsePredictorSummary")
public fun Flow<ListPredictorsResponse>.predictors(): Flow<PredictorSummary> =
    transform() { response ->
        response.predictors?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWhatIfAnalysesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWhatIfAnalysesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWhatIfAnalysesResponse]
 */
public fun ForecastClient.listWhatIfAnalysesPaginated(initialRequest: ListWhatIfAnalysesRequest = ListWhatIfAnalysesRequest { }): Flow<ListWhatIfAnalysesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWhatIfAnalysesPaginated.listWhatIfAnalyses(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWhatIfAnalysesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWhatIfAnalysesResponse]
 */
public fun ForecastClient.listWhatIfAnalysesPaginated(block: ListWhatIfAnalysesRequest.Builder.() -> Unit): Flow<ListWhatIfAnalysesResponse> =
    listWhatIfAnalysesPaginated(ListWhatIfAnalysesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWhatIfAnalysesPaginated]
 * to access the nested member [WhatIfAnalysisSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WhatIfAnalysisSummary]
 */
@JvmName("listWhatIfAnalysesResponseWhatIfAnalysisSummary")
public fun Flow<ListWhatIfAnalysesResponse>.whatIfAnalyses(): Flow<WhatIfAnalysisSummary> =
    transform() { response ->
        response.whatIfAnalyses?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWhatIfForecastExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWhatIfForecastExportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWhatIfForecastExportsResponse]
 */
public fun ForecastClient.listWhatIfForecastExportsPaginated(initialRequest: ListWhatIfForecastExportsRequest = ListWhatIfForecastExportsRequest { }): Flow<ListWhatIfForecastExportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWhatIfForecastExportsPaginated.listWhatIfForecastExports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWhatIfForecastExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWhatIfForecastExportsResponse]
 */
public fun ForecastClient.listWhatIfForecastExportsPaginated(block: ListWhatIfForecastExportsRequest.Builder.() -> Unit): Flow<ListWhatIfForecastExportsResponse> =
    listWhatIfForecastExportsPaginated(ListWhatIfForecastExportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWhatIfForecastExportsPaginated]
 * to access the nested member [WhatIfForecastExportSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WhatIfForecastExportSummary]
 */
@JvmName("listWhatIfForecastExportsResponseWhatIfForecastExportSummary")
public fun Flow<ListWhatIfForecastExportsResponse>.whatIfForecastExports(): Flow<WhatIfForecastExportSummary> =
    transform() { response ->
        response.whatIfForecastExports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWhatIfForecastsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWhatIfForecastsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWhatIfForecastsResponse]
 */
public fun ForecastClient.listWhatIfForecastsPaginated(initialRequest: ListWhatIfForecastsRequest = ListWhatIfForecastsRequest { }): Flow<ListWhatIfForecastsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWhatIfForecastsPaginated.listWhatIfForecasts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWhatIfForecastsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWhatIfForecastsResponse]
 */
public fun ForecastClient.listWhatIfForecastsPaginated(block: ListWhatIfForecastsRequest.Builder.() -> Unit): Flow<ListWhatIfForecastsResponse> =
    listWhatIfForecastsPaginated(ListWhatIfForecastsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWhatIfForecastsPaginated]
 * to access the nested member [WhatIfForecastSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WhatIfForecastSummary]
 */
@JvmName("listWhatIfForecastsResponseWhatIfForecastSummary")
public fun Flow<ListWhatIfForecastsResponse>.whatIfForecasts(): Flow<WhatIfForecastSummary> =
    transform() { response ->
        response.whatIfForecasts?.forEach {
            emit(it)
        }
    }
