// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the what-if forecast export properties used in the ListWhatIfForecastExports operation. To get the complete set of properties, call the DescribeWhatIfForecastExport operation, and provide the `WhatIfForecastExportArn` that is listed in the summary.
 */
public class WhatIfForecastExportSummary private constructor(builder: Builder) {
    /**
     * When the what-if forecast export was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
     */
    public val destination: aws.sdk.kotlin.services.forecast.model.DataDestination? = builder.destination
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * If an error occurred, an informational message about the error.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The status of the what-if forecast export. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     *
     * The `Status` of the what-if analysis must be `ACTIVE` before you can access the analysis.
     */
    public val status: kotlin.String? = builder.status
    /**
     * An array of Amazon Resource Names (ARNs) that define the what-if forecasts included in the export.
     */
    public val whatIfForecastArns: List<String>? = builder.whatIfForecastArns
    /**
     * The Amazon Resource Name (ARN) of the what-if forecast export.
     */
    public val whatIfForecastExportArn: kotlin.String? = builder.whatIfForecastExportArn
    /**
     * The what-if forecast export name.
     */
    public val whatIfForecastExportName: kotlin.String? = builder.whatIfForecastExportName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.WhatIfForecastExportSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WhatIfForecastExportSummary(")
        append("creationTime=$creationTime,")
        append("destination=$destination,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("status=$status,")
        append("whatIfForecastArns=$whatIfForecastArns,")
        append("whatIfForecastExportArn=$whatIfForecastExportArn,")
        append("whatIfForecastExportName=$whatIfForecastExportName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (whatIfForecastArns?.hashCode() ?: 0)
        result = 31 * result + (whatIfForecastExportArn?.hashCode() ?: 0)
        result = 31 * result + (whatIfForecastExportName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WhatIfForecastExportSummary

        if (creationTime != other.creationTime) return false
        if (destination != other.destination) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (status != other.status) return false
        if (whatIfForecastArns != other.whatIfForecastArns) return false
        if (whatIfForecastExportArn != other.whatIfForecastExportArn) return false
        if (whatIfForecastExportName != other.whatIfForecastExportName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.WhatIfForecastExportSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the what-if forecast export was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
         */
        public var destination: aws.sdk.kotlin.services.forecast.model.DataDestination? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If an error occurred, an informational message about the error.
         */
        public var message: kotlin.String? = null
        /**
         * The status of the what-if forecast export. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         *
         * The `Status` of the what-if analysis must be `ACTIVE` before you can access the analysis.
         */
        public var status: kotlin.String? = null
        /**
         * An array of Amazon Resource Names (ARNs) that define the what-if forecasts included in the export.
         */
        public var whatIfForecastArns: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the what-if forecast export.
         */
        public var whatIfForecastExportArn: kotlin.String? = null
        /**
         * The what-if forecast export name.
         */
        public var whatIfForecastExportName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.WhatIfForecastExportSummary) : this() {
            this.creationTime = x.creationTime
            this.destination = x.destination
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.status = x.status
            this.whatIfForecastArns = x.whatIfForecastArns
            this.whatIfForecastExportArn = x.whatIfForecastExportArn
            this.whatIfForecastExportName = x.whatIfForecastExportName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.WhatIfForecastExportSummary = WhatIfForecastExportSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.DataDestination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.forecast.model.DataDestination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.forecast.model.DataDestination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
