// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A transformation function is a pair of operations that select and modify the rows in a related time series. You select the rows that you want with a condition operation and you modify the rows with a transformation operation. All conditions are joined with an AND operation, meaning that all conditions must be true for the transformation to be applied. Transformations are applied in the order that they are listed.
 */
public class TimeSeriesTransformation private constructor(builder: Builder) {
    /**
     * An array of actions that define a time series and how it is transformed. These transformations create a new time series that is used for the what-if analysis.
     */
    public val action: aws.sdk.kotlin.services.forecast.model.Action? = builder.action
    /**
     * An array of conditions that define which members of the related time series are transformed.
     */
    public val timeSeriesConditions: List<TimeSeriesCondition>? = builder.timeSeriesConditions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.TimeSeriesTransformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeSeriesTransformation(")
        append("action=$action,")
        append("timeSeriesConditions=$timeSeriesConditions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (timeSeriesConditions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeSeriesTransformation

        if (action != other.action) return false
        if (timeSeriesConditions != other.timeSeriesConditions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.TimeSeriesTransformation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of actions that define a time series and how it is transformed. These transformations create a new time series that is used for the what-if analysis.
         */
        public var action: aws.sdk.kotlin.services.forecast.model.Action? = null
        /**
         * An array of conditions that define which members of the related time series are transformed.
         */
        public var timeSeriesConditions: List<TimeSeriesCondition>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.TimeSeriesTransformation) : this() {
            this.action = x.action
            this.timeSeriesConditions = x.timeSeriesConditions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.TimeSeriesTransformation = TimeSeriesTransformation(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.Action] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.forecast.model.Action.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.forecast.model.Action.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
