// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A replacement dataset is a modified version of the baseline related time series that contains only the values that you want to include in a what-if forecast. The replacement dataset must contain the forecast dimensions and item identifiers in the baseline related time series as well as at least 1 changed time series. This dataset is merged with the baseline related time series to create a transformed dataset that is used for the what-if forecast.
 */
public class TimeSeriesReplacementsDataSource private constructor(builder: Builder) {
    /**
     * The format of the replacement data, CSV or PARQUET.
     */
    public val format: kotlin.String? = builder.format
    /**
     * The path to the file(s) in an Amazon Simple Storage Service (Amazon S3) bucket, and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the file(s). Optionally, includes an Key Management Service (KMS) key. This object is part of the DataSource object that is submitted in the CreateDatasetImportJob request, and part of the DataDestination object.
     */
    public val s3Config: aws.sdk.kotlin.services.forecast.model.S3Config? = builder.s3Config
    /**
     * Defines the fields of a dataset.
     */
    public val schema: aws.sdk.kotlin.services.forecast.model.Schema? = builder.schema
    /**
     * The timestamp format of the replacement data.
     */
    public val timestampFormat: kotlin.String? = builder.timestampFormat

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeSeriesReplacementsDataSource(")
        append("format=$format,")
        append("s3Config=$s3Config,")
        append("schema=$schema,")
        append("timestampFormat=$timestampFormat")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = format?.hashCode() ?: 0
        result = 31 * result + (s3Config?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (timestampFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeSeriesReplacementsDataSource

        if (format != other.format) return false
        if (s3Config != other.s3Config) return false
        if (schema != other.schema) return false
        if (timestampFormat != other.timestampFormat) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The format of the replacement data, CSV or PARQUET.
         */
        public var format: kotlin.String? = null
        /**
         * The path to the file(s) in an Amazon Simple Storage Service (Amazon S3) bucket, and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the file(s). Optionally, includes an Key Management Service (KMS) key. This object is part of the DataSource object that is submitted in the CreateDatasetImportJob request, and part of the DataDestination object.
         */
        public var s3Config: aws.sdk.kotlin.services.forecast.model.S3Config? = null
        /**
         * Defines the fields of a dataset.
         */
        public var schema: aws.sdk.kotlin.services.forecast.model.Schema? = null
        /**
         * The timestamp format of the replacement data.
         */
        public var timestampFormat: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource) : this() {
            this.format = x.format
            this.s3Config = x.s3Config
            this.schema = x.schema
            this.timestampFormat = x.timestampFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource = TimeSeriesReplacementsDataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.S3Config] inside the given [block]
         */
        public fun s3Config(block: aws.sdk.kotlin.services.forecast.model.S3Config.Builder.() -> kotlin.Unit) {
            this.s3Config = aws.sdk.kotlin.services.forecast.model.S3Config.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.Schema] inside the given [block]
         */
        public fun schema(block: aws.sdk.kotlin.services.forecast.model.Schema.Builder.() -> kotlin.Unit) {
            this.schema = aws.sdk.kotlin.services.forecast.model.Schema.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
