// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides statistics for each data field imported into to an Amazon Forecast dataset with the [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation.
 */
public class Statistics private constructor(builder: Builder) {
    /**
     * For a numeric field, the average value in the field.
     */
    public val avg: kotlin.Double? = builder.avg
    /**
     * The number of values in the field. If the response value is -1, refer to `CountLong`.
     */
    public val count: kotlin.Int? = builder.count
    /**
     * The number of distinct values in the field. If the response value is -1, refer to `CountDistinctLong`.
     */
    public val countDistinct: kotlin.Int? = builder.countDistinct
    /**
     * The number of distinct values in the field. `CountDistinctLong` is used instead of `CountDistinct` if the value is greater than 2,147,483,647.
     */
    public val countDistinctLong: kotlin.Long? = builder.countDistinctLong
    /**
     * The number of values in the field. `CountLong` is used instead of `Count` if the value is greater than 2,147,483,647.
     */
    public val countLong: kotlin.Long? = builder.countLong
    /**
     * The number of NAN (not a number) values in the field. If the response value is -1, refer to `CountNanLong`.
     */
    public val countNan: kotlin.Int? = builder.countNan
    /**
     * The number of NAN (not a number) values in the field. `CountNanLong` is used instead of `CountNan` if the value is greater than 2,147,483,647.
     */
    public val countNanLong: kotlin.Long? = builder.countNanLong
    /**
     * The number of null values in the field. If the response value is -1, refer to `CountNullLong`.
     */
    public val countNull: kotlin.Int? = builder.countNull
    /**
     * The number of null values in the field. `CountNullLong` is used instead of `CountNull` if the value is greater than 2,147,483,647.
     */
    public val countNullLong: kotlin.Long? = builder.countNullLong
    /**
     * For a numeric field, the maximum value in the field.
     */
    public val max: kotlin.String? = builder.max
    /**
     * For a numeric field, the minimum value in the field.
     */
    public val min: kotlin.String? = builder.min
    /**
     * For a numeric field, the standard deviation.
     */
    public val stddev: kotlin.Double? = builder.stddev

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.Statistics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Statistics(")
        append("avg=$avg,")
        append("count=$count,")
        append("countDistinct=$countDistinct,")
        append("countDistinctLong=$countDistinctLong,")
        append("countLong=$countLong,")
        append("countNan=$countNan,")
        append("countNanLong=$countNanLong,")
        append("countNull=$countNull,")
        append("countNullLong=$countNullLong,")
        append("max=$max,")
        append("min=$min,")
        append("stddev=$stddev")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = avg?.hashCode() ?: 0
        result = 31 * result + (count ?: 0)
        result = 31 * result + (countDistinct ?: 0)
        result = 31 * result + (countDistinctLong?.hashCode() ?: 0)
        result = 31 * result + (countLong?.hashCode() ?: 0)
        result = 31 * result + (countNan ?: 0)
        result = 31 * result + (countNanLong?.hashCode() ?: 0)
        result = 31 * result + (countNull ?: 0)
        result = 31 * result + (countNullLong?.hashCode() ?: 0)
        result = 31 * result + (max?.hashCode() ?: 0)
        result = 31 * result + (min?.hashCode() ?: 0)
        result = 31 * result + (stddev?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Statistics

        if (!(avg?.equals(other.avg) ?: (other.avg == null))) return false
        if (count != other.count) return false
        if (countDistinct != other.countDistinct) return false
        if (countDistinctLong != other.countDistinctLong) return false
        if (countLong != other.countLong) return false
        if (countNan != other.countNan) return false
        if (countNanLong != other.countNanLong) return false
        if (countNull != other.countNull) return false
        if (countNullLong != other.countNullLong) return false
        if (max != other.max) return false
        if (min != other.min) return false
        if (!(stddev?.equals(other.stddev) ?: (other.stddev == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.Statistics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For a numeric field, the average value in the field.
         */
        public var avg: kotlin.Double? = null
        /**
         * The number of values in the field. If the response value is -1, refer to `CountLong`.
         */
        public var count: kotlin.Int? = null
        /**
         * The number of distinct values in the field. If the response value is -1, refer to `CountDistinctLong`.
         */
        public var countDistinct: kotlin.Int? = null
        /**
         * The number of distinct values in the field. `CountDistinctLong` is used instead of `CountDistinct` if the value is greater than 2,147,483,647.
         */
        public var countDistinctLong: kotlin.Long? = null
        /**
         * The number of values in the field. `CountLong` is used instead of `Count` if the value is greater than 2,147,483,647.
         */
        public var countLong: kotlin.Long? = null
        /**
         * The number of NAN (not a number) values in the field. If the response value is -1, refer to `CountNanLong`.
         */
        public var countNan: kotlin.Int? = null
        /**
         * The number of NAN (not a number) values in the field. `CountNanLong` is used instead of `CountNan` if the value is greater than 2,147,483,647.
         */
        public var countNanLong: kotlin.Long? = null
        /**
         * The number of null values in the field. If the response value is -1, refer to `CountNullLong`.
         */
        public var countNull: kotlin.Int? = null
        /**
         * The number of null values in the field. `CountNullLong` is used instead of `CountNull` if the value is greater than 2,147,483,647.
         */
        public var countNullLong: kotlin.Long? = null
        /**
         * For a numeric field, the maximum value in the field.
         */
        public var max: kotlin.String? = null
        /**
         * For a numeric field, the minimum value in the field.
         */
        public var min: kotlin.String? = null
        /**
         * For a numeric field, the standard deviation.
         */
        public var stddev: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.Statistics) : this() {
            this.avg = x.avg
            this.count = x.count
            this.countDistinct = x.countDistinct
            this.countDistinctLong = x.countDistinctLong
            this.countLong = x.countLong
            this.countNan = x.countNan
            this.countNanLong = x.countNanLong
            this.countNull = x.countNull
            this.countNullLong = x.countNullLong
            this.max = x.max
            this.min = x.min
            this.stddev = x.stddev
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.Statistics = Statistics(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
