// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the results of a monitor evaluation.
 */
public class PredictorMonitorEvaluation private constructor(builder: Builder) {
    /**
     * The status of the monitor evaluation. The state can be `SUCCESS` or `FAILURE`.
     */
    public val evaluationState: kotlin.String? = builder.evaluationState
    /**
     * The timestamp that indicates when the monitor evaluation was started.
     */
    public val evaluationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.evaluationTime
    /**
     * Information about any errors that may have occurred during the monitor evaluation.
     */
    public val message: kotlin.String? = builder.message
    /**
     * A list of metrics Forecast calculated when monitoring a predictor. You can compare the value for each metric in the list to the metric's value in the Baseline to see how your predictor's performance is changing.
     */
    public val metricResults: List<MetricResult>? = builder.metricResults
    /**
     * The Amazon Resource Name (ARN) of the monitor resource.
     */
    public val monitorArn: kotlin.String? = builder.monitorArn
    /**
     * The source of the data the monitor resource used during the evaluation.
     */
    public val monitorDataSource: aws.sdk.kotlin.services.forecast.model.MonitorDataSource? = builder.monitorDataSource
    /**
     * The number of items considered during the evaluation.
     */
    public val numItemsEvaluated: kotlin.Long? = builder.numItemsEvaluated
    /**
     * Provides details about a predictor event, such as a retraining.
     */
    public val predictorEvent: aws.sdk.kotlin.services.forecast.model.PredictorEvent? = builder.predictorEvent
    /**
     * The Amazon Resource Name (ARN) of the resource to monitor.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The timestamp that indicates the end of the window that is used for monitor evaluation.
     */
    public val windowEndDatetime: aws.smithy.kotlin.runtime.time.Instant? = builder.windowEndDatetime
    /**
     * The timestamp that indicates the start of the window that is used for monitor evaluation.
     */
    public val windowStartDatetime: aws.smithy.kotlin.runtime.time.Instant? = builder.windowStartDatetime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.PredictorMonitorEvaluation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PredictorMonitorEvaluation(")
        append("evaluationState=$evaluationState,")
        append("evaluationTime=$evaluationTime,")
        append("message=$message,")
        append("metricResults=$metricResults,")
        append("monitorArn=$monitorArn,")
        append("monitorDataSource=$monitorDataSource,")
        append("numItemsEvaluated=$numItemsEvaluated,")
        append("predictorEvent=$predictorEvent,")
        append("resourceArn=$resourceArn,")
        append("windowEndDatetime=$windowEndDatetime,")
        append("windowStartDatetime=$windowStartDatetime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = evaluationState?.hashCode() ?: 0
        result = 31 * result + (evaluationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (metricResults?.hashCode() ?: 0)
        result = 31 * result + (monitorArn?.hashCode() ?: 0)
        result = 31 * result + (monitorDataSource?.hashCode() ?: 0)
        result = 31 * result + (numItemsEvaluated?.hashCode() ?: 0)
        result = 31 * result + (predictorEvent?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (windowEndDatetime?.hashCode() ?: 0)
        result = 31 * result + (windowStartDatetime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PredictorMonitorEvaluation

        if (evaluationState != other.evaluationState) return false
        if (evaluationTime != other.evaluationTime) return false
        if (message != other.message) return false
        if (metricResults != other.metricResults) return false
        if (monitorArn != other.monitorArn) return false
        if (monitorDataSource != other.monitorDataSource) return false
        if (numItemsEvaluated != other.numItemsEvaluated) return false
        if (predictorEvent != other.predictorEvent) return false
        if (resourceArn != other.resourceArn) return false
        if (windowEndDatetime != other.windowEndDatetime) return false
        if (windowStartDatetime != other.windowStartDatetime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.PredictorMonitorEvaluation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of the monitor evaluation. The state can be `SUCCESS` or `FAILURE`.
         */
        public var evaluationState: kotlin.String? = null
        /**
         * The timestamp that indicates when the monitor evaluation was started.
         */
        public var evaluationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about any errors that may have occurred during the monitor evaluation.
         */
        public var message: kotlin.String? = null
        /**
         * A list of metrics Forecast calculated when monitoring a predictor. You can compare the value for each metric in the list to the metric's value in the Baseline to see how your predictor's performance is changing.
         */
        public var metricResults: List<MetricResult>? = null
        /**
         * The Amazon Resource Name (ARN) of the monitor resource.
         */
        public var monitorArn: kotlin.String? = null
        /**
         * The source of the data the monitor resource used during the evaluation.
         */
        public var monitorDataSource: aws.sdk.kotlin.services.forecast.model.MonitorDataSource? = null
        /**
         * The number of items considered during the evaluation.
         */
        public var numItemsEvaluated: kotlin.Long? = null
        /**
         * Provides details about a predictor event, such as a retraining.
         */
        public var predictorEvent: aws.sdk.kotlin.services.forecast.model.PredictorEvent? = null
        /**
         * The Amazon Resource Name (ARN) of the resource to monitor.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The timestamp that indicates the end of the window that is used for monitor evaluation.
         */
        public var windowEndDatetime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp that indicates the start of the window that is used for monitor evaluation.
         */
        public var windowStartDatetime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.PredictorMonitorEvaluation) : this() {
            this.evaluationState = x.evaluationState
            this.evaluationTime = x.evaluationTime
            this.message = x.message
            this.metricResults = x.metricResults
            this.monitorArn = x.monitorArn
            this.monitorDataSource = x.monitorDataSource
            this.numItemsEvaluated = x.numItemsEvaluated
            this.predictorEvent = x.predictorEvent
            this.resourceArn = x.resourceArn
            this.windowEndDatetime = x.windowEndDatetime
            this.windowStartDatetime = x.windowStartDatetime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.PredictorMonitorEvaluation = PredictorMonitorEvaluation(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.MonitorDataSource] inside the given [block]
         */
        public fun monitorDataSource(block: aws.sdk.kotlin.services.forecast.model.MonitorDataSource.Builder.() -> kotlin.Unit) {
            this.monitorDataSource = aws.sdk.kotlin.services.forecast.model.MonitorDataSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.PredictorEvent] inside the given [block]
         */
        public fun predictorEvent(block: aws.sdk.kotlin.services.forecast.model.PredictorEvent.Builder.() -> kotlin.Unit) {
            this.predictorEvent = aws.sdk.kotlin.services.forecast.model.PredictorEvent.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
