// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the predictor backtest export job properties used in the ListPredictorBacktestExportJobs operation. To get a complete set of properties, call the DescribePredictorBacktestExportJob operation, and provide the listed `PredictorBacktestExportJobArn`.
 */
public class PredictorBacktestExportJobSummary private constructor(builder: Builder) {
    /**
     * When the predictor backtest export job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The destination for an export job. Provide an S3 path, an Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an Key Management Service (KMS) key (optional).
     */
    public val destination: aws.sdk.kotlin.services.forecast.model.DataDestination? = builder.destination
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * Information about any errors that may have occurred during the backtest export.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The Amazon Resource Name (ARN) of the predictor backtest export job.
     */
    public val predictorBacktestExportJobArn: kotlin.String? = builder.predictorBacktestExportJobArn
    /**
     * The name of the predictor backtest export job.
     */
    public val predictorBacktestExportJobName: kotlin.String? = builder.predictorBacktestExportJobName
    /**
     * The status of the predictor backtest export job. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.PredictorBacktestExportJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PredictorBacktestExportJobSummary(")
        append("creationTime=$creationTime,")
        append("destination=$destination,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("predictorBacktestExportJobArn=$predictorBacktestExportJobArn,")
        append("predictorBacktestExportJobName=$predictorBacktestExportJobName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (predictorBacktestExportJobArn?.hashCode() ?: 0)
        result = 31 * result + (predictorBacktestExportJobName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PredictorBacktestExportJobSummary

        if (creationTime != other.creationTime) return false
        if (destination != other.destination) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (predictorBacktestExportJobArn != other.predictorBacktestExportJobArn) return false
        if (predictorBacktestExportJobName != other.predictorBacktestExportJobName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.PredictorBacktestExportJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the predictor backtest export job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The destination for an export job. Provide an S3 path, an Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an Key Management Service (KMS) key (optional).
         */
        public var destination: aws.sdk.kotlin.services.forecast.model.DataDestination? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about any errors that may have occurred during the backtest export.
         */
        public var message: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the predictor backtest export job.
         */
        public var predictorBacktestExportJobArn: kotlin.String? = null
        /**
         * The name of the predictor backtest export job.
         */
        public var predictorBacktestExportJobName: kotlin.String? = null
        /**
         * The status of the predictor backtest export job. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.PredictorBacktestExportJobSummary) : this() {
            this.creationTime = x.creationTime
            this.destination = x.destination
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.predictorBacktestExportJobArn = x.predictorBacktestExportJobArn
            this.predictorBacktestExportJobName = x.predictorBacktestExportJobName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.PredictorBacktestExportJobSummary = PredictorBacktestExportJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.DataDestination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.forecast.model.DataDestination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.forecast.model.DataDestination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
