// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the monitor properties used in the ListMonitors operation. To get a complete set of properties, call the DescribeMonitor operation, and provide the listed `MonitorArn`.
 */
public class MonitorSummary private constructor(builder: Builder) {
    /**
     * When the monitor resource was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The last time the monitor resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `STOPPED` - When the resource stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the monitor creation finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * The Amazon Resource Name (ARN) of the monitor resource.
     */
    public val monitorArn: kotlin.String? = builder.monitorArn
    /**
     * The name of the monitor resource.
     */
    public val monitorName: kotlin.String? = builder.monitorName
    /**
     * The Amazon Resource Name (ARN) of the predictor being monitored.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The status of the monitor. States include:
     * + `ACTIVE`
     * + `ACTIVE_STOPPING`, `ACTIVE_STOPPED`
     * + `UPDATE_IN_PROGRESS`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.MonitorSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitorSummary(")
        append("creationTime=$creationTime,")
        append("lastModificationTime=$lastModificationTime,")
        append("monitorArn=$monitorArn,")
        append("monitorName=$monitorName,")
        append("resourceArn=$resourceArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (monitorArn?.hashCode() ?: 0)
        result = 31 * result + (monitorName?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitorSummary

        if (creationTime != other.creationTime) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (monitorArn != other.monitorArn) return false
        if (monitorName != other.monitorName) return false
        if (resourceArn != other.resourceArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.MonitorSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the monitor resource was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time the monitor resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `STOPPED` - When the resource stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the monitor creation finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the monitor resource.
         */
        public var monitorArn: kotlin.String? = null
        /**
         * The name of the monitor resource.
         */
        public var monitorName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the predictor being monitored.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The status of the monitor. States include:
         * + `ACTIVE`
         * + `ACTIVE_STOPPING`, `ACTIVE_STOPPED`
         * + `UPDATE_IN_PROGRESS`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.MonitorSummary) : this() {
            this.creationTime = x.creationTime
            this.lastModificationTime = x.lastModificationTime
            this.monitorArn = x.monitorArn
            this.monitorName = x.monitorName
            this.resourceArn = x.resourceArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.MonitorSummary = MonitorSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
