// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration information for a hyperparameter tuning job. You specify this object in the CreatePredictor request.
 *
 * A *hyperparameter* is a parameter that governs the model training process. You set hyperparameters before training starts, unlike model parameters, which are determined during training. The values of the hyperparameters effect which values are chosen for the model parameters.
 *
 * In a *hyperparameter tuning job*, Amazon Forecast chooses the set of hyperparameter values that optimize a specified metric. Forecast accomplishes this by running many training jobs over a range of hyperparameter values. The optimum set of values depends on the algorithm, the training data, and the specified metric objective.
 */
public class HyperParameterTuningJobConfig private constructor(builder: Builder) {
    /**
     * Specifies the ranges of valid values for the hyperparameters.
     */
    public val parameterRanges: aws.sdk.kotlin.services.forecast.model.ParameterRanges? = builder.parameterRanges

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterTuningJobConfig(")
        append("parameterRanges=$parameterRanges")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = parameterRanges?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterTuningJobConfig

        if (parameterRanges != other.parameterRanges) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the ranges of valid values for the hyperparameters.
         */
        public var parameterRanges: aws.sdk.kotlin.services.forecast.model.ParameterRanges? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig) : this() {
            this.parameterRanges = x.parameterRanges
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig = HyperParameterTuningJobConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.ParameterRanges] inside the given [block]
         */
        public fun parameterRanges(block: aws.sdk.kotlin.services.forecast.model.ParameterRanges.Builder.() -> kotlin.Unit) {
            this.parameterRanges = aws.sdk.kotlin.services.forecast.model.ParameterRanges.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
