// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the method that featurizes (transforms) a dataset field. The method is part of the `FeaturizationPipeline` of the Featurization object.
 *
 * The following is an example of how you specify a `FeaturizationMethod` object.
 *
 * `{`
 *
 * `"FeaturizationMethodName": "filling",`
 *
 * `"FeaturizationMethodParameters": {"aggregation": "sum", "middlefill": "zero", "backfill": "zero"}`
 *
 * `}`
 */
public class FeaturizationMethod private constructor(builder: Builder) {
    /**
     * The name of the method. The "filling" method is the only supported method.
     */
    public val featurizationMethodName: aws.sdk.kotlin.services.forecast.model.FeaturizationMethodName = requireNotNull(builder.featurizationMethodName) { "A non-null value must be provided for featurizationMethodName" }
    /**
     * The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.
     *
     * The following list shows the parameters and their valid values for the "filling" featurization method for a **Target Time Series** dataset. Bold signifies the default value.
     * + `aggregation`: **sum**, `avg`, `first`, `min`, `max`
     * + `frontfill`: **none**
     * + `middlefill`: **zero**, `nan` (not a number), `value`, `median`, `mean`, `min`, `max`
     * + `backfill`: **zero**, `nan`, `value`, `median`, `mean`, `min`, `max`
     *
     * The following list shows the parameters and their valid values for a **Related Time Series** featurization method (there are no defaults):
     * + `middlefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
     * + `backfill`: `zero`, `value`, `median`, `mean`, `min`, `max`
     * + `futurefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
     *
     * To set a filling method to a specific value, set the fill parameter to `value` and define the value in a corresponding `_value` parameter. For example, to set backfilling to a value of 2, include the following: `"backfill": "value"` and `"backfill_value":"2"`.
     */
    public val featurizationMethodParameters: Map<String, String>? = builder.featurizationMethodParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.FeaturizationMethod = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FeaturizationMethod(")
        append("featurizationMethodName=$featurizationMethodName,")
        append("featurizationMethodParameters=$featurizationMethodParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = featurizationMethodName.hashCode()
        result = 31 * result + (featurizationMethodParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FeaturizationMethod

        if (featurizationMethodName != other.featurizationMethodName) return false
        if (featurizationMethodParameters != other.featurizationMethodParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.FeaturizationMethod = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the method. The "filling" method is the only supported method.
         */
        public var featurizationMethodName: aws.sdk.kotlin.services.forecast.model.FeaturizationMethodName? = null
        /**
         * The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.
         *
         * The following list shows the parameters and their valid values for the "filling" featurization method for a **Target Time Series** dataset. Bold signifies the default value.
         * + `aggregation`: **sum**, `avg`, `first`, `min`, `max`
         * + `frontfill`: **none**
         * + `middlefill`: **zero**, `nan` (not a number), `value`, `median`, `mean`, `min`, `max`
         * + `backfill`: **zero**, `nan`, `value`, `median`, `mean`, `min`, `max`
         *
         * The following list shows the parameters and their valid values for a **Related Time Series** featurization method (there are no defaults):
         * + `middlefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
         * + `backfill`: `zero`, `value`, `median`, `mean`, `min`, `max`
         * + `futurefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
         *
         * To set a filling method to a specific value, set the fill parameter to `value` and define the value in a corresponding `_value` parameter. For example, to set backfilling to a value of 2, include the following: `"backfill": "value"` and `"backfill_value":"2"`.
         */
        public var featurizationMethodParameters: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.FeaturizationMethod) : this() {
            this.featurizationMethodName = x.featurizationMethodName
            this.featurizationMethodParameters = x.featurizationMethodParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.FeaturizationMethod = FeaturizationMethod(this)

        internal fun correctErrors(): Builder {
            if (featurizationMethodName == null) featurizationMethodName = FeaturizationMethodName.SdkUnknown("no value provided")
            return this
        }
    }
}
