// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribePredictorResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the algorithm used for model training.
     */
    public val algorithmArn: kotlin.String? = builder.algorithmArn
    /**
     * When `PerformAutoML` is specified, the ARN of the chosen algorithm.
     */
    public val autoMlAlgorithmArns: List<String>? = builder.autoMlAlgorithmArns
    /**
     * The `LatencyOptimized` AutoML override strategy is only available in private beta. Contact Amazon Web Services Support or your account manager to learn more about access privileges.
     *
     * The AutoML strategy used to train the predictor. Unless `LatencyOptimized` is specified, the AutoML strategy optimizes predictor accuracy.
     *
     * This parameter is only valid for predictors trained using AutoML.
     */
    public val autoMlOverrideStrategy: aws.sdk.kotlin.services.forecast.model.AutoMlOverrideStrategy? = builder.autoMlOverrideStrategy
    /**
     * When the model training task was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * An array of the ARNs of the dataset import jobs used to import training data for the predictor.
     */
    public val datasetImportJobArns: List<String>? = builder.datasetImportJobArns
    /**
     * An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
     */
    public val encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = builder.encryptionConfig
    /**
     * The estimated time remaining in minutes for the predictor training job to complete.
     */
    public val estimatedTimeRemainingInMinutes: kotlin.Long? = builder.estimatedTimeRemainingInMinutes
    /**
     * Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates a predictor by splitting a dataset into training data and testing data. The evaluation parameters define how to perform the split and the number of iterations.
     */
    public val evaluationParameters: aws.sdk.kotlin.services.forecast.model.EvaluationParameters? = builder.evaluationParameters
    /**
     * The featurization configuration.
     */
    public val featurizationConfig: aws.sdk.kotlin.services.forecast.model.FeaturizationConfig? = builder.featurizationConfig
    /**
     * The number of time-steps of the forecast. The forecast horizon is also called the prediction length.
     */
    public val forecastHorizon: kotlin.Int? = builder.forecastHorizon
    /**
     * The forecast types used during predictor training. Default value is `["0.1","0.5","0.9"]`
     */
    public val forecastTypes: List<String>? = builder.forecastTypes
    /**
     * The hyperparameter override values for the algorithm.
     */
    public val hpoConfig: aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig? = builder.hpoConfig
    /**
     * Describes the dataset group that contains the data to use to train the predictor.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.forecast.model.InputDataConfig? = builder.inputDataConfig
    /**
     * Whether the predictor was created with CreateAutoPredictor.
     */
    public val isAutoPredictor: kotlin.Boolean? = builder.isAutoPredictor
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * If an error occurred, an informational message about the error.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The accuracy metric used to optimize the predictor.
     */
    public val optimizationMetric: aws.sdk.kotlin.services.forecast.model.OptimizationMetric? = builder.optimizationMetric
    /**
     * Whether the predictor is set to perform AutoML.
     */
    public val performAutoMl: kotlin.Boolean? = builder.performAutoMl
    /**
     * Whether the predictor is set to perform hyperparameter optimization (HPO).
     */
    public val performHpo: kotlin.Boolean? = builder.performHpo
    /**
     * The ARN of the predictor.
     */
    public val predictorArn: kotlin.String? = builder.predictorArn
    /**
     * Details on the the status and results of the backtests performed to evaluate the accuracy of the predictor. You specify the number of backtests to perform when you call the operation.
     */
    public val predictorExecutionDetails: aws.sdk.kotlin.services.forecast.model.PredictorExecutionDetails? = builder.predictorExecutionDetails
    /**
     * The name of the predictor.
     */
    public val predictorName: kotlin.String? = builder.predictorName
    /**
     * The status of the predictor. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     *
     * The `Status` of the predictor must be `ACTIVE` before you can use the predictor to create a forecast.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The default training parameters or overrides selected during model training. When running AutoML or choosing HPO with CNN-QR or DeepAR+, the optimized values for the chosen hyperparameters are returned. For more information, see aws-forecast-choosing-recipes.
     */
    public val trainingParameters: Map<String, String>? = builder.trainingParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.DescribePredictorResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePredictorResponse(")
        append("algorithmArn=$algorithmArn,")
        append("autoMlAlgorithmArns=$autoMlAlgorithmArns,")
        append("autoMlOverrideStrategy=$autoMlOverrideStrategy,")
        append("creationTime=$creationTime,")
        append("datasetImportJobArns=$datasetImportJobArns,")
        append("encryptionConfig=$encryptionConfig,")
        append("estimatedTimeRemainingInMinutes=$estimatedTimeRemainingInMinutes,")
        append("evaluationParameters=$evaluationParameters,")
        append("featurizationConfig=$featurizationConfig,")
        append("forecastHorizon=$forecastHorizon,")
        append("forecastTypes=$forecastTypes,")
        append("hpoConfig=$hpoConfig,")
        append("inputDataConfig=$inputDataConfig,")
        append("isAutoPredictor=$isAutoPredictor,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("optimizationMetric=$optimizationMetric,")
        append("performAutoMl=$performAutoMl,")
        append("performHpo=$performHpo,")
        append("predictorArn=$predictorArn,")
        append("predictorExecutionDetails=$predictorExecutionDetails,")
        append("predictorName=$predictorName,")
        append("status=$status,")
        append("trainingParameters=$trainingParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmArn?.hashCode() ?: 0
        result = 31 * result + (autoMlAlgorithmArns?.hashCode() ?: 0)
        result = 31 * result + (autoMlOverrideStrategy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (datasetImportJobArns?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (estimatedTimeRemainingInMinutes?.hashCode() ?: 0)
        result = 31 * result + (evaluationParameters?.hashCode() ?: 0)
        result = 31 * result + (featurizationConfig?.hashCode() ?: 0)
        result = 31 * result + (forecastHorizon ?: 0)
        result = 31 * result + (forecastTypes?.hashCode() ?: 0)
        result = 31 * result + (hpoConfig?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (isAutoPredictor?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (optimizationMetric?.hashCode() ?: 0)
        result = 31 * result + (performAutoMl?.hashCode() ?: 0)
        result = 31 * result + (performHpo?.hashCode() ?: 0)
        result = 31 * result + (predictorArn?.hashCode() ?: 0)
        result = 31 * result + (predictorExecutionDetails?.hashCode() ?: 0)
        result = 31 * result + (predictorName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trainingParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePredictorResponse

        if (algorithmArn != other.algorithmArn) return false
        if (autoMlAlgorithmArns != other.autoMlAlgorithmArns) return false
        if (autoMlOverrideStrategy != other.autoMlOverrideStrategy) return false
        if (creationTime != other.creationTime) return false
        if (datasetImportJobArns != other.datasetImportJobArns) return false
        if (encryptionConfig != other.encryptionConfig) return false
        if (estimatedTimeRemainingInMinutes != other.estimatedTimeRemainingInMinutes) return false
        if (evaluationParameters != other.evaluationParameters) return false
        if (featurizationConfig != other.featurizationConfig) return false
        if (forecastHorizon != other.forecastHorizon) return false
        if (forecastTypes != other.forecastTypes) return false
        if (hpoConfig != other.hpoConfig) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (isAutoPredictor != other.isAutoPredictor) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (optimizationMetric != other.optimizationMetric) return false
        if (performAutoMl != other.performAutoMl) return false
        if (performHpo != other.performHpo) return false
        if (predictorArn != other.predictorArn) return false
        if (predictorExecutionDetails != other.predictorExecutionDetails) return false
        if (predictorName != other.predictorName) return false
        if (status != other.status) return false
        if (trainingParameters != other.trainingParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.DescribePredictorResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the algorithm used for model training.
         */
        public var algorithmArn: kotlin.String? = null
        /**
         * When `PerformAutoML` is specified, the ARN of the chosen algorithm.
         */
        public var autoMlAlgorithmArns: List<String>? = null
        /**
         * The `LatencyOptimized` AutoML override strategy is only available in private beta. Contact Amazon Web Services Support or your account manager to learn more about access privileges.
         *
         * The AutoML strategy used to train the predictor. Unless `LatencyOptimized` is specified, the AutoML strategy optimizes predictor accuracy.
         *
         * This parameter is only valid for predictors trained using AutoML.
         */
        public var autoMlOverrideStrategy: aws.sdk.kotlin.services.forecast.model.AutoMlOverrideStrategy? = null
        /**
         * When the model training task was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of the ARNs of the dataset import jobs used to import training data for the predictor.
         */
        public var datasetImportJobArns: List<String>? = null
        /**
         * An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
         */
        public var encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = null
        /**
         * The estimated time remaining in minutes for the predictor training job to complete.
         */
        public var estimatedTimeRemainingInMinutes: kotlin.Long? = null
        /**
         * Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates a predictor by splitting a dataset into training data and testing data. The evaluation parameters define how to perform the split and the number of iterations.
         */
        public var evaluationParameters: aws.sdk.kotlin.services.forecast.model.EvaluationParameters? = null
        /**
         * The featurization configuration.
         */
        public var featurizationConfig: aws.sdk.kotlin.services.forecast.model.FeaturizationConfig? = null
        /**
         * The number of time-steps of the forecast. The forecast horizon is also called the prediction length.
         */
        public var forecastHorizon: kotlin.Int? = null
        /**
         * The forecast types used during predictor training. Default value is `["0.1","0.5","0.9"]`
         */
        public var forecastTypes: List<String>? = null
        /**
         * The hyperparameter override values for the algorithm.
         */
        public var hpoConfig: aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig? = null
        /**
         * Describes the dataset group that contains the data to use to train the predictor.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.forecast.model.InputDataConfig? = null
        /**
         * Whether the predictor was created with CreateAutoPredictor.
         */
        public var isAutoPredictor: kotlin.Boolean? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If an error occurred, an informational message about the error.
         */
        public var message: kotlin.String? = null
        /**
         * The accuracy metric used to optimize the predictor.
         */
        public var optimizationMetric: aws.sdk.kotlin.services.forecast.model.OptimizationMetric? = null
        /**
         * Whether the predictor is set to perform AutoML.
         */
        public var performAutoMl: kotlin.Boolean? = null
        /**
         * Whether the predictor is set to perform hyperparameter optimization (HPO).
         */
        public var performHpo: kotlin.Boolean? = null
        /**
         * The ARN of the predictor.
         */
        public var predictorArn: kotlin.String? = null
        /**
         * Details on the the status and results of the backtests performed to evaluate the accuracy of the predictor. You specify the number of backtests to perform when you call the operation.
         */
        public var predictorExecutionDetails: aws.sdk.kotlin.services.forecast.model.PredictorExecutionDetails? = null
        /**
         * The name of the predictor.
         */
        public var predictorName: kotlin.String? = null
        /**
         * The status of the predictor. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         *
         * The `Status` of the predictor must be `ACTIVE` before you can use the predictor to create a forecast.
         */
        public var status: kotlin.String? = null
        /**
         * The default training parameters or overrides selected during model training. When running AutoML or choosing HPO with CNN-QR or DeepAR+, the optimized values for the chosen hyperparameters are returned. For more information, see aws-forecast-choosing-recipes.
         */
        public var trainingParameters: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.DescribePredictorResponse) : this() {
            this.algorithmArn = x.algorithmArn
            this.autoMlAlgorithmArns = x.autoMlAlgorithmArns
            this.autoMlOverrideStrategy = x.autoMlOverrideStrategy
            this.creationTime = x.creationTime
            this.datasetImportJobArns = x.datasetImportJobArns
            this.encryptionConfig = x.encryptionConfig
            this.estimatedTimeRemainingInMinutes = x.estimatedTimeRemainingInMinutes
            this.evaluationParameters = x.evaluationParameters
            this.featurizationConfig = x.featurizationConfig
            this.forecastHorizon = x.forecastHorizon
            this.forecastTypes = x.forecastTypes
            this.hpoConfig = x.hpoConfig
            this.inputDataConfig = x.inputDataConfig
            this.isAutoPredictor = x.isAutoPredictor
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.optimizationMetric = x.optimizationMetric
            this.performAutoMl = x.performAutoMl
            this.performHpo = x.performHpo
            this.predictorArn = x.predictorArn
            this.predictorExecutionDetails = x.predictorExecutionDetails
            this.predictorName = x.predictorName
            this.status = x.status
            this.trainingParameters = x.trainingParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.DescribePredictorResponse = DescribePredictorResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.EncryptionConfig] inside the given [block]
         */
        public fun encryptionConfig(block: aws.sdk.kotlin.services.forecast.model.EncryptionConfig.Builder.() -> kotlin.Unit) {
            this.encryptionConfig = aws.sdk.kotlin.services.forecast.model.EncryptionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.EvaluationParameters] inside the given [block]
         */
        public fun evaluationParameters(block: aws.sdk.kotlin.services.forecast.model.EvaluationParameters.Builder.() -> kotlin.Unit) {
            this.evaluationParameters = aws.sdk.kotlin.services.forecast.model.EvaluationParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.FeaturizationConfig] inside the given [block]
         */
        public fun featurizationConfig(block: aws.sdk.kotlin.services.forecast.model.FeaturizationConfig.Builder.() -> kotlin.Unit) {
            this.featurizationConfig = aws.sdk.kotlin.services.forecast.model.FeaturizationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig] inside the given [block]
         */
        public fun hpoConfig(block: aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig.Builder.() -> kotlin.Unit) {
            this.hpoConfig = aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.forecast.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.forecast.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.PredictorExecutionDetails] inside the given [block]
         */
        public fun predictorExecutionDetails(block: aws.sdk.kotlin.services.forecast.model.PredictorExecutionDetails.Builder.() -> kotlin.Unit) {
            this.predictorExecutionDetails = aws.sdk.kotlin.services.forecast.model.PredictorExecutionDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
