// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeDatasetResponse private constructor(builder: Builder) {
    /**
     * When the dataset was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The frequency of data collection.
     *
     * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "M" indicates every month and "30min" indicates every 30 minutes.
     */
    public val dataFrequency: kotlin.String? = builder.dataFrequency
    /**
     * The Amazon Resource Name (ARN) of the dataset.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The name of the dataset.
     */
    public val datasetName: kotlin.String? = builder.datasetName
    /**
     * The dataset type.
     */
    public val datasetType: aws.sdk.kotlin.services.forecast.model.DatasetType? = builder.datasetType
    /**
     * The domain associated with the dataset.
     */
    public val domain: aws.sdk.kotlin.services.forecast.model.Domain? = builder.domain
    /**
     * The Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
     */
    public val encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = builder.encryptionConfig
    /**
     * When you create a dataset, `LastModificationTime` is the same as `CreationTime`. While data is being imported to the dataset, `LastModificationTime` is the current time of the `DescribeDataset` call. After a [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation has finished, `LastModificationTime` is when the import job completed or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * An array of `SchemaAttribute` objects that specify the dataset fields. Each `SchemaAttribute` specifies the name and data type of a field.
     */
    public val schema: aws.sdk.kotlin.services.forecast.model.Schema? = builder.schema
    /**
     * The status of the dataset. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     * + `UPDATE_PENDING`, `UPDATE_IN_PROGRESS`, `UPDATE_FAILED`
     *
     * The `UPDATE` states apply while data is imported to the dataset from a call to the [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation and reflect the status of the dataset import job. For example, when the import job status is `CREATE_IN_PROGRESS`, the status of the dataset is `UPDATE_IN_PROGRESS`.
     *
     * The `Status` of the dataset must be `ACTIVE` before you can import training data.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.DescribeDatasetResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDatasetResponse(")
        append("creationTime=$creationTime,")
        append("dataFrequency=$dataFrequency,")
        append("datasetArn=$datasetArn,")
        append("datasetName=$datasetName,")
        append("datasetType=$datasetType,")
        append("domain=$domain,")
        append("encryptionConfig=$encryptionConfig,")
        append("lastModificationTime=$lastModificationTime,")
        append("schema=$schema,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (dataFrequency?.hashCode() ?: 0)
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetName?.hashCode() ?: 0)
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDatasetResponse

        if (creationTime != other.creationTime) return false
        if (dataFrequency != other.dataFrequency) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetName != other.datasetName) return false
        if (datasetType != other.datasetType) return false
        if (domain != other.domain) return false
        if (encryptionConfig != other.encryptionConfig) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (schema != other.schema) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.DescribeDatasetResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the dataset was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The frequency of data collection.
         *
         * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "M" indicates every month and "30min" indicates every 30 minutes.
         */
        public var dataFrequency: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * The name of the dataset.
         */
        public var datasetName: kotlin.String? = null
        /**
         * The dataset type.
         */
        public var datasetType: aws.sdk.kotlin.services.forecast.model.DatasetType? = null
        /**
         * The domain associated with the dataset.
         */
        public var domain: aws.sdk.kotlin.services.forecast.model.Domain? = null
        /**
         * The Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
         */
        public var encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = null
        /**
         * When you create a dataset, `LastModificationTime` is the same as `CreationTime`. While data is being imported to the dataset, `LastModificationTime` is the current time of the `DescribeDataset` call. After a [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation has finished, `LastModificationTime` is when the import job completed or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of `SchemaAttribute` objects that specify the dataset fields. Each `SchemaAttribute` specifies the name and data type of a field.
         */
        public var schema: aws.sdk.kotlin.services.forecast.model.Schema? = null
        /**
         * The status of the dataset. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         * + `UPDATE_PENDING`, `UPDATE_IN_PROGRESS`, `UPDATE_FAILED`
         *
         * The `UPDATE` states apply while data is imported to the dataset from a call to the [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation and reflect the status of the dataset import job. For example, when the import job status is `CREATE_IN_PROGRESS`, the status of the dataset is `UPDATE_IN_PROGRESS`.
         *
         * The `Status` of the dataset must be `ACTIVE` before you can import training data.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.DescribeDatasetResponse) : this() {
            this.creationTime = x.creationTime
            this.dataFrequency = x.dataFrequency
            this.datasetArn = x.datasetArn
            this.datasetName = x.datasetName
            this.datasetType = x.datasetType
            this.domain = x.domain
            this.encryptionConfig = x.encryptionConfig
            this.lastModificationTime = x.lastModificationTime
            this.schema = x.schema
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.DescribeDatasetResponse = DescribeDatasetResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.EncryptionConfig] inside the given [block]
         */
        public fun encryptionConfig(block: aws.sdk.kotlin.services.forecast.model.EncryptionConfig.Builder.() -> kotlin.Unit) {
            this.encryptionConfig = aws.sdk.kotlin.services.forecast.model.EncryptionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.Schema] inside the given [block]
         */
        public fun schema(block: aws.sdk.kotlin.services.forecast.model.Schema.Builder.() -> kotlin.Unit) {
            this.schema = aws.sdk.kotlin.services.forecast.model.Schema.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
