// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeDatasetImportJobResponse private constructor(builder: Builder) {
    /**
     * When the dataset import job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The size of the dataset in gigabytes (GB) after the import job has finished.
     */
    public val dataSize: kotlin.Double? = builder.dataSize
    /**
     * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data.
     *
     * If encryption is used, `DataSource` includes an Key Management Service (KMS) key.
     */
    public val dataSource: aws.sdk.kotlin.services.forecast.model.DataSource? = builder.dataSource
    /**
     * The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The ARN of the dataset import job.
     */
    public val datasetImportJobArn: kotlin.String? = builder.datasetImportJobArn
    /**
     * The name of the dataset import job.
     */
    public val datasetImportJobName: kotlin.String? = builder.datasetImportJobName
    /**
     * The estimated time remaining in minutes for the dataset import job to complete.
     */
    public val estimatedTimeRemainingInMinutes: kotlin.Long? = builder.estimatedTimeRemainingInMinutes
    /**
     * Statistical information about each field in the input data.
     */
    public val fieldStatistics: Map<String, Statistics>? = builder.fieldStatistics
    /**
     * The format of the imported data, CSV or PARQUET.
     */
    public val format: kotlin.String? = builder.format
    /**
     * The format of the geolocation attribute. Valid Values:`"LAT_LONG"` and `"CC_POSTALCODE"`.
     */
    public val geolocationFormat: kotlin.String? = builder.geolocationFormat
    /**
     * The import mode of the dataset import job, FULL or INCREMENTAL.
     */
    public val importMode: aws.sdk.kotlin.services.forecast.model.ImportMode? = builder.importMode
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * If an error occurred, an informational message about the error.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The status of the dataset import job. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     */
    public val status: kotlin.String? = builder.status
    /**
     * The single time zone applied to every item in the dataset
     */
    public val timeZone: kotlin.String? = builder.timeZone
    /**
     * The format of timestamps in the dataset. The format that you specify depends on the `DataFrequency` specified when the dataset was created. The following formats are supported
     * + "yyyy-MM-dd"For the following data frequencies: Y, M, W, and D
     * + "yyyy-MM-dd HH:mm:ss"For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     */
    public val timestampFormat: kotlin.String? = builder.timestampFormat
    /**
     * Whether `TimeZone` is automatically derived from the geolocation attribute.
     */
    public val useGeolocationForTimeZone: kotlin.Boolean = builder.useGeolocationForTimeZone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.DescribeDatasetImportJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDatasetImportJobResponse(")
        append("creationTime=$creationTime,")
        append("dataSize=$dataSize,")
        append("dataSource=$dataSource,")
        append("datasetArn=$datasetArn,")
        append("datasetImportJobArn=$datasetImportJobArn,")
        append("datasetImportJobName=$datasetImportJobName,")
        append("estimatedTimeRemainingInMinutes=$estimatedTimeRemainingInMinutes,")
        append("fieldStatistics=$fieldStatistics,")
        append("format=$format,")
        append("geolocationFormat=$geolocationFormat,")
        append("importMode=$importMode,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("status=$status,")
        append("timeZone=$timeZone,")
        append("timestampFormat=$timestampFormat,")
        append("useGeolocationForTimeZone=$useGeolocationForTimeZone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (dataSize?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetImportJobArn?.hashCode() ?: 0)
        result = 31 * result + (datasetImportJobName?.hashCode() ?: 0)
        result = 31 * result + (estimatedTimeRemainingInMinutes?.hashCode() ?: 0)
        result = 31 * result + (fieldStatistics?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (geolocationFormat?.hashCode() ?: 0)
        result = 31 * result + (importMode?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (timeZone?.hashCode() ?: 0)
        result = 31 * result + (timestampFormat?.hashCode() ?: 0)
        result = 31 * result + (useGeolocationForTimeZone.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDatasetImportJobResponse

        if (creationTime != other.creationTime) return false
        if (!(dataSize?.equals(other.dataSize) ?: (other.dataSize == null))) return false
        if (dataSource != other.dataSource) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetImportJobArn != other.datasetImportJobArn) return false
        if (datasetImportJobName != other.datasetImportJobName) return false
        if (estimatedTimeRemainingInMinutes != other.estimatedTimeRemainingInMinutes) return false
        if (fieldStatistics != other.fieldStatistics) return false
        if (format != other.format) return false
        if (geolocationFormat != other.geolocationFormat) return false
        if (importMode != other.importMode) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (status != other.status) return false
        if (timeZone != other.timeZone) return false
        if (timestampFormat != other.timestampFormat) return false
        if (useGeolocationForTimeZone != other.useGeolocationForTimeZone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.DescribeDatasetImportJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the dataset import job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The size of the dataset in gigabytes (GB) after the import job has finished.
         */
        public var dataSize: kotlin.Double? = null
        /**
         * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data.
         *
         * If encryption is used, `DataSource` includes an Key Management Service (KMS) key.
         */
        public var dataSource: aws.sdk.kotlin.services.forecast.model.DataSource? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * The ARN of the dataset import job.
         */
        public var datasetImportJobArn: kotlin.String? = null
        /**
         * The name of the dataset import job.
         */
        public var datasetImportJobName: kotlin.String? = null
        /**
         * The estimated time remaining in minutes for the dataset import job to complete.
         */
        public var estimatedTimeRemainingInMinutes: kotlin.Long? = null
        /**
         * Statistical information about each field in the input data.
         */
        public var fieldStatistics: Map<String, Statistics>? = null
        /**
         * The format of the imported data, CSV or PARQUET.
         */
        public var format: kotlin.String? = null
        /**
         * The format of the geolocation attribute. Valid Values:`"LAT_LONG"` and `"CC_POSTALCODE"`.
         */
        public var geolocationFormat: kotlin.String? = null
        /**
         * The import mode of the dataset import job, FULL or INCREMENTAL.
         */
        public var importMode: aws.sdk.kotlin.services.forecast.model.ImportMode? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If an error occurred, an informational message about the error.
         */
        public var message: kotlin.String? = null
        /**
         * The status of the dataset import job. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         */
        public var status: kotlin.String? = null
        /**
         * The single time zone applied to every item in the dataset
         */
        public var timeZone: kotlin.String? = null
        /**
         * The format of timestamps in the dataset. The format that you specify depends on the `DataFrequency` specified when the dataset was created. The following formats are supported
         * + "yyyy-MM-dd"For the following data frequencies: Y, M, W, and D
         * + "yyyy-MM-dd HH:mm:ss"For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         */
        public var timestampFormat: kotlin.String? = null
        /**
         * Whether `TimeZone` is automatically derived from the geolocation attribute.
         */
        public var useGeolocationForTimeZone: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.DescribeDatasetImportJobResponse) : this() {
            this.creationTime = x.creationTime
            this.dataSize = x.dataSize
            this.dataSource = x.dataSource
            this.datasetArn = x.datasetArn
            this.datasetImportJobArn = x.datasetImportJobArn
            this.datasetImportJobName = x.datasetImportJobName
            this.estimatedTimeRemainingInMinutes = x.estimatedTimeRemainingInMinutes
            this.fieldStatistics = x.fieldStatistics
            this.format = x.format
            this.geolocationFormat = x.geolocationFormat
            this.importMode = x.importMode
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.status = x.status
            this.timeZone = x.timeZone
            this.timestampFormat = x.timestampFormat
            this.useGeolocationForTimeZone = x.useGeolocationForTimeZone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.DescribeDatasetImportJobResponse = DescribeDatasetImportJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.DataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.forecast.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.forecast.model.DataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
