// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the dataset properties used in the [ListDatasets](https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasets.html) operation. To get the complete set of properties, call the [DescribeDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html) operation, and provide the `DatasetArn`.
 */
public class DatasetSummary private constructor(builder: Builder) {
    /**
     * When the dataset was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the dataset.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The name of the dataset.
     */
    public val datasetName: kotlin.String? = builder.datasetName
    /**
     * The dataset type.
     */
    public val datasetType: aws.sdk.kotlin.services.forecast.model.DatasetType? = builder.datasetType
    /**
     * The domain associated with the dataset.
     */
    public val domain: aws.sdk.kotlin.services.forecast.model.Domain? = builder.domain
    /**
     * When you create a dataset, `LastModificationTime` is the same as `CreationTime`. While data is being imported to the dataset, `LastModificationTime` is the current time of the `ListDatasets` call. After a [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation has finished, `LastModificationTime` is when the import job completed or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.DatasetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetSummary(")
        append("creationTime=$creationTime,")
        append("datasetArn=$datasetArn,")
        append("datasetName=$datasetName,")
        append("datasetType=$datasetType,")
        append("domain=$domain,")
        append("lastModificationTime=$lastModificationTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetName?.hashCode() ?: 0)
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetSummary

        if (creationTime != other.creationTime) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetName != other.datasetName) return false
        if (datasetType != other.datasetType) return false
        if (domain != other.domain) return false
        if (lastModificationTime != other.lastModificationTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.DatasetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the dataset was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * The name of the dataset.
         */
        public var datasetName: kotlin.String? = null
        /**
         * The dataset type.
         */
        public var datasetType: aws.sdk.kotlin.services.forecast.model.DatasetType? = null
        /**
         * The domain associated with the dataset.
         */
        public var domain: aws.sdk.kotlin.services.forecast.model.Domain? = null
        /**
         * When you create a dataset, `LastModificationTime` is the same as `CreationTime`. While data is being imported to the dataset, `LastModificationTime` is the current time of the `ListDatasets` call. After a [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation has finished, `LastModificationTime` is when the import job completed or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.DatasetSummary) : this() {
            this.creationTime = x.creationTime
            this.datasetArn = x.datasetArn
            this.datasetName = x.datasetName
            this.datasetType = x.datasetType
            this.domain = x.domain
            this.lastModificationTime = x.lastModificationTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.DatasetSummary = DatasetSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
