// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the dataset group properties used in the [ListDatasetGroups](https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetGroups.html) operation. To get the complete set of properties, call the [DescribeDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html) operation, and provide the `DatasetGroupArn`.
 */
public class DatasetGroupSummary private constructor(builder: Builder) {
    /**
     * When the dataset group was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the dataset group.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The name of the dataset group.
     */
    public val datasetGroupName: kotlin.String? = builder.datasetGroupName
    /**
     * When the dataset group was created or last updated from a call to the [UpdateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html) operation. While the dataset group is being updated, `LastModificationTime` is the current time of the `ListDatasetGroups` call.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.DatasetGroupSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetGroupSummary(")
        append("creationTime=$creationTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("datasetGroupName=$datasetGroupName,")
        append("lastModificationTime=$lastModificationTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (datasetGroupName?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetGroupSummary

        if (creationTime != other.creationTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (datasetGroupName != other.datasetGroupName) return false
        if (lastModificationTime != other.lastModificationTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.DatasetGroupSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the dataset group was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * The name of the dataset group.
         */
        public var datasetGroupName: kotlin.String? = null
        /**
         * When the dataset group was created or last updated from a call to the [UpdateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html) operation. While the dataset group is being updated, `LastModificationTime` is the current time of the `ListDatasetGroups` call.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.DatasetGroupSummary) : this() {
            this.creationTime = x.creationTime
            this.datasetGroupArn = x.datasetGroupArn
            this.datasetGroupName = x.datasetGroupName
            this.lastModificationTime = x.lastModificationTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.DatasetGroupSummary = DatasetGroupSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
