// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateForecastExportJobRequest private constructor(builder: Builder) {
    /**
     * The location where you want to save the forecast and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3 bucket.
     *
     * If encryption is used, `Destination` must include an Key Management Service (KMS) key. The IAM role must allow Amazon Forecast permission to access the key.
     */
    public val destination: aws.sdk.kotlin.services.forecast.model.DataDestination? = builder.destination
    /**
     * The Amazon Resource Name (ARN) of the forecast that you want to export.
     */
    public val forecastArn: kotlin.String? = builder.forecastArn
    /**
     * The name for the forecast export job.
     */
    public val forecastExportJobName: kotlin.String? = builder.forecastExportJobName
    /**
     * The format of the exported data, CSV or PARQUET. The default value is CSV.
     */
    public val format: kotlin.String? = builder.format
    /**
     * The optional metadata that you apply to the forecast export job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.CreateForecastExportJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateForecastExportJobRequest(")
        append("destination=$destination,")
        append("forecastArn=$forecastArn,")
        append("forecastExportJobName=$forecastExportJobName,")
        append("format=$format,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (forecastArn?.hashCode() ?: 0)
        result = 31 * result + (forecastExportJobName?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateForecastExportJobRequest

        if (destination != other.destination) return false
        if (forecastArn != other.forecastArn) return false
        if (forecastExportJobName != other.forecastExportJobName) return false
        if (format != other.format) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.CreateForecastExportJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The location where you want to save the forecast and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3 bucket.
         *
         * If encryption is used, `Destination` must include an Key Management Service (KMS) key. The IAM role must allow Amazon Forecast permission to access the key.
         */
        public var destination: aws.sdk.kotlin.services.forecast.model.DataDestination? = null
        /**
         * The Amazon Resource Name (ARN) of the forecast that you want to export.
         */
        public var forecastArn: kotlin.String? = null
        /**
         * The name for the forecast export job.
         */
        public var forecastExportJobName: kotlin.String? = null
        /**
         * The format of the exported data, CSV or PARQUET. The default value is CSV.
         */
        public var format: kotlin.String? = null
        /**
         * The optional metadata that you apply to the forecast export job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.CreateForecastExportJobRequest) : this() {
            this.destination = x.destination
            this.forecastArn = x.forecastArn
            this.forecastExportJobName = x.forecastExportJobName
            this.format = x.format
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.CreateForecastExportJobRequest = CreateForecastExportJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.DataDestination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.forecast.model.DataDestination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.forecast.model.DataDestination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
