// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateExplainabilityRequest private constructor(builder: Builder) {
    /**
     * The source of your data, an Identity and Access Management (IAM) role that allows Amazon Forecast to access the data and, optionally, an Key Management Service (KMS) key.
     */
    public val dataSource: aws.sdk.kotlin.services.forecast.model.DataSource? = builder.dataSource
    /**
     * Create an Explainability visualization that is viewable within the Amazon Web Services console.
     */
    public val enableVisualization: kotlin.Boolean? = builder.enableVisualization
    /**
     * If `TimePointGranularity` is set to `SPECIFIC`, define the last time point for the Explainability.
     *
     * Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
     */
    public val endDateTime: kotlin.String? = builder.endDateTime
    /**
     * The configuration settings that define the granularity of time series and time points for the Explainability.
     */
    public val explainabilityConfig: aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig? = builder.explainabilityConfig
    /**
     * A unique name for the Explainability.
     */
    public val explainabilityName: kotlin.String? = builder.explainabilityName
    /**
     * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * Defines the fields of a dataset.
     */
    public val schema: aws.sdk.kotlin.services.forecast.model.Schema? = builder.schema
    /**
     * If `TimePointGranularity` is set to `SPECIFIC`, define the first point for the Explainability.
     *
     * Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
     */
    public val startDateTime: kotlin.String? = builder.startDateTime
    /**
     * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an optional value, both of which you define. Tag keys and values are case sensitive.
     *
     * The following restrictions apply to tags:
     * + For each resource, each tag key must be unique and each tag key must have one value.
     * + Maximum number of tags per resource: 50.
     * + Maximum key length: 128 Unicode characters in UTF-8.
     * + Maximum value length: 256 Unicode characters in UTF-8.
     * + Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your tagging schema is used across other services and resources, the character restrictions of those services also apply.
     * + Key prefixes cannot include any upper or lowercase combination of `aws:` or `AWS:`. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit. You cannot edit or delete tag keys with this prefix.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.CreateExplainabilityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateExplainabilityRequest(")
        append("dataSource=$dataSource,")
        append("enableVisualization=$enableVisualization,")
        append("endDateTime=$endDateTime,")
        append("explainabilityConfig=$explainabilityConfig,")
        append("explainabilityName=$explainabilityName,")
        append("resourceArn=$resourceArn,")
        append("schema=$schema,")
        append("startDateTime=$startDateTime,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (enableVisualization?.hashCode() ?: 0)
        result = 31 * result + (endDateTime?.hashCode() ?: 0)
        result = 31 * result + (explainabilityConfig?.hashCode() ?: 0)
        result = 31 * result + (explainabilityName?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (startDateTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateExplainabilityRequest

        if (dataSource != other.dataSource) return false
        if (enableVisualization != other.enableVisualization) return false
        if (endDateTime != other.endDateTime) return false
        if (explainabilityConfig != other.explainabilityConfig) return false
        if (explainabilityName != other.explainabilityName) return false
        if (resourceArn != other.resourceArn) return false
        if (schema != other.schema) return false
        if (startDateTime != other.startDateTime) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.CreateExplainabilityRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The source of your data, an Identity and Access Management (IAM) role that allows Amazon Forecast to access the data and, optionally, an Key Management Service (KMS) key.
         */
        public var dataSource: aws.sdk.kotlin.services.forecast.model.DataSource? = null
        /**
         * Create an Explainability visualization that is viewable within the Amazon Web Services console.
         */
        public var enableVisualization: kotlin.Boolean? = null
        /**
         * If `TimePointGranularity` is set to `SPECIFIC`, define the last time point for the Explainability.
         *
         * Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
         */
        public var endDateTime: kotlin.String? = null
        /**
         * The configuration settings that define the granularity of time series and time points for the Explainability.
         */
        public var explainabilityConfig: aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig? = null
        /**
         * A unique name for the Explainability.
         */
        public var explainabilityName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * Defines the fields of a dataset.
         */
        public var schema: aws.sdk.kotlin.services.forecast.model.Schema? = null
        /**
         * If `TimePointGranularity` is set to `SPECIFIC`, define the first point for the Explainability.
         *
         * Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example: 2015-01-01T20:00:00)
         */
        public var startDateTime: kotlin.String? = null
        /**
         * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an optional value, both of which you define. Tag keys and values are case sensitive.
         *
         * The following restrictions apply to tags:
         * + For each resource, each tag key must be unique and each tag key must have one value.
         * + Maximum number of tags per resource: 50.
         * + Maximum key length: 128 Unicode characters in UTF-8.
         * + Maximum value length: 256 Unicode characters in UTF-8.
         * + Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your tagging schema is used across other services and resources, the character restrictions of those services also apply.
         * + Key prefixes cannot include any upper or lowercase combination of `aws:` or `AWS:`. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit. You cannot edit or delete tag keys with this prefix.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.CreateExplainabilityRequest) : this() {
            this.dataSource = x.dataSource
            this.enableVisualization = x.enableVisualization
            this.endDateTime = x.endDateTime
            this.explainabilityConfig = x.explainabilityConfig
            this.explainabilityName = x.explainabilityName
            this.resourceArn = x.resourceArn
            this.schema = x.schema
            this.startDateTime = x.startDateTime
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.CreateExplainabilityRequest = CreateExplainabilityRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.DataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.forecast.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.forecast.model.DataSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig] inside the given [block]
         */
        public fun explainabilityConfig(block: aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig.Builder.() -> kotlin.Unit) {
            this.explainabilityConfig = aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.Schema] inside the given [block]
         */
        public fun schema(block: aws.sdk.kotlin.services.forecast.model.Schema.Builder.() -> kotlin.Unit) {
            this.schema = aws.sdk.kotlin.services.forecast.model.Schema.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
