// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the modifications that you are making to an attribute for a what-if forecast. For example, you can use this operation to create a what-if forecast that investigates a 10% off sale on all shoes. To do this, you specify `"AttributeName": "shoes"`, `"Operation": "MULTIPLY"`, and `"Value": "0.90"`. Pair this operation with the TimeSeriesCondition operation within the CreateWhatIfForecastRequest$TimeSeriesTransformations operation to define a subset of attribute items that are modified.
 */
public class Action private constructor(builder: Builder) {
    /**
     * The related time series that you are modifying. This value is case insensitive.
     */
    public val attributeName: kotlin.String = requireNotNull(builder.attributeName) { "A non-null value must be provided for attributeName" }
    /**
     * The operation that is applied to the provided attribute. Operations include:
     * + `ADD` - adds `Value` to all rows of `AttributeName`.
     * + `SUBTRACT` - subtracts `Value` from all rows of `AttributeName`.
     * + `MULTIPLY` - multiplies all rows of `AttributeName` by `Value`.
     * + `DIVIDE` - divides all rows of `AttributeName` by `Value`.
     */
    public val operation: aws.sdk.kotlin.services.forecast.model.Operation = requireNotNull(builder.operation) { "A non-null value must be provided for operation" }
    /**
     * The value that is applied for the chosen `Operation`.
     */
    public val value: kotlin.Double = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Action(")
        append("attributeName=$attributeName,")
        append("operation=$operation,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName.hashCode()
        result = 31 * result + (operation.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Action

        if (attributeName != other.attributeName) return false
        if (operation != other.operation) return false
        if (!(value?.equals(other.value) ?: (other.value == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.Action = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The related time series that you are modifying. This value is case insensitive.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The operation that is applied to the provided attribute. Operations include:
         * + `ADD` - adds `Value` to all rows of `AttributeName`.
         * + `SUBTRACT` - subtracts `Value` from all rows of `AttributeName`.
         * + `MULTIPLY` - multiplies all rows of `AttributeName` by `Value`.
         * + `DIVIDE` - divides all rows of `AttributeName` by `Value`.
         */
        public var operation: aws.sdk.kotlin.services.forecast.model.Operation? = null
        /**
         * The value that is applied for the chosen `Operation`.
         */
        public var value: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.Action) : this() {
            this.attributeName = x.attributeName
            this.operation = x.operation
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.Action = Action(this)

        internal fun correctErrors(): Builder {
            if (attributeName == null) attributeName = ""
            if (operation == null) operation = Operation.SdkUnknown("no value provided")
            if (value == null) value = 0.0
            return this
        }
    }
}
