// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.AutoMlOverrideStrategy
import aws.sdk.kotlin.services.forecast.model.EvaluationResult
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.sdk.kotlin.services.forecast.model.GetAccuracyMetricsResponse
import aws.sdk.kotlin.services.forecast.model.OptimizationMetric
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetAccuracyMetricsOperationDeserializer: HttpDeserializer.NonStreaming<GetAccuracyMetricsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetAccuracyMetricsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAccuracyMetricsError(context, call, payload)
        }
        val builder = GetAccuracyMetricsResponse.Builder()

        if (payload != null) {
            deserializeGetAccuracyMetricsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetAccuracyMetricsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccuracyMetricsOperationBody(builder: GetAccuracyMetricsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOMLOVERRIDESTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AutoMLOverrideStrategy"))
    val ISAUTOPREDICTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsAutoPredictor"))
    val OPTIMIZATIONMETRIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OptimizationMetric"))
    val PREDICTOREVALUATIONRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PredictorEvaluationResults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOMLOVERRIDESTRATEGY_DESCRIPTOR)
        field(ISAUTOPREDICTOR_DESCRIPTOR)
        field(OPTIMIZATIONMETRIC_DESCRIPTOR)
        field(PREDICTOREVALUATIONRESULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOMLOVERRIDESTRATEGY_DESCRIPTOR.index -> builder.autoMlOverrideStrategy = deserializeString().let { AutoMlOverrideStrategy.fromValue(it) }
                ISAUTOPREDICTOR_DESCRIPTOR.index -> builder.isAutoPredictor = deserializeBoolean()
                OPTIMIZATIONMETRIC_DESCRIPTOR.index -> builder.optimizationMetric = deserializeString().let { OptimizationMetric.fromValue(it) }
                PREDICTOREVALUATIONRESULTS_DESCRIPTOR.index -> builder.predictorEvaluationResults =
                    deserializer.deserializeList(PREDICTOREVALUATIONRESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<EvaluationResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEvaluationResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
