// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.DataDestination
import aws.sdk.kotlin.services.forecast.model.DescribeWhatIfForecastExportResponse
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeWhatIfForecastExportOperationDeserializer: HttpDeserializer.NonStreaming<DescribeWhatIfForecastExportResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeWhatIfForecastExportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeWhatIfForecastExportError(context, call, payload)
        }
        val builder = DescribeWhatIfForecastExportResponse.Builder()

        if (payload != null) {
            deserializeDescribeWhatIfForecastExportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeWhatIfForecastExportError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeWhatIfForecastExportOperationBody(builder: DescribeWhatIfForecastExportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Destination"))
    val ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedTimeRemainingInMinutes"))
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Format"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val WHATIFFORECASTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WhatIfForecastArns"))
    val WHATIFFORECASTEXPORTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WhatIfForecastExportArn"))
    val WHATIFFORECASTEXPORTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WhatIfForecastExportName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR)
        field(FORMAT_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(WHATIFFORECASTARNS_DESCRIPTOR)
        field(WHATIFFORECASTEXPORTARN_DESCRIPTOR)
        field(WHATIFFORECASTEXPORTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESTINATION_DESCRIPTOR.index -> builder.destination = deserializeDataDestinationDocument(deserializer)
                ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR.index -> builder.estimatedTimeRemainingInMinutes = deserializeLong()
                FORMAT_DESCRIPTOR.index -> builder.format = deserializeString()
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                WHATIFFORECASTARNS_DESCRIPTOR.index -> builder.whatIfForecastArns =
                    deserializer.deserializeList(WHATIFFORECASTARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WHATIFFORECASTEXPORTARN_DESCRIPTOR.index -> builder.whatIfForecastExportArn = deserializeString()
                WHATIFFORECASTEXPORTNAME_DESCRIPTOR.index -> builder.whatIfForecastExportName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
