// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.AutoMlOverrideStrategy
import aws.sdk.kotlin.services.forecast.model.DescribePredictorResponse
import aws.sdk.kotlin.services.forecast.model.EncryptionConfig
import aws.sdk.kotlin.services.forecast.model.EvaluationParameters
import aws.sdk.kotlin.services.forecast.model.FeaturizationConfig
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig
import aws.sdk.kotlin.services.forecast.model.InputDataConfig
import aws.sdk.kotlin.services.forecast.model.OptimizationMetric
import aws.sdk.kotlin.services.forecast.model.PredictorExecutionDetails
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribePredictorOperationDeserializer: HttpDeserializer.NonStreaming<DescribePredictorResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribePredictorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribePredictorError(context, call, payload)
        }
        val builder = DescribePredictorResponse.Builder()

        if (payload != null) {
            deserializeDescribePredictorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribePredictorError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePredictorOperationBody(builder: DescribePredictorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALGORITHMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmArn"))
    val AUTOMLALGORITHMARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AutoMLAlgorithmArns"))
    val AUTOMLOVERRIDESTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AutoMLOverrideStrategy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATASETIMPORTJOBARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DatasetImportJobArns"))
    val ENCRYPTIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EncryptionConfig"))
    val ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedTimeRemainingInMinutes"))
    val EVALUATIONPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EvaluationParameters"))
    val FEATURIZATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FeaturizationConfig"))
    val FORECASTHORIZON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ForecastHorizon"))
    val FORECASTTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ForecastTypes"))
    val HPOCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HPOConfig"))
    val INPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputDataConfig"))
    val ISAUTOPREDICTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsAutoPredictor"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val OPTIMIZATIONMETRIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OptimizationMetric"))
    val PERFORMAUTOML_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PerformAutoML"))
    val PERFORMHPO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PerformHPO"))
    val PREDICTORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PredictorArn"))
    val PREDICTOREXECUTIONDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PredictorExecutionDetails"))
    val PREDICTORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PredictorName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TRAININGPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("TrainingParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHMARN_DESCRIPTOR)
        field(AUTOMLALGORITHMARNS_DESCRIPTOR)
        field(AUTOMLOVERRIDESTRATEGY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DATASETIMPORTJOBARNS_DESCRIPTOR)
        field(ENCRYPTIONCONFIG_DESCRIPTOR)
        field(ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR)
        field(EVALUATIONPARAMETERS_DESCRIPTOR)
        field(FEATURIZATIONCONFIG_DESCRIPTOR)
        field(FORECASTHORIZON_DESCRIPTOR)
        field(FORECASTTYPES_DESCRIPTOR)
        field(HPOCONFIG_DESCRIPTOR)
        field(INPUTDATACONFIG_DESCRIPTOR)
        field(ISAUTOPREDICTOR_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(OPTIMIZATIONMETRIC_DESCRIPTOR)
        field(PERFORMAUTOML_DESCRIPTOR)
        field(PERFORMHPO_DESCRIPTOR)
        field(PREDICTORARN_DESCRIPTOR)
        field(PREDICTOREXECUTIONDETAILS_DESCRIPTOR)
        field(PREDICTORNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TRAININGPARAMETERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALGORITHMARN_DESCRIPTOR.index -> builder.algorithmArn = deserializeString()
                AUTOMLALGORITHMARNS_DESCRIPTOR.index -> builder.autoMlAlgorithmArns =
                    deserializer.deserializeList(AUTOMLALGORITHMARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTOMLOVERRIDESTRATEGY_DESCRIPTOR.index -> builder.autoMlOverrideStrategy = deserializeString().let { AutoMlOverrideStrategy.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATASETIMPORTJOBARNS_DESCRIPTOR.index -> builder.datasetImportJobArns =
                    deserializer.deserializeList(DATASETIMPORTJOBARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENCRYPTIONCONFIG_DESCRIPTOR.index -> builder.encryptionConfig = deserializeEncryptionConfigDocument(deserializer)
                ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR.index -> builder.estimatedTimeRemainingInMinutes = deserializeLong()
                EVALUATIONPARAMETERS_DESCRIPTOR.index -> builder.evaluationParameters = deserializeEvaluationParametersDocument(deserializer)
                FEATURIZATIONCONFIG_DESCRIPTOR.index -> builder.featurizationConfig = deserializeFeaturizationConfigDocument(deserializer)
                FORECASTHORIZON_DESCRIPTOR.index -> builder.forecastHorizon = deserializeInt()
                FORECASTTYPES_DESCRIPTOR.index -> builder.forecastTypes =
                    deserializer.deserializeList(FORECASTTYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HPOCONFIG_DESCRIPTOR.index -> builder.hpoConfig = deserializeHyperParameterTuningJobConfigDocument(deserializer)
                INPUTDATACONFIG_DESCRIPTOR.index -> builder.inputDataConfig = deserializeInputDataConfigDocument(deserializer)
                ISAUTOPREDICTOR_DESCRIPTOR.index -> builder.isAutoPredictor = deserializeBoolean()
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                OPTIMIZATIONMETRIC_DESCRIPTOR.index -> builder.optimizationMetric = deserializeString().let { OptimizationMetric.fromValue(it) }
                PERFORMAUTOML_DESCRIPTOR.index -> builder.performAutoMl = deserializeBoolean()
                PERFORMHPO_DESCRIPTOR.index -> builder.performHpo = deserializeBoolean()
                PREDICTORARN_DESCRIPTOR.index -> builder.predictorArn = deserializeString()
                PREDICTOREXECUTIONDETAILS_DESCRIPTOR.index -> builder.predictorExecutionDetails = deserializePredictorExecutionDetailsDocument(deserializer)
                PREDICTORNAME_DESCRIPTOR.index -> builder.predictorName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                TRAININGPARAMETERS_DESCRIPTOR.index -> builder.trainingParameters =
                    deserializer.deserializeMap(TRAININGPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
