// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.DescribeDatasetGroupResponse
import aws.sdk.kotlin.services.forecast.model.Domain
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeDatasetGroupOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDatasetGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDatasetGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDatasetGroupError(context, call, payload)
        }
        val builder = DescribeDatasetGroupResponse.Builder()

        if (payload != null) {
            deserializeDescribeDatasetGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDatasetGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDatasetGroupOperationBody(builder: DescribeDatasetGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATASETARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DatasetArns"))
    val DATASETGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DatasetGroupArn"))
    val DATASETGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DatasetGroupName"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Domain"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DATASETARNS_DESCRIPTOR)
        field(DATASETGROUPARN_DESCRIPTOR)
        field(DATASETGROUPNAME_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATASETARNS_DESCRIPTOR.index -> builder.datasetArns =
                    deserializer.deserializeList(DATASETARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DATASETGROUPARN_DESCRIPTOR.index -> builder.datasetGroupArn = deserializeString()
                DATASETGROUPNAME_DESCRIPTOR.index -> builder.datasetGroupName = deserializeString()
                DOMAIN_DESCRIPTOR.index -> builder.domain = deserializeString().let { Domain.fromValue(it) }
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
