// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.CreateDatasetRequest
import aws.sdk.kotlin.services.forecast.model.DatasetType
import aws.sdk.kotlin.services.forecast.model.Domain
import aws.sdk.kotlin.services.forecast.model.EncryptionConfig
import aws.sdk.kotlin.services.forecast.model.Schema
import aws.sdk.kotlin.services.forecast.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDatasetOperationSerializer: HttpSerializer.NonStreaming<CreateDatasetRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDatasetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateDatasetOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateDatasetOperationBody(context: ExecutionContext, input: CreateDatasetRequest): ByteArray {
    val serializer = JsonSerializer()
    val DATAFREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataFrequency"))
    val DATASETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DatasetName"))
    val DATASETTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DatasetType"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Domain"))
    val ENCRYPTIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EncryptionConfig"))
    val SCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Schema"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATAFREQUENCY_DESCRIPTOR)
        field(DATASETNAME_DESCRIPTOR)
        field(DATASETTYPE_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(ENCRYPTIONCONFIG_DESCRIPTOR)
        field(SCHEMA_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dataFrequency?.let { field(DATAFREQUENCY_DESCRIPTOR, it) }
        input.datasetName?.let { field(DATASETNAME_DESCRIPTOR, it) }
        input.datasetType?.let { field(DATASETTYPE_DESCRIPTOR, it.value) }
        input.domain?.let { field(DOMAIN_DESCRIPTOR, it.value) }
        input.encryptionConfig?.let { field(ENCRYPTIONCONFIG_DESCRIPTOR, it, ::serializeEncryptionConfigDocument) }
        input.schema?.let { field(SCHEMA_DESCRIPTOR, it, ::serializeSchemaDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
