// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The time boundary Forecast uses to align and aggregate your data to match your forecast frequency. Provide the unit of time and the time boundary as a key value pair. If you don't provide a time boundary, Forecast uses a set of [Default Time Boundaries](https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#default-time-boundaries).
 *
 * For more information about aggregation, see [Data Aggregation for Different Forecast Frequencies](https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html). For more information setting a custom time boundary, see [Specifying a Time Boundary](https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#specifying-time-boundary).
 */
public class TimeAlignmentBoundary private constructor(builder: Builder) {
    /**
     * The day of the month to use for time alignment during aggregation.
     */
    public val dayOfMonth: kotlin.Int? = builder.dayOfMonth
    /**
     * The day of week to use for time alignment during aggregation. The day must be in uppercase.
     */
    public val dayOfWeek: aws.sdk.kotlin.services.forecast.model.DayOfWeek? = builder.dayOfWeek
    /**
     * The hour of day to use for time alignment during aggregation.
     */
    public val hour: kotlin.Int? = builder.hour
    /**
     * The month to use for time alignment during aggregation. The month must be in uppercase.
     */
    public val month: aws.sdk.kotlin.services.forecast.model.Month? = builder.month

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeAlignmentBoundary(")
        append("dayOfMonth=$dayOfMonth,")
        append("dayOfWeek=$dayOfWeek,")
        append("hour=$hour,")
        append("month=$month")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dayOfMonth ?: 0
        result = 31 * result + (dayOfWeek?.hashCode() ?: 0)
        result = 31 * result + (hour ?: 0)
        result = 31 * result + (month?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeAlignmentBoundary

        if (dayOfMonth != other.dayOfMonth) return false
        if (dayOfWeek != other.dayOfWeek) return false
        if (hour != other.hour) return false
        if (month != other.month) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The day of the month to use for time alignment during aggregation.
         */
        public var dayOfMonth: kotlin.Int? = null
        /**
         * The day of week to use for time alignment during aggregation. The day must be in uppercase.
         */
        public var dayOfWeek: aws.sdk.kotlin.services.forecast.model.DayOfWeek? = null
        /**
         * The hour of day to use for time alignment during aggregation.
         */
        public var hour: kotlin.Int? = null
        /**
         * The month to use for time alignment during aggregation. The month must be in uppercase.
         */
        public var month: aws.sdk.kotlin.services.forecast.model.Month? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary) : this() {
            this.dayOfMonth = x.dayOfMonth
            this.dayOfWeek = x.dayOfWeek
            this.hour = x.hour
            this.month = x.month
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary = TimeAlignmentBoundary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
