// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An attribute of a schema, which defines a dataset field. A schema attribute is required for every field in a dataset. The [Schema](https://docs.aws.amazon.com/forecast/latest/dg/API_Schema.html) object contains an array of `SchemaAttribute` objects.
 */
public class SchemaAttribute private constructor(builder: Builder) {
    /**
     * The name of the dataset field.
     */
    public val attributeName: kotlin.String? = builder.attributeName
    /**
     * The data type of the field.
     *
     * For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all attributes should be of numerical type (integer/float).
     */
    public val attributeType: aws.sdk.kotlin.services.forecast.model.AttributeType? = builder.attributeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.SchemaAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SchemaAttribute(")
        append("attributeName=$attributeName,")
        append("attributeType=$attributeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (attributeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SchemaAttribute

        if (attributeName != other.attributeName) return false
        if (attributeType != other.attributeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.SchemaAttribute = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the dataset field.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The data type of the field.
         *
         * For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all attributes should be of numerical type (integer/float).
         */
        public var attributeType: aws.sdk.kotlin.services.forecast.model.AttributeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.SchemaAttribute) : this() {
            this.attributeName = x.attributeName
            this.attributeType = x.attributeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.SchemaAttribute = SchemaAttribute(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
