// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the predictor properties that are used in the ListPredictors operation. To get the complete set of properties, call the DescribePredictor operation, and provide the listed `PredictorArn`.
 */
public class PredictorSummary private constructor(builder: Builder) {
    /**
     * When the model training task was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * Whether AutoPredictor was used to create the predictor.
     */
    public val isAutoPredictor: kotlin.Boolean? = builder.isAutoPredictor
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * If an error occurred, an informational message about the error.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The ARN of the predictor.
     */
    public val predictorArn: kotlin.String? = builder.predictorArn
    /**
     * The name of the predictor.
     */
    public val predictorName: kotlin.String? = builder.predictorName
    /**
     * A summary of the reference predictor used if the predictor was retrained or upgraded.
     */
    public val referencePredictorSummary: aws.sdk.kotlin.services.forecast.model.ReferencePredictorSummary? = builder.referencePredictorSummary
    /**
     * The status of the predictor. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     *
     * The `Status` of the predictor must be `ACTIVE` before you can use the predictor to create a forecast.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.PredictorSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PredictorSummary(")
        append("creationTime=$creationTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("isAutoPredictor=$isAutoPredictor,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("predictorArn=$predictorArn,")
        append("predictorName=$predictorName,")
        append("referencePredictorSummary=$referencePredictorSummary,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (isAutoPredictor?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (predictorArn?.hashCode() ?: 0)
        result = 31 * result + (predictorName?.hashCode() ?: 0)
        result = 31 * result + (referencePredictorSummary?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PredictorSummary

        if (creationTime != other.creationTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (isAutoPredictor != other.isAutoPredictor) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (predictorArn != other.predictorArn) return false
        if (predictorName != other.predictorName) return false
        if (referencePredictorSummary != other.referencePredictorSummary) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.PredictorSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the model training task was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * Whether AutoPredictor was used to create the predictor.
         */
        public var isAutoPredictor: kotlin.Boolean? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If an error occurred, an informational message about the error.
         */
        public var message: kotlin.String? = null
        /**
         * The ARN of the predictor.
         */
        public var predictorArn: kotlin.String? = null
        /**
         * The name of the predictor.
         */
        public var predictorName: kotlin.String? = null
        /**
         * A summary of the reference predictor used if the predictor was retrained or upgraded.
         */
        public var referencePredictorSummary: aws.sdk.kotlin.services.forecast.model.ReferencePredictorSummary? = null
        /**
         * The status of the predictor. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         *
         * The `Status` of the predictor must be `ACTIVE` before you can use the predictor to create a forecast.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.PredictorSummary) : this() {
            this.creationTime = x.creationTime
            this.datasetGroupArn = x.datasetGroupArn
            this.isAutoPredictor = x.isAutoPredictor
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.predictorArn = x.predictorArn
            this.predictorName = x.predictorName
            this.referencePredictorSummary = x.referencePredictorSummary
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.PredictorSummary = PredictorSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.ReferencePredictorSummary] inside the given [block]
         */
        public fun referencePredictorSummary(block: aws.sdk.kotlin.services.forecast.model.ReferencePredictorSummary.Builder.() -> kotlin.Unit) {
            this.referencePredictorSummary = aws.sdk.kotlin.services.forecast.model.ReferencePredictorSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
