// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListMonitorEvaluationsRequest private constructor(builder: Builder) {
    /**
     * An array of filters. For each filter, provide a condition and a match statement. The condition is either `IS` or `IS_NOT`, which specifies whether to include or exclude the resources that match the statement from the list. The match statement consists of a key and a value.
     *
     * **Filter properties**
     * + `Condition` - The condition to apply. Valid values are `IS` and `IS_NOT`.
     * + `Key` - The name of the parameter to filter on. The only valid value is `EvaluationState`.
     * + `Value` - The value to match. Valid values are only `SUCCESS` or `FAILURE`.
     *
     * For example, to list only successful monitor evaluations, you would specify:
     *
     * `"Filters": [ { "Condition": "IS", "Key": "EvaluationState", "Value": "SUCCESS" } ]`
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of monitoring results to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The Amazon Resource Name (ARN) of the monitor resource to get results from.
     */
    public val monitorArn: kotlin.String? = builder.monitorArn
    /**
     * If the result of the previous request was truncated, the response includes a `NextToken`. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.ListMonitorEvaluationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListMonitorEvaluationsRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("monitorArn=$monitorArn,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (monitorArn?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListMonitorEvaluationsRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (monitorArn != other.monitorArn) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.ListMonitorEvaluationsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of filters. For each filter, provide a condition and a match statement. The condition is either `IS` or `IS_NOT`, which specifies whether to include or exclude the resources that match the statement from the list. The match statement consists of a key and a value.
         *
         * **Filter properties**
         * + `Condition` - The condition to apply. Valid values are `IS` and `IS_NOT`.
         * + `Key` - The name of the parameter to filter on. The only valid value is `EvaluationState`.
         * + `Value` - The value to match. Valid values are only `SUCCESS` or `FAILURE`.
         *
         * For example, to list only successful monitor evaluations, you would specify:
         *
         * `"Filters": [ { "Condition": "IS", "Key": "EvaluationState", "Value": "SUCCESS" } ]`
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of monitoring results to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the monitor resource to get results from.
         */
        public var monitorArn: kotlin.String? = null
        /**
         * If the result of the previous request was truncated, the response includes a `NextToken`. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.ListMonitorEvaluationsRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.monitorArn = x.monitorArn
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.ListMonitorEvaluationsRequest = ListMonitorEvaluationsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
