// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies an integer hyperparameter and it's range of tunable values. This object is part of the ParameterRanges object.
 */
public class IntegerParameterRange private constructor(builder: Builder) {
    /**
     * The maximum tunable value of the hyperparameter.
     */
    public val maxValue: kotlin.Int = requireNotNull(builder.maxValue) { "A non-null value must be provided for maxValue" }
    /**
     * The minimum tunable value of the hyperparameter.
     */
    public val minValue: kotlin.Int = requireNotNull(builder.minValue) { "A non-null value must be provided for minValue" }
    /**
     * The name of the hyperparameter to tune.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:
     *
     * ## Auto
     * Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
     *
     * ## Linear
     * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     *
     * ## Logarithmic
     * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     *
     * Logarithmic scaling works only for ranges that have values greater than 0.
     *
     * ## ReverseLogarithmic
     * Not supported for `IntegerParameterRange`.
     *
     * Reverse logarithmic scaling works only for ranges that are entirely within the range 0 <= x < 1.0.
     *
     * For information about choosing a hyperparameter scale, see [Hyperparameter Scaling](http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type). One of the following values:
     */
    public val scalingType: aws.sdk.kotlin.services.forecast.model.ScalingType? = builder.scalingType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.IntegerParameterRange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntegerParameterRange(")
        append("maxValue=$maxValue,")
        append("minValue=$minValue,")
        append("name=$name,")
        append("scalingType=$scalingType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxValue
        result = 31 * result + (minValue)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (scalingType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntegerParameterRange

        if (maxValue != other.maxValue) return false
        if (minValue != other.minValue) return false
        if (name != other.name) return false
        if (scalingType != other.scalingType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.IntegerParameterRange = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum tunable value of the hyperparameter.
         */
        public var maxValue: kotlin.Int? = null
        /**
         * The minimum tunable value of the hyperparameter.
         */
        public var minValue: kotlin.Int? = null
        /**
         * The name of the hyperparameter to tune.
         */
        public var name: kotlin.String? = null
        /**
         * The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:
         *
         * ## Auto
         * Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
         *
         * ## Linear
         * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         *
         * ## Logarithmic
         * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         *
         * Logarithmic scaling works only for ranges that have values greater than 0.
         *
         * ## ReverseLogarithmic
         * Not supported for `IntegerParameterRange`.
         *
         * Reverse logarithmic scaling works only for ranges that are entirely within the range 0 <= x < 1.0.
         *
         * For information about choosing a hyperparameter scale, see [Hyperparameter Scaling](http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type). One of the following values:
         */
        public var scalingType: aws.sdk.kotlin.services.forecast.model.ScalingType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.IntegerParameterRange) : this() {
            this.maxValue = x.maxValue
            this.minValue = x.minValue
            this.name = x.name
            this.scalingType = x.scalingType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.IntegerParameterRange = IntegerParameterRange(this)

        internal fun correctErrors(): Builder {
            if (maxValue == null) maxValue = 0
            if (minValue == null) minValue = 0
            if (name == null) name = ""
            return this
        }
    }
}
