// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the forecast properties used in the ListForecasts operation. To get the complete set of properties, call the DescribeForecast operation, and provide the `ForecastArn` that is listed in the summary.
 */
public class ForecastSummary private constructor(builder: Builder) {
    /**
     * Whether the Forecast was created from an AutoPredictor.
     */
    public val createdUsingAutoPredictor: kotlin.Boolean? = builder.createdUsingAutoPredictor
    /**
     * When the forecast creation task was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The ARN of the forecast.
     */
    public val forecastArn: kotlin.String? = builder.forecastArn
    /**
     * The name of the forecast.
     */
    public val forecastName: kotlin.String? = builder.forecastName
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * If an error occurred, an informational message about the error.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The ARN of the predictor used to generate the forecast.
     */
    public val predictorArn: kotlin.String? = builder.predictorArn
    /**
     * The status of the forecast. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     *
     * The `Status` of the forecast must be `ACTIVE` before you can query or export the forecast.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.ForecastSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ForecastSummary(")
        append("createdUsingAutoPredictor=$createdUsingAutoPredictor,")
        append("creationTime=$creationTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("forecastArn=$forecastArn,")
        append("forecastName=$forecastName,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("predictorArn=$predictorArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdUsingAutoPredictor?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (forecastArn?.hashCode() ?: 0)
        result = 31 * result + (forecastName?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (predictorArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ForecastSummary

        if (createdUsingAutoPredictor != other.createdUsingAutoPredictor) return false
        if (creationTime != other.creationTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (forecastArn != other.forecastArn) return false
        if (forecastName != other.forecastName) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (predictorArn != other.predictorArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.ForecastSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether the Forecast was created from an AutoPredictor.
         */
        public var createdUsingAutoPredictor: kotlin.Boolean? = null
        /**
         * When the forecast creation task was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * The ARN of the forecast.
         */
        public var forecastArn: kotlin.String? = null
        /**
         * The name of the forecast.
         */
        public var forecastName: kotlin.String? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If an error occurred, an informational message about the error.
         */
        public var message: kotlin.String? = null
        /**
         * The ARN of the predictor used to generate the forecast.
         */
        public var predictorArn: kotlin.String? = null
        /**
         * The status of the forecast. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         *
         * The `Status` of the forecast must be `ACTIVE` before you can query or export the forecast.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.ForecastSummary) : this() {
            this.createdUsingAutoPredictor = x.createdUsingAutoPredictor
            this.creationTime = x.creationTime
            this.datasetGroupArn = x.datasetGroupArn
            this.forecastArn = x.forecastArn
            this.forecastName = x.forecastName
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.predictorArn = x.predictorArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.ForecastSummary = ForecastSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
