// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This object belongs to the CreatePredictor operation. If you created your predictor with CreateAutoPredictor, see AttributeConfig.
 *
 * In a CreatePredictor operation, the specified algorithm trains a model using the specified dataset group. You can optionally tell the operation to modify data fields prior to training a model. These modifications are referred to as *featurization*.
 *
 * You define featurization using the `FeaturizationConfig` object. You specify an array of transformations, one for each field that you want to featurize. You then include the `FeaturizationConfig` object in your `CreatePredictor` request. Amazon Forecast applies the featurization to the `TARGET_TIME_SERIES` and `RELATED_TIME_SERIES` datasets before model training.
 *
 * You can create multiple featurization configurations. For example, you might call the `CreatePredictor` operation twice by specifying different featurization configurations.
 */
public class FeaturizationConfig private constructor(builder: Builder) {
    /**
     * An array of featurization (transformation) information for the fields of a dataset.
     */
    public val featurizations: List<Featurization>? = builder.featurizations
    /**
     * An array of dimension (field) names that specify how to group the generated forecast.
     *
     * For example, suppose that you are generating a forecast for item sales across all of your stores, and your dataset contains a `store_id` field. If you want the sales forecast for each item by store, you would specify `store_id` as the dimension.
     *
     * All forecast dimensions specified in the `TARGET_TIME_SERIES` dataset don't need to be specified in the `CreatePredictor` request. All forecast dimensions specified in the `RELATED_TIME_SERIES` dataset must be specified in the `CreatePredictor` request.
     */
    public val forecastDimensions: List<String>? = builder.forecastDimensions
    /**
     * The frequency of predictions in a forecast.
     *
     * Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D (Day), H (Hour), and min (Minute). For example, "1D" indicates every day and "15min" indicates every 15 minutes. You cannot specify a value that would overlap with the next larger frequency. That means, for example, you cannot specify a frequency of 60 minutes, because that is equivalent to 1 hour. The valid values for each frequency are the following:
     * + Minute - 1-59
     * + Hour - 1-23
     * + Day - 1-6
     * + Week - 1-4
     * + Month - 1-11
     * + Year - 1
     *
     * Thus, if you want every other week forecasts, specify "2W". Or, if you want quarterly forecasts, you specify "3M".
     *
     * The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.
     *
     * When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the TARGET_TIME_SERIES dataset frequency.
     */
    public val forecastFrequency: kotlin.String = requireNotNull(builder.forecastFrequency) { "A non-null value must be provided for forecastFrequency" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.FeaturizationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FeaturizationConfig(")
        append("featurizations=$featurizations,")
        append("forecastDimensions=$forecastDimensions,")
        append("forecastFrequency=$forecastFrequency")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = featurizations?.hashCode() ?: 0
        result = 31 * result + (forecastDimensions?.hashCode() ?: 0)
        result = 31 * result + (forecastFrequency.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FeaturizationConfig

        if (featurizations != other.featurizations) return false
        if (forecastDimensions != other.forecastDimensions) return false
        if (forecastFrequency != other.forecastFrequency) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.FeaturizationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of featurization (transformation) information for the fields of a dataset.
         */
        public var featurizations: List<Featurization>? = null
        /**
         * An array of dimension (field) names that specify how to group the generated forecast.
         *
         * For example, suppose that you are generating a forecast for item sales across all of your stores, and your dataset contains a `store_id` field. If you want the sales forecast for each item by store, you would specify `store_id` as the dimension.
         *
         * All forecast dimensions specified in the `TARGET_TIME_SERIES` dataset don't need to be specified in the `CreatePredictor` request. All forecast dimensions specified in the `RELATED_TIME_SERIES` dataset must be specified in the `CreatePredictor` request.
         */
        public var forecastDimensions: List<String>? = null
        /**
         * The frequency of predictions in a forecast.
         *
         * Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D (Day), H (Hour), and min (Minute). For example, "1D" indicates every day and "15min" indicates every 15 minutes. You cannot specify a value that would overlap with the next larger frequency. That means, for example, you cannot specify a frequency of 60 minutes, because that is equivalent to 1 hour. The valid values for each frequency are the following:
         * + Minute - 1-59
         * + Hour - 1-23
         * + Day - 1-6
         * + Week - 1-4
         * + Month - 1-11
         * + Year - 1
         *
         * Thus, if you want every other week forecasts, specify "2W". Or, if you want quarterly forecasts, you specify "3M".
         *
         * The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.
         *
         * When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the TARGET_TIME_SERIES dataset frequency.
         */
        public var forecastFrequency: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.FeaturizationConfig) : this() {
            this.featurizations = x.featurizations
            this.forecastDimensions = x.forecastDimensions
            this.forecastFrequency = x.forecastFrequency
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.FeaturizationConfig = FeaturizationConfig(this)

        internal fun correctErrors(): Builder {
            if (forecastFrequency == null) forecastFrequency = ""
            return this
        }
    }
}
