// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This object belongs to the CreatePredictor operation. If you created your predictor with CreateAutoPredictor, see AttributeConfig.
 *
 * Provides featurization (transformation) information for a dataset field. This object is part of the FeaturizationConfig object.
 *
 * For example:
 *
 * `{`
 *
 * `"AttributeName": "demand",`
 *
 * `FeaturizationPipeline [ {`
 *
 * `"FeaturizationMethodName": "filling",`
 *
 * `"FeaturizationMethodParameters": {"aggregation": "avg", "backfill": "nan"}`
 *
 * `} ]`
 *
 * `}`
 */
public class Featurization private constructor(builder: Builder) {
    /**
     * The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports the target field of the `TARGET_TIME_SERIES` and the `RELATED_TIME_SERIES` datasets. For example, for the `RETAIL` domain, the target is `demand`, and for the `CUSTOM` domain, the target is `target_value`. For more information, see howitworks-missing-values.
     */
    public val attributeName: kotlin.String = requireNotNull(builder.attributeName) { "A non-null value must be provided for attributeName" }
    /**
     * An array of one `FeaturizationMethod` object that specifies the feature transformation method.
     */
    public val featurizationPipeline: List<FeaturizationMethod>? = builder.featurizationPipeline

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.Featurization = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Featurization(")
        append("attributeName=$attributeName,")
        append("featurizationPipeline=$featurizationPipeline")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName.hashCode()
        result = 31 * result + (featurizationPipeline?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Featurization

        if (attributeName != other.attributeName) return false
        if (featurizationPipeline != other.featurizationPipeline) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.Featurization = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports the target field of the `TARGET_TIME_SERIES` and the `RELATED_TIME_SERIES` datasets. For example, for the `RETAIL` domain, the target is `demand`, and for the `CUSTOM` domain, the target is `target_value`. For more information, see howitworks-missing-values.
         */
        public var attributeName: kotlin.String? = null
        /**
         * An array of one `FeaturizationMethod` object that specifies the feature transformation method.
         */
        public var featurizationPipeline: List<FeaturizationMethod>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.Featurization) : this() {
            this.attributeName = x.attributeName
            this.featurizationPipeline = x.featurizationPipeline
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.Featurization = Featurization(this)

        internal fun correctErrors(): Builder {
            if (attributeName == null) attributeName = ""
            return this
        }
    }
}
