// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the Explainability properties used in the ListExplainabilities operation. To get a complete set of properties, call the DescribeExplainability operation, and provide the listed `ExplainabilityArn`.
 */
public class ExplainabilitySummary private constructor(builder: Builder) {
    /**
     * When the Explainability was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the Explainability.
     */
    public val explainabilityArn: kotlin.String? = builder.explainabilityArn
    /**
     * The configuration settings that define the granularity of time series and time points for the Explainability.
     */
    public val explainabilityConfig: aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig? = builder.explainabilityConfig
    /**
     * The name of the Explainability.
     */
    public val explainabilityName: kotlin.String? = builder.explainabilityName
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * Information about any errors that may have occurred during the Explainability creation process.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The status of the Explainability. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.ExplainabilitySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExplainabilitySummary(")
        append("creationTime=$creationTime,")
        append("explainabilityArn=$explainabilityArn,")
        append("explainabilityConfig=$explainabilityConfig,")
        append("explainabilityName=$explainabilityName,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("resourceArn=$resourceArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (explainabilityArn?.hashCode() ?: 0)
        result = 31 * result + (explainabilityConfig?.hashCode() ?: 0)
        result = 31 * result + (explainabilityName?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExplainabilitySummary

        if (creationTime != other.creationTime) return false
        if (explainabilityArn != other.explainabilityArn) return false
        if (explainabilityConfig != other.explainabilityConfig) return false
        if (explainabilityName != other.explainabilityName) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (resourceArn != other.resourceArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.ExplainabilitySummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the Explainability was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the Explainability.
         */
        public var explainabilityArn: kotlin.String? = null
        /**
         * The configuration settings that define the granularity of time series and time points for the Explainability.
         */
        public var explainabilityConfig: aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig? = null
        /**
         * The name of the Explainability.
         */
        public var explainabilityName: kotlin.String? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about any errors that may have occurred during the Explainability creation process.
         */
        public var message: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The status of the Explainability. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.ExplainabilitySummary) : this() {
            this.creationTime = x.creationTime
            this.explainabilityArn = x.explainabilityArn
            this.explainabilityConfig = x.explainabilityConfig
            this.explainabilityName = x.explainabilityName
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.resourceArn = x.resourceArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.ExplainabilitySummary = ExplainabilitySummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig] inside the given [block]
         */
        public fun explainabilityConfig(block: aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig.Builder.() -> kotlin.Unit) {
            this.explainabilityConfig = aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
