// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The ExplainabilityConfig data type defines the number of time series and time points included in CreateExplainability.
 *
 * If you provide a predictor ARN for `ResourceArn`, you must set both `TimePointGranularity` and `TimeSeriesGranularity` to “ALL”. When creating Predictor Explainability, Amazon Forecast considers all time series and time points.
 *
 * If you provide a forecast ARN for `ResourceArn`, you can set `TimePointGranularity` and `TimeSeriesGranularity` to either “ALL” or “Specific”.
 */
public class ExplainabilityConfig private constructor(builder: Builder) {
    /**
     * To create an Explainability for all time points in your forecast horizon, use `ALL`. To create an Explainability for specific time points in your forecast horizon, use `SPECIFIC`.
     *
     * Specify time points with the `StartDateTime` and `EndDateTime` parameters within the CreateExplainability operation.
     */
    public val timePointGranularity: aws.sdk.kotlin.services.forecast.model.TimePointGranularity = requireNotNull(builder.timePointGranularity) { "A non-null value must be provided for timePointGranularity" }
    /**
     * To create an Explainability for all time series in your datasets, use `ALL`. To create an Explainability for specific time series in your datasets, use `SPECIFIC`.
     *
     * Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location within the DataDestination data type.
     */
    public val timeSeriesGranularity: aws.sdk.kotlin.services.forecast.model.TimeSeriesGranularity = requireNotNull(builder.timeSeriesGranularity) { "A non-null value must be provided for timeSeriesGranularity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExplainabilityConfig(")
        append("timePointGranularity=$timePointGranularity,")
        append("timeSeriesGranularity=$timeSeriesGranularity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = timePointGranularity.hashCode()
        result = 31 * result + (timeSeriesGranularity.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExplainabilityConfig

        if (timePointGranularity != other.timePointGranularity) return false
        if (timeSeriesGranularity != other.timeSeriesGranularity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * To create an Explainability for all time points in your forecast horizon, use `ALL`. To create an Explainability for specific time points in your forecast horizon, use `SPECIFIC`.
         *
         * Specify time points with the `StartDateTime` and `EndDateTime` parameters within the CreateExplainability operation.
         */
        public var timePointGranularity: aws.sdk.kotlin.services.forecast.model.TimePointGranularity? = null
        /**
         * To create an Explainability for all time series in your datasets, use `ALL`. To create an Explainability for specific time series in your datasets, use `SPECIFIC`.
         *
         * Specify time series by uploading a CSV or Parquet file to an Amazon S3 bucket and set the location within the DataDestination data type.
         */
        public var timeSeriesGranularity: aws.sdk.kotlin.services.forecast.model.TimeSeriesGranularity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig) : this() {
            this.timePointGranularity = x.timePointGranularity
            this.timeSeriesGranularity = x.timeSeriesGranularity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig = ExplainabilityConfig(this)

        internal fun correctErrors(): Builder {
            if (timePointGranularity == null) timePointGranularity = TimePointGranularity.SdkUnknown("no value provided")
            if (timeSeriesGranularity == null) timeSeriesGranularity = TimeSeriesGranularity.SdkUnknown("no value provided")
            return this
        }
    }
}
