// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An Key Management Service (KMS) key and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key. You can specify this optional object in the CreateDataset and CreatePredictor requests.
 */
public class EncryptionConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the KMS key.
     */
    public val kmsKeyArn: kotlin.String = requireNotNull(builder.kmsKeyArn) { "A non-null value must be provided for kmsKeyArn" }
    /**
     * The ARN of the IAM role that Amazon Forecast can assume to access the KMS key.
     *
     * Passing a role across Amazon Web Services accounts is not allowed. If you pass a role that isn't in your account, you get an `InvalidInputException` error.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.EncryptionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionConfig(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn.hashCode()
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionConfig

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.EncryptionConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the KMS key.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The ARN of the IAM role that Amazon Forecast can assume to access the KMS key.
         *
         * Passing a role across Amazon Web Services accounts is not allowed. If you pass a role that isn't in your account, you get an `InvalidInputException` error.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.EncryptionConfig) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.EncryptionConfig = EncryptionConfig(this)

        internal fun correctErrors(): Builder {
            if (kmsKeyArn == null) kmsKeyArn = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
