// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeForecastExportJobResponse private constructor(builder: Builder) {
    /**
     * When the forecast export job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
     */
    public val destination: aws.sdk.kotlin.services.forecast.model.DataDestination? = builder.destination
    /**
     * The Amazon Resource Name (ARN) of the exported forecast.
     */
    public val forecastArn: kotlin.String? = builder.forecastArn
    /**
     * The ARN of the forecast export job.
     */
    public val forecastExportJobArn: kotlin.String? = builder.forecastExportJobArn
    /**
     * The name of the forecast export job.
     */
    public val forecastExportJobName: kotlin.String? = builder.forecastExportJobName
    /**
     * The format of the exported data, CSV or PARQUET.
     */
    public val format: kotlin.String? = builder.format
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * If an error occurred, an informational message about the error.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The status of the forecast export job. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     *
     * The `Status` of the forecast export job must be `ACTIVE` before you can access the forecast in your S3 bucket.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.DescribeForecastExportJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeForecastExportJobResponse(")
        append("creationTime=$creationTime,")
        append("destination=$destination,")
        append("forecastArn=$forecastArn,")
        append("forecastExportJobArn=$forecastExportJobArn,")
        append("forecastExportJobName=$forecastExportJobName,")
        append("format=$format,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (forecastArn?.hashCode() ?: 0)
        result = 31 * result + (forecastExportJobArn?.hashCode() ?: 0)
        result = 31 * result + (forecastExportJobName?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeForecastExportJobResponse

        if (creationTime != other.creationTime) return false
        if (destination != other.destination) return false
        if (forecastArn != other.forecastArn) return false
        if (forecastExportJobArn != other.forecastExportJobArn) return false
        if (forecastExportJobName != other.forecastExportJobName) return false
        if (format != other.format) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.DescribeForecastExportJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the forecast export job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
         */
        public var destination: aws.sdk.kotlin.services.forecast.model.DataDestination? = null
        /**
         * The Amazon Resource Name (ARN) of the exported forecast.
         */
        public var forecastArn: kotlin.String? = null
        /**
         * The ARN of the forecast export job.
         */
        public var forecastExportJobArn: kotlin.String? = null
        /**
         * The name of the forecast export job.
         */
        public var forecastExportJobName: kotlin.String? = null
        /**
         * The format of the exported data, CSV or PARQUET.
         */
        public var format: kotlin.String? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If an error occurred, an informational message about the error.
         */
        public var message: kotlin.String? = null
        /**
         * The status of the forecast export job. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         *
         * The `Status` of the forecast export job must be `ACTIVE` before you can access the forecast in your S3 bucket.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.DescribeForecastExportJobResponse) : this() {
            this.creationTime = x.creationTime
            this.destination = x.destination
            this.forecastArn = x.forecastArn
            this.forecastExportJobArn = x.forecastExportJobArn
            this.forecastExportJobName = x.forecastExportJobName
            this.format = x.format
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.DescribeForecastExportJobResponse = DescribeForecastExportJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.DataDestination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.forecast.model.DataDestination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.forecast.model.DataDestination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
