// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateWhatIfForecastRequest private constructor(builder: Builder) {
    /**
     * A list of [tags](https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html) to apply to the what if forecast.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The replacement time series dataset, which contains the rows that you want to change in the related time series dataset. A replacement time series does not need to contain all rows that are in the baseline related time series. Include only the rows (measure-dimension combinations) that you want to include in the what-if forecast.
     *
     * This dataset is merged with the original time series to create a transformed dataset that is used for the what-if analysis.
     *
     * This dataset should contain the items to modify (such as item_id or workforce_type), any relevant dimensions, the timestamp column, and at least one of the related time series columns. This file should not contain duplicate timestamps for the same time series.
     *
     * Timestamps and item_ids not included in this dataset are not included in the what-if analysis.
     */
    public val timeSeriesReplacementsDataSource: aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource? = builder.timeSeriesReplacementsDataSource
    /**
     * The transformations that are applied to the baseline time series. Each transformation contains an action and a set of conditions. An action is applied only when all conditions are met. If no conditions are provided, the action is applied to all items.
     */
    public val timeSeriesTransformations: List<TimeSeriesTransformation>? = builder.timeSeriesTransformations
    /**
     * The Amazon Resource Name (ARN) of the what-if analysis.
     */
    public val whatIfAnalysisArn: kotlin.String? = builder.whatIfAnalysisArn
    /**
     * The name of the what-if forecast. Names must be unique within each what-if analysis.
     */
    public val whatIfForecastName: kotlin.String? = builder.whatIfForecastName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.CreateWhatIfForecastRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWhatIfForecastRequest(")
        append("tags=$tags,")
        append("timeSeriesReplacementsDataSource=$timeSeriesReplacementsDataSource,")
        append("timeSeriesTransformations=$timeSeriesTransformations,")
        append("whatIfAnalysisArn=$whatIfAnalysisArn,")
        append("whatIfForecastName=$whatIfForecastName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = tags?.hashCode() ?: 0
        result = 31 * result + (timeSeriesReplacementsDataSource?.hashCode() ?: 0)
        result = 31 * result + (timeSeriesTransformations?.hashCode() ?: 0)
        result = 31 * result + (whatIfAnalysisArn?.hashCode() ?: 0)
        result = 31 * result + (whatIfForecastName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWhatIfForecastRequest

        if (tags != other.tags) return false
        if (timeSeriesReplacementsDataSource != other.timeSeriesReplacementsDataSource) return false
        if (timeSeriesTransformations != other.timeSeriesTransformations) return false
        if (whatIfAnalysisArn != other.whatIfAnalysisArn) return false
        if (whatIfForecastName != other.whatIfForecastName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.CreateWhatIfForecastRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of [tags](https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html) to apply to the what if forecast.
         */
        public var tags: List<Tag>? = null
        /**
         * The replacement time series dataset, which contains the rows that you want to change in the related time series dataset. A replacement time series does not need to contain all rows that are in the baseline related time series. Include only the rows (measure-dimension combinations) that you want to include in the what-if forecast.
         *
         * This dataset is merged with the original time series to create a transformed dataset that is used for the what-if analysis.
         *
         * This dataset should contain the items to modify (such as item_id or workforce_type), any relevant dimensions, the timestamp column, and at least one of the related time series columns. This file should not contain duplicate timestamps for the same time series.
         *
         * Timestamps and item_ids not included in this dataset are not included in the what-if analysis.
         */
        public var timeSeriesReplacementsDataSource: aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource? = null
        /**
         * The transformations that are applied to the baseline time series. Each transformation contains an action and a set of conditions. An action is applied only when all conditions are met. If no conditions are provided, the action is applied to all items.
         */
        public var timeSeriesTransformations: List<TimeSeriesTransformation>? = null
        /**
         * The Amazon Resource Name (ARN) of the what-if analysis.
         */
        public var whatIfAnalysisArn: kotlin.String? = null
        /**
         * The name of the what-if forecast. Names must be unique within each what-if analysis.
         */
        public var whatIfForecastName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.CreateWhatIfForecastRequest) : this() {
            this.tags = x.tags
            this.timeSeriesReplacementsDataSource = x.timeSeriesReplacementsDataSource
            this.timeSeriesTransformations = x.timeSeriesTransformations
            this.whatIfAnalysisArn = x.whatIfAnalysisArn
            this.whatIfForecastName = x.whatIfForecastName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.CreateWhatIfForecastRequest = CreateWhatIfForecastRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource] inside the given [block]
         */
        public fun timeSeriesReplacementsDataSource(block: aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource.Builder.() -> kotlin.Unit) {
            this.timeSeriesReplacementsDataSource = aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
