// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDatasetImportJobRequest private constructor(builder: Builder) {
    /**
     * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.
     *
     * If encryption is used, `DataSource` must include an Key Management Service (KMS) key and the IAM role must allow Amazon Forecast permission to access the key. The KMS key and IAM role must match those specified in the `EncryptionConfig` parameter of the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation.
     */
    public val dataSource: aws.sdk.kotlin.services.forecast.model.DataSource? = builder.dataSource
    /**
     * The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The name for the dataset import job. We recommend including the current timestamp in the name, for example, `20190721DatasetImport`. This can help you avoid getting a `ResourceAlreadyExistsException` exception.
     */
    public val datasetImportJobName: kotlin.String? = builder.datasetImportJobName
    /**
     * The format of the imported data, CSV or PARQUET. The default value is CSV.
     */
    public val format: kotlin.String? = builder.format
    /**
     * The format of the geolocation attribute. The geolocation attribute can be formatted in one of two ways:
     * + `LAT_LONG` - the latitude and longitude in decimal format (Example: 47.61_-122.33).
     * + `CC_POSTALCODE` (US Only) - the country code (US), followed by the 5-digit ZIP code (Example: US_98121).
     */
    public val geolocationFormat: kotlin.String? = builder.geolocationFormat
    /**
     * Specifies whether the dataset import job is a `FULL` or `INCREMENTAL` import. A `FULL` dataset import replaces all of the existing data with the newly imported data. An `INCREMENTAL` import appends the imported data to the existing data.
     */
    public val importMode: aws.sdk.kotlin.services.forecast.model.ImportMode? = builder.importMode
    /**
     * The optional metadata that you apply to the dataset import job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A single time zone for every item in your dataset. This option is ideal for datasets with all timestamps within a single time zone, or if all timestamps are normalized to a single time zone.
     *
     * Refer to the [Joda-Time API](http://joda-time.sourceforge.net/timezones.html) for a complete list of valid time zone names.
     */
    public val timeZone: kotlin.String? = builder.timeZone
    /**
     * The format of timestamps in the dataset. The format that you specify depends on the `DataFrequency` specified when the dataset was created. The following formats are supported
     * + "yyyy-MM-dd"For the following data frequencies: Y, M, W, and D
     * + "yyyy-MM-dd HH:mm:ss"For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     *
     * If the format isn't specified, Amazon Forecast expects the format to be "yyyy-MM-dd HH:mm:ss".
     */
    public val timestampFormat: kotlin.String? = builder.timestampFormat
    /**
     * Automatically derive time zone information from the geolocation attribute. This option is ideal for datasets that contain timestamps in multiple time zones and those timestamps are expressed in local time.
     */
    public val useGeolocationForTimeZone: kotlin.Boolean? = builder.useGeolocationForTimeZone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.CreateDatasetImportJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatasetImportJobRequest(")
        append("dataSource=$dataSource,")
        append("datasetArn=$datasetArn,")
        append("datasetImportJobName=$datasetImportJobName,")
        append("format=$format,")
        append("geolocationFormat=$geolocationFormat,")
        append("importMode=$importMode,")
        append("tags=$tags,")
        append("timeZone=$timeZone,")
        append("timestampFormat=$timestampFormat,")
        append("useGeolocationForTimeZone=$useGeolocationForTimeZone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetImportJobName?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (geolocationFormat?.hashCode() ?: 0)
        result = 31 * result + (importMode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeZone?.hashCode() ?: 0)
        result = 31 * result + (timestampFormat?.hashCode() ?: 0)
        result = 31 * result + (useGeolocationForTimeZone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDatasetImportJobRequest

        if (dataSource != other.dataSource) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetImportJobName != other.datasetImportJobName) return false
        if (format != other.format) return false
        if (geolocationFormat != other.geolocationFormat) return false
        if (importMode != other.importMode) return false
        if (tags != other.tags) return false
        if (timeZone != other.timeZone) return false
        if (timestampFormat != other.timestampFormat) return false
        if (useGeolocationForTimeZone != other.useGeolocationForTimeZone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.CreateDatasetImportJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.
         *
         * If encryption is used, `DataSource` must include an Key Management Service (KMS) key and the IAM role must allow Amazon Forecast permission to access the key. The KMS key and IAM role must match those specified in the `EncryptionConfig` parameter of the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation.
         */
        public var dataSource: aws.sdk.kotlin.services.forecast.model.DataSource? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * The name for the dataset import job. We recommend including the current timestamp in the name, for example, `20190721DatasetImport`. This can help you avoid getting a `ResourceAlreadyExistsException` exception.
         */
        public var datasetImportJobName: kotlin.String? = null
        /**
         * The format of the imported data, CSV or PARQUET. The default value is CSV.
         */
        public var format: kotlin.String? = null
        /**
         * The format of the geolocation attribute. The geolocation attribute can be formatted in one of two ways:
         * + `LAT_LONG` - the latitude and longitude in decimal format (Example: 47.61_-122.33).
         * + `CC_POSTALCODE` (US Only) - the country code (US), followed by the 5-digit ZIP code (Example: US_98121).
         */
        public var geolocationFormat: kotlin.String? = null
        /**
         * Specifies whether the dataset import job is a `FULL` or `INCREMENTAL` import. A `FULL` dataset import replaces all of the existing data with the newly imported data. An `INCREMENTAL` import appends the imported data to the existing data.
         */
        public var importMode: aws.sdk.kotlin.services.forecast.model.ImportMode? = null
        /**
         * The optional metadata that you apply to the dataset import job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * A single time zone for every item in your dataset. This option is ideal for datasets with all timestamps within a single time zone, or if all timestamps are normalized to a single time zone.
         *
         * Refer to the [Joda-Time API](http://joda-time.sourceforge.net/timezones.html) for a complete list of valid time zone names.
         */
        public var timeZone: kotlin.String? = null
        /**
         * The format of timestamps in the dataset. The format that you specify depends on the `DataFrequency` specified when the dataset was created. The following formats are supported
         * + "yyyy-MM-dd"For the following data frequencies: Y, M, W, and D
         * + "yyyy-MM-dd HH:mm:ss"For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         *
         * If the format isn't specified, Amazon Forecast expects the format to be "yyyy-MM-dd HH:mm:ss".
         */
        public var timestampFormat: kotlin.String? = null
        /**
         * Automatically derive time zone information from the geolocation attribute. This option is ideal for datasets that contain timestamps in multiple time zones and those timestamps are expressed in local time.
         */
        public var useGeolocationForTimeZone: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.CreateDatasetImportJobRequest) : this() {
            this.dataSource = x.dataSource
            this.datasetArn = x.datasetArn
            this.datasetImportJobName = x.datasetImportJobName
            this.format = x.format
            this.geolocationFormat = x.geolocationFormat
            this.importMode = x.importMode
            this.tags = x.tags
            this.timeZone = x.timeZone
            this.timestampFormat = x.timestampFormat
            this.useGeolocationForTimeZone = x.useGeolocationForTimeZone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.CreateDatasetImportJobRequest = CreateDatasetImportJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.DataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.forecast.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.forecast.model.DataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
