// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAutoPredictorRequest private constructor(builder: Builder) {
    /**
     * The data configuration for your dataset group and any additional datasets.
     */
    public val dataConfig: aws.sdk.kotlin.services.forecast.model.DataConfig? = builder.dataConfig
    /**
     * An Key Management Service (KMS) key and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key. You can specify this optional object in the CreateDataset and CreatePredictor requests.
     */
    public val encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = builder.encryptionConfig
    /**
     * Create an Explainability resource for the predictor.
     */
    public val explainPredictor: kotlin.Boolean? = builder.explainPredictor
    /**
     * An array of dimension (field) names that specify how to group the generated forecast.
     *
     * For example, if you are generating forecasts for item sales across all your stores, and your dataset contains a `store_id` field, you would specify `store_id` as a dimension to group sales forecasts for each store.
     */
    public val forecastDimensions: List<String>? = builder.forecastDimensions
    /**
     * The frequency of predictions in a forecast.
     *
     * Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D (Day), H (Hour), and min (Minute). For example, "1D" indicates every day and "15min" indicates every 15 minutes. You cannot specify a value that would overlap with the next larger frequency. That means, for example, you cannot specify a frequency of 60 minutes, because that is equivalent to 1 hour. The valid values for each frequency are the following:
     * + Minute - 1-59
     * + Hour - 1-23
     * + Day - 1-6
     * + Week - 1-4
     * + Month - 1-11
     * + Year - 1
     *
     * Thus, if you want every other week forecasts, specify "2W". Or, if you want quarterly forecasts, you specify "3M".
     *
     * The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.
     *
     * When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES dataset frequency.
     */
    public val forecastFrequency: kotlin.String? = builder.forecastFrequency
    /**
     * The number of time-steps that the model predicts. The forecast horizon is also called the prediction length.
     *
     * The maximum forecast horizon is the lesser of 500 time-steps or 1/4 of the TARGET_TIME_SERIES dataset length. If you are retraining an existing AutoPredictor, then the maximum forecast horizon is the lesser of 500 time-steps or 1/3 of the TARGET_TIME_SERIES dataset length.
     *
     * If you are upgrading to an AutoPredictor or retraining an existing AutoPredictor, you cannot update the forecast horizon parameter. You can meet this requirement by providing longer time-series in the dataset.
     */
    public val forecastHorizon: kotlin.Int? = builder.forecastHorizon
    /**
     * The forecast types used to train a predictor. You can specify up to five forecast types. Forecast types can be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the mean forecast with `mean`.
     */
    public val forecastTypes: List<String>? = builder.forecastTypes
    /**
     * The configuration details for predictor monitoring. Provide a name for the monitor resource to enable predictor monitoring.
     *
     * Predictor monitoring allows you to see how your predictor's performance changes over time. For more information, see [Predictor Monitoring](https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring.html).
     */
    public val monitorConfig: aws.sdk.kotlin.services.forecast.model.MonitorConfig? = builder.monitorConfig
    /**
     * The accuracy metric used to optimize the predictor.
     */
    public val optimizationMetric: aws.sdk.kotlin.services.forecast.model.OptimizationMetric? = builder.optimizationMetric
    /**
     * A unique name for the predictor
     */
    public val predictorName: kotlin.String? = builder.predictorName
    /**
     * The ARN of the predictor to retrain or upgrade. This parameter is only used when retraining or upgrading a predictor. When creating a new predictor, do not specify a value for this parameter.
     *
     * When upgrading or retraining a predictor, only specify values for the `ReferencePredictorArn` and `PredictorName`. The value for `PredictorName` must be a unique predictor name.
     */
    public val referencePredictorArn: kotlin.String? = builder.referencePredictorArn
    /**
     * Optional metadata to help you categorize and organize your predictors. Each tag consists of a key and an optional value, both of which you define. Tag keys and values are case sensitive.
     *
     * The following restrictions apply to tags:
     * + For each resource, each tag key must be unique and each tag key must have one value.
     * + Maximum number of tags per resource: 50.
     * + Maximum key length: 128 Unicode characters in UTF-8.
     * + Maximum value length: 256 Unicode characters in UTF-8.
     * + Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your tagging schema is used across other services and resources, the character restrictions of those services also apply.
     * + Key prefixes cannot include any upper or lowercase combination of `aws:` or `AWS:`. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit. You cannot edit or delete tag keys with this prefix.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The time boundary Forecast uses to align and aggregate any data that doesn't align with your forecast frequency. Provide the unit of time and the time boundary as a key value pair. For more information on specifying a time boundary, see [Specifying a Time Boundary](https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#specifying-time-boundary). If you don't provide a time boundary, Forecast uses a set of [Default Time Boundaries](https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#default-time-boundaries).
     */
    public val timeAlignmentBoundary: aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary? = builder.timeAlignmentBoundary

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.CreateAutoPredictorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAutoPredictorRequest(")
        append("dataConfig=$dataConfig,")
        append("encryptionConfig=$encryptionConfig,")
        append("explainPredictor=$explainPredictor,")
        append("forecastDimensions=$forecastDimensions,")
        append("forecastFrequency=$forecastFrequency,")
        append("forecastHorizon=$forecastHorizon,")
        append("forecastTypes=$forecastTypes,")
        append("monitorConfig=$monitorConfig,")
        append("optimizationMetric=$optimizationMetric,")
        append("predictorName=$predictorName,")
        append("referencePredictorArn=$referencePredictorArn,")
        append("tags=$tags,")
        append("timeAlignmentBoundary=$timeAlignmentBoundary")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataConfig?.hashCode() ?: 0
        result = 31 * result + (encryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (explainPredictor?.hashCode() ?: 0)
        result = 31 * result + (forecastDimensions?.hashCode() ?: 0)
        result = 31 * result + (forecastFrequency?.hashCode() ?: 0)
        result = 31 * result + (forecastHorizon ?: 0)
        result = 31 * result + (forecastTypes?.hashCode() ?: 0)
        result = 31 * result + (monitorConfig?.hashCode() ?: 0)
        result = 31 * result + (optimizationMetric?.hashCode() ?: 0)
        result = 31 * result + (predictorName?.hashCode() ?: 0)
        result = 31 * result + (referencePredictorArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeAlignmentBoundary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAutoPredictorRequest

        if (dataConfig != other.dataConfig) return false
        if (encryptionConfig != other.encryptionConfig) return false
        if (explainPredictor != other.explainPredictor) return false
        if (forecastDimensions != other.forecastDimensions) return false
        if (forecastFrequency != other.forecastFrequency) return false
        if (forecastHorizon != other.forecastHorizon) return false
        if (forecastTypes != other.forecastTypes) return false
        if (monitorConfig != other.monitorConfig) return false
        if (optimizationMetric != other.optimizationMetric) return false
        if (predictorName != other.predictorName) return false
        if (referencePredictorArn != other.referencePredictorArn) return false
        if (tags != other.tags) return false
        if (timeAlignmentBoundary != other.timeAlignmentBoundary) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.CreateAutoPredictorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The data configuration for your dataset group and any additional datasets.
         */
        public var dataConfig: aws.sdk.kotlin.services.forecast.model.DataConfig? = null
        /**
         * An Key Management Service (KMS) key and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key. You can specify this optional object in the CreateDataset and CreatePredictor requests.
         */
        public var encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = null
        /**
         * Create an Explainability resource for the predictor.
         */
        public var explainPredictor: kotlin.Boolean? = null
        /**
         * An array of dimension (field) names that specify how to group the generated forecast.
         *
         * For example, if you are generating forecasts for item sales across all your stores, and your dataset contains a `store_id` field, you would specify `store_id` as a dimension to group sales forecasts for each store.
         */
        public var forecastDimensions: List<String>? = null
        /**
         * The frequency of predictions in a forecast.
         *
         * Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D (Day), H (Hour), and min (Minute). For example, "1D" indicates every day and "15min" indicates every 15 minutes. You cannot specify a value that would overlap with the next larger frequency. That means, for example, you cannot specify a frequency of 60 minutes, because that is equivalent to 1 hour. The valid values for each frequency are the following:
         * + Minute - 1-59
         * + Hour - 1-23
         * + Day - 1-6
         * + Week - 1-4
         * + Month - 1-11
         * + Year - 1
         *
         * Thus, if you want every other week forecasts, specify "2W". Or, if you want quarterly forecasts, you specify "3M".
         *
         * The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.
         *
         * When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES dataset frequency.
         */
        public var forecastFrequency: kotlin.String? = null
        /**
         * The number of time-steps that the model predicts. The forecast horizon is also called the prediction length.
         *
         * The maximum forecast horizon is the lesser of 500 time-steps or 1/4 of the TARGET_TIME_SERIES dataset length. If you are retraining an existing AutoPredictor, then the maximum forecast horizon is the lesser of 500 time-steps or 1/3 of the TARGET_TIME_SERIES dataset length.
         *
         * If you are upgrading to an AutoPredictor or retraining an existing AutoPredictor, you cannot update the forecast horizon parameter. You can meet this requirement by providing longer time-series in the dataset.
         */
        public var forecastHorizon: kotlin.Int? = null
        /**
         * The forecast types used to train a predictor. You can specify up to five forecast types. Forecast types can be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the mean forecast with `mean`.
         */
        public var forecastTypes: List<String>? = null
        /**
         * The configuration details for predictor monitoring. Provide a name for the monitor resource to enable predictor monitoring.
         *
         * Predictor monitoring allows you to see how your predictor's performance changes over time. For more information, see [Predictor Monitoring](https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring.html).
         */
        public var monitorConfig: aws.sdk.kotlin.services.forecast.model.MonitorConfig? = null
        /**
         * The accuracy metric used to optimize the predictor.
         */
        public var optimizationMetric: aws.sdk.kotlin.services.forecast.model.OptimizationMetric? = null
        /**
         * A unique name for the predictor
         */
        public var predictorName: kotlin.String? = null
        /**
         * The ARN of the predictor to retrain or upgrade. This parameter is only used when retraining or upgrading a predictor. When creating a new predictor, do not specify a value for this parameter.
         *
         * When upgrading or retraining a predictor, only specify values for the `ReferencePredictorArn` and `PredictorName`. The value for `PredictorName` must be a unique predictor name.
         */
        public var referencePredictorArn: kotlin.String? = null
        /**
         * Optional metadata to help you categorize and organize your predictors. Each tag consists of a key and an optional value, both of which you define. Tag keys and values are case sensitive.
         *
         * The following restrictions apply to tags:
         * + For each resource, each tag key must be unique and each tag key must have one value.
         * + Maximum number of tags per resource: 50.
         * + Maximum key length: 128 Unicode characters in UTF-8.
         * + Maximum value length: 256 Unicode characters in UTF-8.
         * + Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your tagging schema is used across other services and resources, the character restrictions of those services also apply.
         * + Key prefixes cannot include any upper or lowercase combination of `aws:` or `AWS:`. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit. You cannot edit or delete tag keys with this prefix.
         */
        public var tags: List<Tag>? = null
        /**
         * The time boundary Forecast uses to align and aggregate any data that doesn't align with your forecast frequency. Provide the unit of time and the time boundary as a key value pair. For more information on specifying a time boundary, see [Specifying a Time Boundary](https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#specifying-time-boundary). If you don't provide a time boundary, Forecast uses a set of [Default Time Boundaries](https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#default-time-boundaries).
         */
        public var timeAlignmentBoundary: aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.CreateAutoPredictorRequest) : this() {
            this.dataConfig = x.dataConfig
            this.encryptionConfig = x.encryptionConfig
            this.explainPredictor = x.explainPredictor
            this.forecastDimensions = x.forecastDimensions
            this.forecastFrequency = x.forecastFrequency
            this.forecastHorizon = x.forecastHorizon
            this.forecastTypes = x.forecastTypes
            this.monitorConfig = x.monitorConfig
            this.optimizationMetric = x.optimizationMetric
            this.predictorName = x.predictorName
            this.referencePredictorArn = x.referencePredictorArn
            this.tags = x.tags
            this.timeAlignmentBoundary = x.timeAlignmentBoundary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.CreateAutoPredictorRequest = CreateAutoPredictorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.DataConfig] inside the given [block]
         */
        public fun dataConfig(block: aws.sdk.kotlin.services.forecast.model.DataConfig.Builder.() -> kotlin.Unit) {
            this.dataConfig = aws.sdk.kotlin.services.forecast.model.DataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.EncryptionConfig] inside the given [block]
         */
        public fun encryptionConfig(block: aws.sdk.kotlin.services.forecast.model.EncryptionConfig.Builder.() -> kotlin.Unit) {
            this.encryptionConfig = aws.sdk.kotlin.services.forecast.model.EncryptionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.MonitorConfig] inside the given [block]
         */
        public fun monitorConfig(block: aws.sdk.kotlin.services.forecast.model.MonitorConfig.Builder.() -> kotlin.Unit) {
            this.monitorConfig = aws.sdk.kotlin.services.forecast.model.MonitorConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary] inside the given [block]
         */
        public fun timeAlignmentBoundary(block: aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary.Builder.() -> kotlin.Unit) {
            this.timeAlignmentBoundary = aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
