// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an additional dataset. This object is part of the DataConfig object. Forecast supports the Weather Index and Holidays additional datasets.
 *
 * **Weather Index**
 *
 * The Amazon Forecast Weather Index is a built-in dataset that incorporates historical and projected weather information into your model. The Weather Index supplements your datasets with over two years of historical weather data and up to 14 days of projected weather data. For more information, see [Amazon Forecast Weather Index](https://docs.aws.amazon.com/forecast/latest/dg/weather.html).
 *
 * **Holidays**
 *
 * Holidays is a built-in dataset that incorporates national holiday information into your model. It provides native support for the holiday calendars of 66 countries. To view the holiday calendars, refer to the [Jollyday](http://jollyday.sourceforge.net/data.html) library. For more information, see [Holidays Featurization](https://docs.aws.amazon.com/forecast/latest/dg/holidays.html).
 */
public class AdditionalDataset private constructor(builder: Builder) {
    /**
     * **Weather Index**
     *
     * To enable the Weather Index, do not specify a value for `Configuration`.
     *
     * **Holidays**
     *
     * **Holidays**
     *
     * To enable Holidays, set `CountryCode` to one of the following two-letter country codes:
     * + "AL" - ALBANIA
     * + "AR" - ARGENTINA
     * + "AT" - AUSTRIA
     * + "AU" - AUSTRALIA
     * + "BA" - BOSNIA HERZEGOVINA
     * + "BE" - BELGIUM
     * + "BG" - BULGARIA
     * + "BO" - BOLIVIA
     * + "BR" - BRAZIL
     * + "BY" - BELARUS
     * + "CA" - CANADA
     * + "CL" - CHILE
     * + "CO" - COLOMBIA
     * + "CR" - COSTA RICA
     * + "HR" - CROATIA
     * + "CZ" - CZECH REPUBLIC
     * + "DK" - DENMARK
     * + "EC" - ECUADOR
     * + "EE" - ESTONIA
     * + "ET" - ETHIOPIA
     * + "FI" - FINLAND
     * + "FR" - FRANCE
     * + "DE" - GERMANY
     * + "GR" - GREECE
     * + "HU" - HUNGARY
     * + "IS" - ICELAND
     * + "IN" - INDIA
     * + "IE" - IRELAND
     * + "IT" - ITALY
     * + "JP" - JAPAN
     * + "KZ" - KAZAKHSTAN
     * + "KR" - KOREA
     * + "LV" - LATVIA
     * + "LI" - LIECHTENSTEIN
     * + "LT" - LITHUANIA
     * + "LU" - LUXEMBOURG
     * + "MK" - MACEDONIA
     * + "MT" - MALTA
     * + "MX" - MEXICO
     * + "MD" - MOLDOVA
     * + "ME" - MONTENEGRO
     * + "NL" - NETHERLANDS
     * + "NZ" - NEW ZEALAND
     * + "NI" - NICARAGUA
     * + "NG" - NIGERIA
     * + "NO" - NORWAY
     * + "PA" - PANAMA
     * + "PY" - PARAGUAY
     * + "PE" - PERU
     * + "PL" - POLAND
     * + "PT" - PORTUGAL
     * + "RO" - ROMANIA
     * + "RU" - RUSSIA
     * + "RS" - SERBIA
     * + "SK" - SLOVAKIA
     * + "SI" - SLOVENIA
     * + "ZA" - SOUTH AFRICA
     * + "ES" - SPAIN
     * + "SE" - SWEDEN
     * + "CH" - SWITZERLAND
     * + "UA" - UKRAINE
     * + "AE" - UNITED ARAB EMIRATES
     * + "US" - UNITED STATES
     * + "UK" - UNITED KINGDOM
     * + "UY" - URUGUAY
     * + "VE" - VENEZUELA
     */
    public val configuration: Map<String, List<String>>? = builder.configuration
    /**
     * The name of the additional dataset. Valid names: `"holiday"` and `"weather"`.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.AdditionalDataset = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdditionalDataset(")
        append("configuration=$configuration,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdditionalDataset

        if (configuration != other.configuration) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.AdditionalDataset = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * **Weather Index**
         *
         * To enable the Weather Index, do not specify a value for `Configuration`.
         *
         * **Holidays**
         *
         * **Holidays**
         *
         * To enable Holidays, set `CountryCode` to one of the following two-letter country codes:
         * + "AL" - ALBANIA
         * + "AR" - ARGENTINA
         * + "AT" - AUSTRIA
         * + "AU" - AUSTRALIA
         * + "BA" - BOSNIA HERZEGOVINA
         * + "BE" - BELGIUM
         * + "BG" - BULGARIA
         * + "BO" - BOLIVIA
         * + "BR" - BRAZIL
         * + "BY" - BELARUS
         * + "CA" - CANADA
         * + "CL" - CHILE
         * + "CO" - COLOMBIA
         * + "CR" - COSTA RICA
         * + "HR" - CROATIA
         * + "CZ" - CZECH REPUBLIC
         * + "DK" - DENMARK
         * + "EC" - ECUADOR
         * + "EE" - ESTONIA
         * + "ET" - ETHIOPIA
         * + "FI" - FINLAND
         * + "FR" - FRANCE
         * + "DE" - GERMANY
         * + "GR" - GREECE
         * + "HU" - HUNGARY
         * + "IS" - ICELAND
         * + "IN" - INDIA
         * + "IE" - IRELAND
         * + "IT" - ITALY
         * + "JP" - JAPAN
         * + "KZ" - KAZAKHSTAN
         * + "KR" - KOREA
         * + "LV" - LATVIA
         * + "LI" - LIECHTENSTEIN
         * + "LT" - LITHUANIA
         * + "LU" - LUXEMBOURG
         * + "MK" - MACEDONIA
         * + "MT" - MALTA
         * + "MX" - MEXICO
         * + "MD" - MOLDOVA
         * + "ME" - MONTENEGRO
         * + "NL" - NETHERLANDS
         * + "NZ" - NEW ZEALAND
         * + "NI" - NICARAGUA
         * + "NG" - NIGERIA
         * + "NO" - NORWAY
         * + "PA" - PANAMA
         * + "PY" - PARAGUAY
         * + "PE" - PERU
         * + "PL" - POLAND
         * + "PT" - PORTUGAL
         * + "RO" - ROMANIA
         * + "RU" - RUSSIA
         * + "RS" - SERBIA
         * + "SK" - SLOVAKIA
         * + "SI" - SLOVENIA
         * + "ZA" - SOUTH AFRICA
         * + "ES" - SPAIN
         * + "SE" - SWEDEN
         * + "CH" - SWITZERLAND
         * + "UA" - UKRAINE
         * + "AE" - UNITED ARAB EMIRATES
         * + "US" - UNITED STATES
         * + "UK" - UNITED KINGDOM
         * + "UY" - URUGUAY
         * + "VE" - VENEZUELA
         */
        public var configuration: Map<String, List<String>>? = null
        /**
         * The name of the additional dataset. Valid names: `"holiday"` and `"weather"`.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.AdditionalDataset) : this() {
            this.configuration = x.configuration
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.AdditionalDataset = AdditionalDataset(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
