// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.forecast.auth.DefaultForecastAuthSchemeProvider
import aws.sdk.kotlin.services.forecast.auth.ForecastAuthSchemeProvider
import aws.sdk.kotlin.services.forecast.endpoints.DefaultForecastEndpointProvider
import aws.sdk.kotlin.services.forecast.endpoints.ForecastEndpointParameters
import aws.sdk.kotlin.services.forecast.endpoints.ForecastEndpointProvider
import aws.sdk.kotlin.services.forecast.model.CreateAutoPredictorRequest
import aws.sdk.kotlin.services.forecast.model.CreateAutoPredictorResponse
import aws.sdk.kotlin.services.forecast.model.CreateDatasetGroupRequest
import aws.sdk.kotlin.services.forecast.model.CreateDatasetGroupResponse
import aws.sdk.kotlin.services.forecast.model.CreateDatasetImportJobRequest
import aws.sdk.kotlin.services.forecast.model.CreateDatasetImportJobResponse
import aws.sdk.kotlin.services.forecast.model.CreateDatasetRequest
import aws.sdk.kotlin.services.forecast.model.CreateDatasetResponse
import aws.sdk.kotlin.services.forecast.model.CreateExplainabilityExportRequest
import aws.sdk.kotlin.services.forecast.model.CreateExplainabilityExportResponse
import aws.sdk.kotlin.services.forecast.model.CreateExplainabilityRequest
import aws.sdk.kotlin.services.forecast.model.CreateExplainabilityResponse
import aws.sdk.kotlin.services.forecast.model.CreateForecastExportJobRequest
import aws.sdk.kotlin.services.forecast.model.CreateForecastExportJobResponse
import aws.sdk.kotlin.services.forecast.model.CreateForecastRequest
import aws.sdk.kotlin.services.forecast.model.CreateForecastResponse
import aws.sdk.kotlin.services.forecast.model.CreateMonitorRequest
import aws.sdk.kotlin.services.forecast.model.CreateMonitorResponse
import aws.sdk.kotlin.services.forecast.model.CreatePredictorBacktestExportJobRequest
import aws.sdk.kotlin.services.forecast.model.CreatePredictorBacktestExportJobResponse
import aws.sdk.kotlin.services.forecast.model.CreatePredictorRequest
import aws.sdk.kotlin.services.forecast.model.CreatePredictorResponse
import aws.sdk.kotlin.services.forecast.model.CreateWhatIfAnalysisRequest
import aws.sdk.kotlin.services.forecast.model.CreateWhatIfAnalysisResponse
import aws.sdk.kotlin.services.forecast.model.CreateWhatIfForecastExportRequest
import aws.sdk.kotlin.services.forecast.model.CreateWhatIfForecastExportResponse
import aws.sdk.kotlin.services.forecast.model.CreateWhatIfForecastRequest
import aws.sdk.kotlin.services.forecast.model.CreateWhatIfForecastResponse
import aws.sdk.kotlin.services.forecast.model.DeleteDatasetGroupRequest
import aws.sdk.kotlin.services.forecast.model.DeleteDatasetGroupResponse
import aws.sdk.kotlin.services.forecast.model.DeleteDatasetImportJobRequest
import aws.sdk.kotlin.services.forecast.model.DeleteDatasetImportJobResponse
import aws.sdk.kotlin.services.forecast.model.DeleteDatasetRequest
import aws.sdk.kotlin.services.forecast.model.DeleteDatasetResponse
import aws.sdk.kotlin.services.forecast.model.DeleteExplainabilityExportRequest
import aws.sdk.kotlin.services.forecast.model.DeleteExplainabilityExportResponse
import aws.sdk.kotlin.services.forecast.model.DeleteExplainabilityRequest
import aws.sdk.kotlin.services.forecast.model.DeleteExplainabilityResponse
import aws.sdk.kotlin.services.forecast.model.DeleteForecastExportJobRequest
import aws.sdk.kotlin.services.forecast.model.DeleteForecastExportJobResponse
import aws.sdk.kotlin.services.forecast.model.DeleteForecastRequest
import aws.sdk.kotlin.services.forecast.model.DeleteForecastResponse
import aws.sdk.kotlin.services.forecast.model.DeleteMonitorRequest
import aws.sdk.kotlin.services.forecast.model.DeleteMonitorResponse
import aws.sdk.kotlin.services.forecast.model.DeletePredictorBacktestExportJobRequest
import aws.sdk.kotlin.services.forecast.model.DeletePredictorBacktestExportJobResponse
import aws.sdk.kotlin.services.forecast.model.DeletePredictorRequest
import aws.sdk.kotlin.services.forecast.model.DeletePredictorResponse
import aws.sdk.kotlin.services.forecast.model.DeleteResourceTreeRequest
import aws.sdk.kotlin.services.forecast.model.DeleteResourceTreeResponse
import aws.sdk.kotlin.services.forecast.model.DeleteWhatIfAnalysisRequest
import aws.sdk.kotlin.services.forecast.model.DeleteWhatIfAnalysisResponse
import aws.sdk.kotlin.services.forecast.model.DeleteWhatIfForecastExportRequest
import aws.sdk.kotlin.services.forecast.model.DeleteWhatIfForecastExportResponse
import aws.sdk.kotlin.services.forecast.model.DeleteWhatIfForecastRequest
import aws.sdk.kotlin.services.forecast.model.DeleteWhatIfForecastResponse
import aws.sdk.kotlin.services.forecast.model.DescribeAutoPredictorRequest
import aws.sdk.kotlin.services.forecast.model.DescribeAutoPredictorResponse
import aws.sdk.kotlin.services.forecast.model.DescribeDatasetGroupRequest
import aws.sdk.kotlin.services.forecast.model.DescribeDatasetGroupResponse
import aws.sdk.kotlin.services.forecast.model.DescribeDatasetImportJobRequest
import aws.sdk.kotlin.services.forecast.model.DescribeDatasetImportJobResponse
import aws.sdk.kotlin.services.forecast.model.DescribeDatasetRequest
import aws.sdk.kotlin.services.forecast.model.DescribeDatasetResponse
import aws.sdk.kotlin.services.forecast.model.DescribeExplainabilityExportRequest
import aws.sdk.kotlin.services.forecast.model.DescribeExplainabilityExportResponse
import aws.sdk.kotlin.services.forecast.model.DescribeExplainabilityRequest
import aws.sdk.kotlin.services.forecast.model.DescribeExplainabilityResponse
import aws.sdk.kotlin.services.forecast.model.DescribeForecastExportJobRequest
import aws.sdk.kotlin.services.forecast.model.DescribeForecastExportJobResponse
import aws.sdk.kotlin.services.forecast.model.DescribeForecastRequest
import aws.sdk.kotlin.services.forecast.model.DescribeForecastResponse
import aws.sdk.kotlin.services.forecast.model.DescribeMonitorRequest
import aws.sdk.kotlin.services.forecast.model.DescribeMonitorResponse
import aws.sdk.kotlin.services.forecast.model.DescribePredictorBacktestExportJobRequest
import aws.sdk.kotlin.services.forecast.model.DescribePredictorBacktestExportJobResponse
import aws.sdk.kotlin.services.forecast.model.DescribePredictorRequest
import aws.sdk.kotlin.services.forecast.model.DescribePredictorResponse
import aws.sdk.kotlin.services.forecast.model.DescribeWhatIfAnalysisRequest
import aws.sdk.kotlin.services.forecast.model.DescribeWhatIfAnalysisResponse
import aws.sdk.kotlin.services.forecast.model.DescribeWhatIfForecastExportRequest
import aws.sdk.kotlin.services.forecast.model.DescribeWhatIfForecastExportResponse
import aws.sdk.kotlin.services.forecast.model.DescribeWhatIfForecastRequest
import aws.sdk.kotlin.services.forecast.model.DescribeWhatIfForecastResponse
import aws.sdk.kotlin.services.forecast.model.GetAccuracyMetricsRequest
import aws.sdk.kotlin.services.forecast.model.GetAccuracyMetricsResponse
import aws.sdk.kotlin.services.forecast.model.ListDatasetGroupsRequest
import aws.sdk.kotlin.services.forecast.model.ListDatasetGroupsResponse
import aws.sdk.kotlin.services.forecast.model.ListDatasetImportJobsRequest
import aws.sdk.kotlin.services.forecast.model.ListDatasetImportJobsResponse
import aws.sdk.kotlin.services.forecast.model.ListDatasetsRequest
import aws.sdk.kotlin.services.forecast.model.ListDatasetsResponse
import aws.sdk.kotlin.services.forecast.model.ListExplainabilitiesRequest
import aws.sdk.kotlin.services.forecast.model.ListExplainabilitiesResponse
import aws.sdk.kotlin.services.forecast.model.ListExplainabilityExportsRequest
import aws.sdk.kotlin.services.forecast.model.ListExplainabilityExportsResponse
import aws.sdk.kotlin.services.forecast.model.ListForecastExportJobsRequest
import aws.sdk.kotlin.services.forecast.model.ListForecastExportJobsResponse
import aws.sdk.kotlin.services.forecast.model.ListForecastsRequest
import aws.sdk.kotlin.services.forecast.model.ListForecastsResponse
import aws.sdk.kotlin.services.forecast.model.ListMonitorEvaluationsRequest
import aws.sdk.kotlin.services.forecast.model.ListMonitorEvaluationsResponse
import aws.sdk.kotlin.services.forecast.model.ListMonitorsRequest
import aws.sdk.kotlin.services.forecast.model.ListMonitorsResponse
import aws.sdk.kotlin.services.forecast.model.ListPredictorBacktestExportJobsRequest
import aws.sdk.kotlin.services.forecast.model.ListPredictorBacktestExportJobsResponse
import aws.sdk.kotlin.services.forecast.model.ListPredictorsRequest
import aws.sdk.kotlin.services.forecast.model.ListPredictorsResponse
import aws.sdk.kotlin.services.forecast.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.forecast.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.forecast.model.ListWhatIfAnalysesRequest
import aws.sdk.kotlin.services.forecast.model.ListWhatIfAnalysesResponse
import aws.sdk.kotlin.services.forecast.model.ListWhatIfForecastExportsRequest
import aws.sdk.kotlin.services.forecast.model.ListWhatIfForecastExportsResponse
import aws.sdk.kotlin.services.forecast.model.ListWhatIfForecastsRequest
import aws.sdk.kotlin.services.forecast.model.ListWhatIfForecastsResponse
import aws.sdk.kotlin.services.forecast.model.ResumeResourceRequest
import aws.sdk.kotlin.services.forecast.model.ResumeResourceResponse
import aws.sdk.kotlin.services.forecast.model.StopResourceRequest
import aws.sdk.kotlin.services.forecast.model.StopResourceResponse
import aws.sdk.kotlin.services.forecast.model.TagResourceRequest
import aws.sdk.kotlin.services.forecast.model.TagResourceResponse
import aws.sdk.kotlin.services.forecast.model.UntagResourceRequest
import aws.sdk.kotlin.services.forecast.model.UntagResourceResponse
import aws.sdk.kotlin.services.forecast.model.UpdateDatasetGroupRequest
import aws.sdk.kotlin.services.forecast.model.UpdateDatasetGroupResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "forecast"
public const val SdkVersion: String = "1.5.26"
public const val ServiceApiVersion: String = "2018-06-26"

/**
 * Provides APIs for creating and managing Amazon Forecast resources.
 */
public interface ForecastClient : SdkClient {
    /**
     * ForecastClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ForecastClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Forecast",
                "FORECAST",
                "forecast",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ForecastClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ForecastClient = DefaultForecastClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ForecastEndpointProvider = builder.endpointProvider ?: DefaultForecastEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ForecastAuthSchemeProvider = builder.authSchemeProvider ?: DefaultForecastAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "forecast"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ForecastEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ForecastAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Amazon Forecast predictor.
     *
     * Amazon Forecast creates predictors with AutoPredictor, which involves applying the optimal combination of algorithms to each time series in your datasets. You can use CreateAutoPredictor to create new predictors or upgrade/retrain existing predictors.
     *
     * **Creating new predictors**
     *
     * The following parameters are required when creating a new predictor:
     * + `PredictorName` - A unique name for the predictor.
     * + `DatasetGroupArn` - The ARN of the dataset group used to train the predictor.
     * + `ForecastFrequency` - The granularity of your forecasts (hourly, daily, weekly, etc).
     * + `ForecastHorizon` - The number of time-steps that the model predicts. The forecast horizon is also called the prediction length.
     *
     * When creating a new predictor, do not specify a value for `ReferencePredictorArn`.
     *
     * **Upgrading and retraining predictors**
     *
     * The following parameters are required when retraining or upgrading a predictor:
     * + `PredictorName` - A unique name for the predictor.
     * + `ReferencePredictorArn` - The ARN of the predictor to retrain or upgrade.
     *
     * When upgrading or retraining a predictor, only specify values for the `ReferencePredictorArn` and `PredictorName`.
     */
    public suspend fun createAutoPredictor(input: CreateAutoPredictorRequest): CreateAutoPredictorResponse

    /**
     * Creates an Amazon Forecast dataset. The information about the dataset that you provide helps Forecast understand how to consume the data for model training. This includes the following:
     * + *`DataFrequency`* - How frequently your historical time-series data is collected.
     * + *`Domain`* and *`DatasetType`* - Each dataset has an associated dataset domain and a type within the domain. Amazon Forecast provides a list of predefined domains and types within each domain. For each unique dataset domain and type within the domain, Amazon Forecast requires your data to include a minimum set of predefined fields.
     * + *`Schema`* - A schema specifies the fields in the dataset, including the field name and data type.
     *
     * After creating a dataset, you import your training data into it and add the dataset to a dataset group. You use the dataset group to create a predictor. For more information, see [Importing datasets](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
     *
     * To get a list of all your datasets, use the [ListDatasets](https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasets.html) operation.
     *
     * For example Forecast datasets, see the [Amazon Forecast Sample GitHub repository](https://github.com/aws-samples/amazon-forecast-samples).
     *
     * The `Status` of a dataset must be `ACTIVE` before you can import training data. Use the [DescribeDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html) operation to get the status.
     */
    public suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Creates a dataset group, which holds a collection of related datasets. You can add datasets to the dataset group when you create the dataset group, or later by using the [UpdateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html) operation.
     *
     * After creating a dataset group and adding datasets, you use the dataset group when you create a predictor. For more information, see [Dataset groups](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
     *
     * To get a list of all your datasets groups, use the [ListDatasetGroups](https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetGroups.html) operation.
     *
     * The `Status` of a dataset group must be `ACTIVE` before you can use the dataset group to create a predictor. To get the status, use the [DescribeDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html) operation.
     */
    public suspend fun createDatasetGroup(input: CreateDatasetGroupRequest): CreateDatasetGroupResponse

    /**
     * Imports your training data to an Amazon Forecast dataset. You provide the location of your training data in an Amazon Simple Storage Service (Amazon S3) bucket and the Amazon Resource Name (ARN) of the dataset that you want to import the data to.
     *
     * You must specify a [DataSource](https://docs.aws.amazon.com/forecast/latest/dg/API_DataSource.html) object that includes an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data, as Amazon Forecast makes a copy of your data and processes it in an internal Amazon Web Services system. For more information, see [Set up permissions](https://docs.aws.amazon.com/forecast/latest/dg/aws-forecast-iam-roles.html).
     *
     * The training data must be in CSV or Parquet format. The delimiter must be a comma (,).
     *
     * You can specify the path to a specific file, the S3 bucket, or to a folder in the S3 bucket. For the latter two cases, Amazon Forecast imports all files up to the limit of 10,000 files.
     *
     * Because dataset imports are not aggregated, your most recent dataset import is the one that is used when training a predictor or generating a forecast. Make sure that your most recent dataset import contains all of the data you want to model off of, and not just the new data collected since the previous import.
     *
     * To get a list of all your dataset import jobs, filtered by specified criteria, use the [ListDatasetImportJobs](https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetImportJobs.html) operation.
     */
    public suspend fun createDatasetImportJob(input: CreateDatasetImportJobRequest): CreateDatasetImportJobResponse

    /**
     * Explainability is only available for Forecasts and Predictors generated from an AutoPredictor (CreateAutoPredictor)
     *
     * Creates an Amazon Forecast Explainability.
     *
     * Explainability helps you better understand how the attributes in your datasets impact forecast. Amazon Forecast uses a metric called Impact scores to quantify the relative impact of each attribute and determine whether they increase or decrease forecast values.
     *
     * To enable Forecast Explainability, your predictor must include at least one of the following: related time series, item metadata, or additional datasets like Holidays and the Weather Index.
     *
     * CreateExplainability accepts either a Predictor ARN or Forecast ARN. To receive aggregated Impact scores for all time series and time points in your datasets, provide a Predictor ARN. To receive Impact scores for specific time series and time points, provide a Forecast ARN.
     *
     * **CreateExplainability with a Predictor ARN**
     *
     * You can only have one Explainability resource per predictor. If you already enabled `ExplainPredictor` in CreateAutoPredictor, that predictor already has an Explainability resource.
     *
     * The following parameters are required when providing a Predictor ARN:
     * + `ExplainabilityName` - A unique name for the Explainability.
     * + `ResourceArn` - The Arn of the predictor.
     * + `TimePointGranularity` - Must be set to “ALL”.
     * + `TimeSeriesGranularity` - Must be set to “ALL”.
     *
     * Do not specify a value for the following parameters:
     * + `DataSource` - Only valid when TimeSeriesGranularity is “SPECIFIC”.
     * + `Schema` - Only valid when TimeSeriesGranularity is “SPECIFIC”.
     * + `StartDateTime` - Only valid when TimePointGranularity is “SPECIFIC”.
     * + `EndDateTime` - Only valid when TimePointGranularity is “SPECIFIC”.
     *
     * **CreateExplainability with a Forecast ARN**
     *
     * You can specify a maximum of 50 time series and 500 time points.
     *
     * The following parameters are required when providing a Predictor ARN:
     * + `ExplainabilityName` - A unique name for the Explainability.
     * + `ResourceArn` - The Arn of the forecast.
     * + `TimePointGranularity` - Either “ALL” or “SPECIFIC”.
     * + `TimeSeriesGranularity` - Either “ALL” or “SPECIFIC”.
     *
     * If you set TimeSeriesGranularity to “SPECIFIC”, you must also provide the following:
     * + `DataSource` - The S3 location of the CSV file specifying your time series.
     * + `Schema` - The Schema defines the attributes and attribute types listed in the Data Source.
     *
     * If you set TimePointGranularity to “SPECIFIC”, you must also provide the following:
     * + `StartDateTime` - The first timestamp in the range of time points.
     * + `EndDateTime` - The last timestamp in the range of time points.
     */
    public suspend fun createExplainability(input: CreateExplainabilityRequest): CreateExplainabilityResponse

    /**
     * Exports an Explainability resource created by the CreateExplainability operation. Exported files are exported to an Amazon Simple Storage Service (Amazon S3) bucket.
     *
     * You must specify a DataDestination object that includes an Amazon S3 bucket and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
     *
     * The `Status` of the export job must be `ACTIVE` before you can access the export in your Amazon S3 bucket. To get the status, use the DescribeExplainabilityExport operation.
     */
    public suspend fun createExplainabilityExport(input: CreateExplainabilityExportRequest): CreateExplainabilityExportResponse

    /**
     * Creates a forecast for each item in the `TARGET_TIME_SERIES` dataset that was used to train the predictor. This is known as inference. To retrieve the forecast for a single item at low latency, use the operation. To export the complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket, use the CreateForecastExportJob operation.
     *
     * The range of the forecast is determined by the `ForecastHorizon` value, which you specify in the CreatePredictor request. When you query a forecast, you can request a specific date range within the forecast.
     *
     * To get a list of all your forecasts, use the ListForecasts operation.
     *
     * The forecasts generated by Amazon Forecast are in the same time zone as the dataset that was used to create the predictor.
     *
     * For more information, see howitworks-forecast.
     *
     * The `Status` of the forecast must be `ACTIVE` before you can query or export the forecast. Use the DescribeForecast operation to get the status.
     *
     * By default, a forecast includes predictions for every item (`item_id`) in the dataset group that was used to train the predictor. However, you can use the `TimeSeriesSelector` object to generate a forecast on a subset of time series. Forecast creation is skipped for any time series that you specify that are not in the input dataset. The forecast export file will not contain these time series or their forecasted values.
     */
    public suspend fun createForecast(input: CreateForecastRequest): CreateForecastResponse

    /**
     * Exports a forecast created by the CreateForecast operation to your Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions:
     *
     * <forecastexportjobname>_<exporttimestamp>_<partnumber>
     *
     * where the <exporttimestamp> component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).
     *
     * You must specify a DataDestination object that includes an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
     *
     * For more information, see howitworks-forecast.
     *
     * To get a list of all your forecast export jobs, use the ListForecastExportJobs operation.
     *
     * The `Status` of the forecast export job must be `ACTIVE` before you can access the forecast in your Amazon S3 bucket. To get the status, use the DescribeForecastExportJob operation.
     */
    public suspend fun createForecastExportJob(input: CreateForecastExportJobRequest): CreateForecastExportJobResponse

    /**
     * Creates a predictor monitor resource for an existing auto predictor. Predictor monitoring allows you to see how your predictor's performance changes over time. For more information, see [Predictor Monitoring](https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring.html).
     */
    public suspend fun createMonitor(input: CreateMonitorRequest): CreateMonitorResponse

    /**
     * This operation creates a legacy predictor that does not include all the predictor functionalities provided by Amazon Forecast. To create a predictor that is compatible with all aspects of Forecast, use CreateAutoPredictor.
     *
     * Creates an Amazon Forecast predictor.
     *
     * In the request, provide a dataset group and either specify an algorithm or let Amazon Forecast choose an algorithm for you using AutoML. If you specify an algorithm, you also can override algorithm-specific hyperparameters.
     *
     * Amazon Forecast uses the algorithm to train a predictor using the latest version of the datasets in the specified dataset group. You can then generate a forecast using the CreateForecast operation.
     *
     *  To see the evaluation metrics, use the GetAccuracyMetrics operation.
     *
     * You can specify a featurization configuration to fill and aggregate the data fields in the `TARGET_TIME_SERIES` dataset to improve model training. For more information, see FeaturizationConfig.
     *
     * For RELATED_TIME_SERIES datasets, `CreatePredictor` verifies that the `DataFrequency` specified when the dataset was created matches the `ForecastFrequency`. TARGET_TIME_SERIES datasets don't have this restriction. Amazon Forecast also verifies the delimiter and timestamp format. For more information, see howitworks-datasets-groups.
     *
     * By default, predictors are trained and evaluated at the 0.1 (P10), 0.5 (P50), and 0.9 (P90) quantiles. You can choose custom forecast types to train and evaluate your predictor by setting the `ForecastTypes`.
     *
     * **AutoML**
     *
     * If you want Amazon Forecast to evaluate each algorithm and choose the one that minimizes the `objective function`, set `PerformAutoML` to `true`. The `objective function` is defined as the mean of the weighted losses over the forecast types. By default, these are the p10, p50, and p90 quantile losses. For more information, see EvaluationResult.
     *
     * When AutoML is enabled, the following properties are disallowed:
     * + `AlgorithmArn`
     * + `HPOConfig`
     * + `PerformHPO`
     * + `TrainingParameters`
     *
     * To get a list of all of your predictors, use the ListPredictors operation.
     *
     * Before you can use the predictor to create a forecast, the `Status` of the predictor must be `ACTIVE`, signifying that training has completed. To get the status, use the DescribePredictor operation.
     */
    public suspend fun createPredictor(input: CreatePredictorRequest): CreatePredictorResponse

    /**
     * Exports backtest forecasts and accuracy metrics generated by the CreateAutoPredictor or CreatePredictor operations. Two folders containing CSV or Parquet files are exported to your specified S3 bucket.
     *
     *  The export file names will match the following conventions:
     *
     * `<ExportJobName>_<ExportTimestamp>_<PartNumber>.csv`
     *
     * The <exporttimestamp> component is in Java SimpleDate format (yyyy-MM-ddTHH-mm-ssZ).
     *
     * You must specify a DataDestination object that includes an Amazon S3 bucket and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
     *
     * The `Status` of the export job must be `ACTIVE` before you can access the export in your Amazon S3 bucket. To get the status, use the DescribePredictorBacktestExportJob operation.
     */
    public suspend fun createPredictorBacktestExportJob(input: CreatePredictorBacktestExportJobRequest): CreatePredictorBacktestExportJobResponse

    /**
     * What-if analysis is a scenario modeling technique where you make a hypothetical change to a time series and compare the forecasts generated by these changes against the baseline, unchanged time series. It is important to remember that the purpose of a what-if analysis is to understand how a forecast can change given different modifications to the baseline time series.
     *
     * For example, imagine you are a clothing retailer who is considering an end of season sale to clear space for new styles. After creating a baseline forecast, you can use a what-if analysis to investigate how different sales tactics might affect your goals.
     *
     * You could create a scenario where everything is given a 25% markdown, and another where everything is given a fixed dollar markdown. You could create a scenario where the sale lasts for one week and another where the sale lasts for one month. With a what-if analysis, you can compare many different scenarios against each other.
     *
     * Note that a what-if analysis is meant to display what the forecasting model has learned and how it will behave in the scenarios that you are evaluating. Do not blindly use the results of the what-if analysis to make business decisions. For instance, forecasts might not be accurate for novel scenarios where there is no reference available to determine whether a forecast is good.
     *
     * The TimeSeriesSelector object defines the items that you want in the what-if analysis.
     */
    public suspend fun createWhatIfAnalysis(input: CreateWhatIfAnalysisRequest): CreateWhatIfAnalysisResponse

    /**
     * A what-if forecast is a forecast that is created from a modified version of the baseline forecast. Each what-if forecast incorporates either a replacement dataset or a set of transformations to the original dataset.
     */
    public suspend fun createWhatIfForecast(input: CreateWhatIfForecastRequest): CreateWhatIfForecastResponse

    /**
     * Exports a forecast created by the CreateWhatIfForecast operation to your Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions:
     *
     * `≈<ForecastExportJobName>_<ExportTimestamp>_<PartNumber>`
     *
     * The <exporttimestamp> component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).
     *
     * You must specify a DataDestination object that includes an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
     *
     * For more information, see howitworks-forecast.
     *
     * To get a list of all your what-if forecast export jobs, use the ListWhatIfForecastExports operation.
     *
     * The `Status` of the forecast export job must be `ACTIVE` before you can access the forecast in your Amazon S3 bucket. To get the status, use the DescribeWhatIfForecastExport operation.
     */
    public suspend fun createWhatIfForecastExport(input: CreateWhatIfForecastExportRequest): CreateWhatIfForecastExportResponse

    /**
     * Deletes an Amazon Forecast dataset that was created using the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation. You can only delete datasets that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status use the [DescribeDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html) operation.
     *
     * Forecast does not automatically update any dataset groups that contain the deleted dataset. In order to update the dataset group, use the [UpdateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html) operation, omitting the deleted dataset's ARN.
     */
    public suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse

    /**
     * Deletes a dataset group created using the [CreateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html) operation. You can only delete dataset groups that have a status of `ACTIVE`, `CREATE_FAILED`, or `UPDATE_FAILED`. To get the status, use the [DescribeDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html) operation.
     *
     * This operation deletes only the dataset group, not the datasets in the group.
     */
    public suspend fun deleteDatasetGroup(input: DeleteDatasetGroupRequest): DeleteDatasetGroupResponse

    /**
     * Deletes a dataset import job created using the [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation. You can delete only dataset import jobs that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the [DescribeDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html) operation.
     */
    public suspend fun deleteDatasetImportJob(input: DeleteDatasetImportJobRequest): DeleteDatasetImportJobResponse

    /**
     * Deletes an Explainability resource.
     *
     * You can delete only predictor that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeExplainability operation.
     */
    public suspend fun deleteExplainability(input: DeleteExplainabilityRequest): DeleteExplainabilityResponse

    /**
     * Deletes an Explainability export.
     */
    public suspend fun deleteExplainabilityExport(input: DeleteExplainabilityExportRequest): DeleteExplainabilityExportResponse

    /**
     * Deletes a forecast created using the CreateForecast operation. You can delete only forecasts that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeForecast operation.
     *
     * You can't delete a forecast while it is being exported. After a forecast is deleted, you can no longer query the forecast.
     */
    public suspend fun deleteForecast(input: DeleteForecastRequest): DeleteForecastResponse

    /**
     * Deletes a forecast export job created using the CreateForecastExportJob operation. You can delete only export jobs that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeForecastExportJob operation.
     */
    public suspend fun deleteForecastExportJob(input: DeleteForecastExportJobRequest): DeleteForecastExportJobResponse

    /**
     * Deletes a monitor resource. You can only delete a monitor resource with a status of `ACTIVE`, `ACTIVE_STOPPED`, `CREATE_FAILED`, or `CREATE_STOPPED`.
     */
    public suspend fun deleteMonitor(input: DeleteMonitorRequest): DeleteMonitorResponse

    /**
     * Deletes a predictor created using the DescribePredictor or CreatePredictor operations. You can delete only predictor that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribePredictor operation.
     */
    public suspend fun deletePredictor(input: DeletePredictorRequest): DeletePredictorResponse

    /**
     * Deletes a predictor backtest export job.
     */
    public suspend fun deletePredictorBacktestExportJob(input: DeletePredictorBacktestExportJobRequest): DeletePredictorBacktestExportJobResponse

    /**
     * Deletes an entire resource tree. This operation will delete the parent resource and its child resources.
     *
     * Child resources are resources that were created from another resource. For example, when a forecast is generated from a predictor, the forecast is the child resource and the predictor is the parent resource.
     *
     * Amazon Forecast resources possess the following parent-child resource hierarchies:
     * + **Dataset**: dataset import jobs
     * + **Dataset Group**: predictors, predictor backtest export jobs, forecasts, forecast export jobs
     * + **Predictor**: predictor backtest export jobs, forecasts, forecast export jobs
     * + **Forecast**: forecast export jobs
     *
     * `DeleteResourceTree` will only delete Amazon Forecast resources, and will not delete datasets or exported files stored in Amazon S3.
     */
    public suspend fun deleteResourceTree(input: DeleteResourceTreeRequest): DeleteResourceTreeResponse

    /**
     * Deletes a what-if analysis created using the CreateWhatIfAnalysis operation. You can delete only what-if analyses that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeWhatIfAnalysis operation.
     *
     * You can't delete a what-if analysis while any of its forecasts are being exported.
     */
    public suspend fun deleteWhatIfAnalysis(input: DeleteWhatIfAnalysisRequest): DeleteWhatIfAnalysisResponse

    /**
     * Deletes a what-if forecast created using the CreateWhatIfForecast operation. You can delete only what-if forecasts that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeWhatIfForecast operation.
     *
     * You can't delete a what-if forecast while it is being exported. After a what-if forecast is deleted, you can no longer query the what-if analysis.
     */
    public suspend fun deleteWhatIfForecast(input: DeleteWhatIfForecastRequest): DeleteWhatIfForecastResponse

    /**
     * Deletes a what-if forecast export created using the CreateWhatIfForecastExport operation. You can delete only what-if forecast exports that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeWhatIfForecastExport operation.
     */
    public suspend fun deleteWhatIfForecastExport(input: DeleteWhatIfForecastExportRequest): DeleteWhatIfForecastExportResponse

    /**
     * Describes a predictor created using the CreateAutoPredictor operation.
     */
    public suspend fun describeAutoPredictor(input: DescribeAutoPredictorRequest): DescribeAutoPredictorResponse

    /**
     * Describes an Amazon Forecast dataset created using the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation.
     *
     * In addition to listing the parameters specified in the `CreateDataset` request, this operation includes the following dataset properties:
     * + `CreationTime`
     * + `LastModificationTime`
     * + `Status`
     */
    public suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Describes a dataset group created using the [CreateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html) operation.
     *
     * In addition to listing the parameters provided in the `CreateDatasetGroup` request, this operation includes the following properties:
     * + `DatasetArns` - The datasets belonging to the group.
     * + `CreationTime`
     * + `LastModificationTime`
     * + `Status`
     */
    public suspend fun describeDatasetGroup(input: DescribeDatasetGroupRequest): DescribeDatasetGroupResponse

    /**
     * Describes a dataset import job created using the [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation.
     *
     * In addition to listing the parameters provided in the `CreateDatasetImportJob` request, this operation includes the following properties:
     * + `CreationTime`
     * + `LastModificationTime`
     * + `DataSize`
     * + `FieldStatistics`
     * + `Status`
     * + `Message` - If an error occurred, information about the error.
     */
    public suspend fun describeDatasetImportJob(input: DescribeDatasetImportJobRequest): DescribeDatasetImportJobResponse

    /**
     * Describes an Explainability resource created using the CreateExplainability operation.
     */
    public suspend fun describeExplainability(input: DescribeExplainabilityRequest): DescribeExplainabilityResponse

    /**
     * Describes an Explainability export created using the CreateExplainabilityExport operation.
     */
    public suspend fun describeExplainabilityExport(input: DescribeExplainabilityExportRequest): DescribeExplainabilityExportResponse

    /**
     * Describes a forecast created using the CreateForecast operation.
     *
     * In addition to listing the properties provided in the `CreateForecast` request, this operation lists the following properties:
     * + `DatasetGroupArn` - The dataset group that provided the training data.
     * + `CreationTime`
     * + `LastModificationTime`
     * + `Status`
     * + `Message` - If an error occurred, information about the error.
     */
    public suspend fun describeForecast(input: DescribeForecastRequest): DescribeForecastResponse

    /**
     * Describes a forecast export job created using the CreateForecastExportJob operation.
     *
     * In addition to listing the properties provided by the user in the `CreateForecastExportJob` request, this operation lists the following properties:
     * + `CreationTime`
     * + `LastModificationTime`
     * + `Status`
     * + `Message` - If an error occurred, information about the error.
     */
    public suspend fun describeForecastExportJob(input: DescribeForecastExportJobRequest): DescribeForecastExportJobResponse

    /**
     * Describes a monitor resource. In addition to listing the properties provided in the CreateMonitor request, this operation lists the following properties:
     * + `Baseline`
     * + `CreationTime`
     * + `LastEvaluationTime`
     * + `LastEvaluationState`
     * + `LastModificationTime`
     * + `Message`
     * + `Status`
     */
    public suspend fun describeMonitor(input: DescribeMonitorRequest): DescribeMonitorResponse

    /**
     * This operation is only valid for legacy predictors created with CreatePredictor. If you are not using a legacy predictor, use DescribeAutoPredictor.
     *
     * Describes a predictor created using the CreatePredictor operation.
     *
     * In addition to listing the properties provided in the `CreatePredictor` request, this operation lists the following properties:
     * + `DatasetImportJobArns` - The dataset import jobs used to import training data.
     * + `AutoMLAlgorithmArns` - If AutoML is performed, the algorithms that were evaluated.
     * + `CreationTime`
     * + `LastModificationTime`
     * + `Status`
     * + `Message` - If an error occurred, information about the error.
     */
    public suspend fun describePredictor(input: DescribePredictorRequest): DescribePredictorResponse

    /**
     * Describes a predictor backtest export job created using the CreatePredictorBacktestExportJob operation.
     *
     * In addition to listing the properties provided by the user in the `CreatePredictorBacktestExportJob` request, this operation lists the following properties:
     * + `CreationTime`
     * + `LastModificationTime`
     * + `Status`
     * + `Message` (if an error occurred)
     */
    public suspend fun describePredictorBacktestExportJob(input: DescribePredictorBacktestExportJobRequest): DescribePredictorBacktestExportJobResponse

    /**
     * Describes the what-if analysis created using the CreateWhatIfAnalysis operation.
     *
     * In addition to listing the properties provided in the `CreateWhatIfAnalysis` request, this operation lists the following properties:
     * + `CreationTime`
     * + `LastModificationTime`
     * + `Message` - If an error occurred, information about the error.
     * + `Status`
     */
    public suspend fun describeWhatIfAnalysis(input: DescribeWhatIfAnalysisRequest): DescribeWhatIfAnalysisResponse

    /**
     * Describes the what-if forecast created using the CreateWhatIfForecast operation.
     *
     * In addition to listing the properties provided in the `CreateWhatIfForecast` request, this operation lists the following properties:
     * + `CreationTime`
     * + `LastModificationTime`
     * + `Message` - If an error occurred, information about the error.
     * + `Status`
     */
    public suspend fun describeWhatIfForecast(input: DescribeWhatIfForecastRequest): DescribeWhatIfForecastResponse

    /**
     * Describes the what-if forecast export created using the CreateWhatIfForecastExport operation.
     *
     * In addition to listing the properties provided in the `CreateWhatIfForecastExport` request, this operation lists the following properties:
     * + `CreationTime`
     * + `LastModificationTime`
     * + `Message` - If an error occurred, information about the error.
     * + `Status`
     */
    public suspend fun describeWhatIfForecastExport(input: DescribeWhatIfForecastExportRequest): DescribeWhatIfForecastExportResponse

    /**
     * Provides metrics on the accuracy of the models that were trained by the CreatePredictor operation. Use metrics to see how well the model performed and to decide whether to use the predictor to generate a forecast. For more information, see [Predictor Metrics](https://docs.aws.amazon.com/forecast/latest/dg/metrics.html).
     *
     * This operation generates metrics for each backtest window that was evaluated. The number of backtest windows (`NumberOfBacktestWindows`) is specified using the EvaluationParameters object, which is optionally included in the `CreatePredictor` request. If `NumberOfBacktestWindows` isn't specified, the number defaults to one.
     *
     * The parameters of the `filling` method determine which items contribute to the metrics. If you want all items to contribute, specify `zero`. If you want only those items that have complete data in the range being evaluated to contribute, specify `nan`. For more information, see FeaturizationMethod.
     *
     * Before you can get accuracy metrics, the `Status` of the predictor must be `ACTIVE`, signifying that training has completed. To get the status, use the DescribePredictor operation.
     */
    public suspend fun getAccuracyMetrics(input: GetAccuracyMetricsRequest): GetAccuracyMetricsResponse

    /**
     * Returns a list of dataset groups created using the [CreateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html) operation. For each dataset group, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the dataset group ARN with the [DescribeDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html) operation.
     */
    public suspend fun listDatasetGroups(input: ListDatasetGroupsRequest = ListDatasetGroupsRequest { }): ListDatasetGroupsResponse

    /**
     * Returns a list of dataset import jobs created using the [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation. For each import job, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the ARN with the [DescribeDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html) operation. You can filter the list by providing an array of [Filter](https://docs.aws.amazon.com/forecast/latest/dg/API_Filter.html) objects.
     */
    public suspend fun listDatasetImportJobs(input: ListDatasetImportJobsRequest = ListDatasetImportJobsRequest { }): ListDatasetImportJobsResponse

    /**
     * Returns a list of datasets created using the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation. For each dataset, a summary of its properties, including its Amazon Resource Name (ARN), is returned. To retrieve the complete set of properties, use the ARN with the [DescribeDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html) operation.
     */
    public suspend fun listDatasets(input: ListDatasetsRequest = ListDatasetsRequest { }): ListDatasetsResponse

    /**
     * Returns a list of Explainability resources created using the CreateExplainability operation. This operation returns a summary for each Explainability. You can filter the list using an array of Filter objects.
     *
     * To retrieve the complete set of properties for a particular Explainability resource, use the ARN with the DescribeExplainability operation.
     */
    public suspend fun listExplainabilities(input: ListExplainabilitiesRequest = ListExplainabilitiesRequest { }): ListExplainabilitiesResponse

    /**
     * Returns a list of Explainability exports created using the CreateExplainabilityExport operation. This operation returns a summary for each Explainability export. You can filter the list using an array of Filter objects.
     *
     * To retrieve the complete set of properties for a particular Explainability export, use the ARN with the DescribeExplainability operation.
     */
    public suspend fun listExplainabilityExports(input: ListExplainabilityExportsRequest = ListExplainabilityExportsRequest { }): ListExplainabilityExportsResponse

    /**
     * Returns a list of forecast export jobs created using the CreateForecastExportJob operation. For each forecast export job, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, use the ARN with the DescribeForecastExportJob operation. You can filter the list using an array of Filter objects.
     */
    public suspend fun listForecastExportJobs(input: ListForecastExportJobsRequest = ListForecastExportJobsRequest { }): ListForecastExportJobsResponse

    /**
     * Returns a list of forecasts created using the CreateForecast operation. For each forecast, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, specify the ARN with the DescribeForecast operation. You can filter the list using an array of Filter objects.
     */
    public suspend fun listForecasts(input: ListForecastsRequest = ListForecastsRequest { }): ListForecastsResponse

    /**
     * Returns a list of the monitoring evaluation results and predictor events collected by the monitor resource during different windows of time.
     *
     * For information about monitoring see predictor-monitoring. For more information about retrieving monitoring results see [Viewing Monitoring Results](https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html).
     */
    public suspend fun listMonitorEvaluations(input: ListMonitorEvaluationsRequest): ListMonitorEvaluationsResponse

    /**
     * Returns a list of monitors created with the CreateMonitor operation and CreateAutoPredictor operation. For each monitor resource, this operation returns of a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve a complete set of properties of a monitor resource by specify the monitor's ARN in the DescribeMonitor operation.
     */
    public suspend fun listMonitors(input: ListMonitorsRequest = ListMonitorsRequest { }): ListMonitorsResponse

    /**
     * Returns a list of predictor backtest export jobs created using the CreatePredictorBacktestExportJob operation. This operation returns a summary for each backtest export job. You can filter the list using an array of Filter objects.
     *
     * To retrieve the complete set of properties for a particular backtest export job, use the ARN with the DescribePredictorBacktestExportJob operation.
     */
    public suspend fun listPredictorBacktestExportJobs(input: ListPredictorBacktestExportJobsRequest = ListPredictorBacktestExportJobsRequest { }): ListPredictorBacktestExportJobsResponse

    /**
     * Returns a list of predictors created using the CreateAutoPredictor or CreatePredictor operations. For each predictor, this operation returns a summary of its properties, including its Amazon Resource Name (ARN).
     *
     * You can retrieve the complete set of properties by using the ARN with the DescribeAutoPredictor and DescribePredictor operations. You can filter the list using an array of Filter objects.
     */
    public suspend fun listPredictors(input: ListPredictorsRequest = ListPredictorsRequest { }): ListPredictorsResponse

    /**
     * Lists the tags for an Amazon Forecast resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of what-if analyses created using the CreateWhatIfAnalysis operation. For each what-if analysis, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if analysis ARN with the DescribeWhatIfAnalysis operation.
     */
    public suspend fun listWhatIfAnalyses(input: ListWhatIfAnalysesRequest = ListWhatIfAnalysesRequest { }): ListWhatIfAnalysesResponse

    /**
     * Returns a list of what-if forecast exports created using the CreateWhatIfForecastExport operation. For each what-if forecast export, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if forecast export ARN with the DescribeWhatIfForecastExport operation.
     */
    public suspend fun listWhatIfForecastExports(input: ListWhatIfForecastExportsRequest = ListWhatIfForecastExportsRequest { }): ListWhatIfForecastExportsResponse

    /**
     * Returns a list of what-if forecasts created using the CreateWhatIfForecast operation. For each what-if forecast, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if forecast ARN with the DescribeWhatIfForecast operation.
     */
    public suspend fun listWhatIfForecasts(input: ListWhatIfForecastsRequest = ListWhatIfForecastsRequest { }): ListWhatIfForecastsResponse

    /**
     * Resumes a stopped monitor resource.
     */
    public suspend fun resumeResource(input: ResumeResourceRequest): ResumeResourceResponse

    /**
     * Stops a resource.
     *
     * The resource undergoes the following states: `CREATE_STOPPING` and `CREATE_STOPPED`. You cannot resume a resource once it has been stopped.
     *
     * This operation can be applied to the following resources (and their corresponding child resources):
     * + Dataset Import Job
     * + Predictor Job
     * + Forecast Job
     * + Forecast Export Job
     * + Predictor Backtest Export Job
     * + Explainability Job
     * + Explainability Export Job
     */
    public suspend fun stopResource(input: StopResourceRequest): StopResourceResponse

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are also deleted.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes the specified tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Replaces the datasets in a dataset group with the specified datasets.
     *
     * The `Status` of the dataset group must be `ACTIVE` before you can use the dataset group to create a predictor. Use the [DescribeDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html) operation to get the status.
     */
    public suspend fun updateDatasetGroup(input: UpdateDatasetGroupRequest): UpdateDatasetGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ForecastClient.withConfig(block: ForecastClient.Config.Builder.() -> Unit): ForecastClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultForecastClient(newConfig)
}

/**
 * Creates an Amazon Forecast predictor.
 *
 * Amazon Forecast creates predictors with AutoPredictor, which involves applying the optimal combination of algorithms to each time series in your datasets. You can use CreateAutoPredictor to create new predictors or upgrade/retrain existing predictors.
 *
 * **Creating new predictors**
 *
 * The following parameters are required when creating a new predictor:
 * + `PredictorName` - A unique name for the predictor.
 * + `DatasetGroupArn` - The ARN of the dataset group used to train the predictor.
 * + `ForecastFrequency` - The granularity of your forecasts (hourly, daily, weekly, etc).
 * + `ForecastHorizon` - The number of time-steps that the model predicts. The forecast horizon is also called the prediction length.
 *
 * When creating a new predictor, do not specify a value for `ReferencePredictorArn`.
 *
 * **Upgrading and retraining predictors**
 *
 * The following parameters are required when retraining or upgrading a predictor:
 * + `PredictorName` - A unique name for the predictor.
 * + `ReferencePredictorArn` - The ARN of the predictor to retrain or upgrade.
 *
 * When upgrading or retraining a predictor, only specify values for the `ReferencePredictorArn` and `PredictorName`.
 */
public suspend inline fun ForecastClient.createAutoPredictor(crossinline block: CreateAutoPredictorRequest.Builder.() -> Unit): CreateAutoPredictorResponse = createAutoPredictor(CreateAutoPredictorRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Forecast dataset. The information about the dataset that you provide helps Forecast understand how to consume the data for model training. This includes the following:
 * + *`DataFrequency`* - How frequently your historical time-series data is collected.
 * + *`Domain`* and *`DatasetType`* - Each dataset has an associated dataset domain and a type within the domain. Amazon Forecast provides a list of predefined domains and types within each domain. For each unique dataset domain and type within the domain, Amazon Forecast requires your data to include a minimum set of predefined fields.
 * + *`Schema`* - A schema specifies the fields in the dataset, including the field name and data type.
 *
 * After creating a dataset, you import your training data into it and add the dataset to a dataset group. You use the dataset group to create a predictor. For more information, see [Importing datasets](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
 *
 * To get a list of all your datasets, use the [ListDatasets](https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasets.html) operation.
 *
 * For example Forecast datasets, see the [Amazon Forecast Sample GitHub repository](https://github.com/aws-samples/amazon-forecast-samples).
 *
 * The `Status` of a dataset must be `ACTIVE` before you can import training data. Use the [DescribeDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html) operation to get the status.
 */
public suspend inline fun ForecastClient.createDataset(crossinline block: CreateDatasetRequest.Builder.() -> Unit): CreateDatasetResponse = createDataset(CreateDatasetRequest.Builder().apply(block).build())

/**
 * Creates a dataset group, which holds a collection of related datasets. You can add datasets to the dataset group when you create the dataset group, or later by using the [UpdateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html) operation.
 *
 * After creating a dataset group and adding datasets, you use the dataset group when you create a predictor. For more information, see [Dataset groups](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
 *
 * To get a list of all your datasets groups, use the [ListDatasetGroups](https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetGroups.html) operation.
 *
 * The `Status` of a dataset group must be `ACTIVE` before you can use the dataset group to create a predictor. To get the status, use the [DescribeDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html) operation.
 */
public suspend inline fun ForecastClient.createDatasetGroup(crossinline block: CreateDatasetGroupRequest.Builder.() -> Unit): CreateDatasetGroupResponse = createDatasetGroup(CreateDatasetGroupRequest.Builder().apply(block).build())

/**
 * Imports your training data to an Amazon Forecast dataset. You provide the location of your training data in an Amazon Simple Storage Service (Amazon S3) bucket and the Amazon Resource Name (ARN) of the dataset that you want to import the data to.
 *
 * You must specify a [DataSource](https://docs.aws.amazon.com/forecast/latest/dg/API_DataSource.html) object that includes an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data, as Amazon Forecast makes a copy of your data and processes it in an internal Amazon Web Services system. For more information, see [Set up permissions](https://docs.aws.amazon.com/forecast/latest/dg/aws-forecast-iam-roles.html).
 *
 * The training data must be in CSV or Parquet format. The delimiter must be a comma (,).
 *
 * You can specify the path to a specific file, the S3 bucket, or to a folder in the S3 bucket. For the latter two cases, Amazon Forecast imports all files up to the limit of 10,000 files.
 *
 * Because dataset imports are not aggregated, your most recent dataset import is the one that is used when training a predictor or generating a forecast. Make sure that your most recent dataset import contains all of the data you want to model off of, and not just the new data collected since the previous import.
 *
 * To get a list of all your dataset import jobs, filtered by specified criteria, use the [ListDatasetImportJobs](https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetImportJobs.html) operation.
 */
public suspend inline fun ForecastClient.createDatasetImportJob(crossinline block: CreateDatasetImportJobRequest.Builder.() -> Unit): CreateDatasetImportJobResponse = createDatasetImportJob(CreateDatasetImportJobRequest.Builder().apply(block).build())

/**
 * Explainability is only available for Forecasts and Predictors generated from an AutoPredictor (CreateAutoPredictor)
 *
 * Creates an Amazon Forecast Explainability.
 *
 * Explainability helps you better understand how the attributes in your datasets impact forecast. Amazon Forecast uses a metric called Impact scores to quantify the relative impact of each attribute and determine whether they increase or decrease forecast values.
 *
 * To enable Forecast Explainability, your predictor must include at least one of the following: related time series, item metadata, or additional datasets like Holidays and the Weather Index.
 *
 * CreateExplainability accepts either a Predictor ARN or Forecast ARN. To receive aggregated Impact scores for all time series and time points in your datasets, provide a Predictor ARN. To receive Impact scores for specific time series and time points, provide a Forecast ARN.
 *
 * **CreateExplainability with a Predictor ARN**
 *
 * You can only have one Explainability resource per predictor. If you already enabled `ExplainPredictor` in CreateAutoPredictor, that predictor already has an Explainability resource.
 *
 * The following parameters are required when providing a Predictor ARN:
 * + `ExplainabilityName` - A unique name for the Explainability.
 * + `ResourceArn` - The Arn of the predictor.
 * + `TimePointGranularity` - Must be set to “ALL”.
 * + `TimeSeriesGranularity` - Must be set to “ALL”.
 *
 * Do not specify a value for the following parameters:
 * + `DataSource` - Only valid when TimeSeriesGranularity is “SPECIFIC”.
 * + `Schema` - Only valid when TimeSeriesGranularity is “SPECIFIC”.
 * + `StartDateTime` - Only valid when TimePointGranularity is “SPECIFIC”.
 * + `EndDateTime` - Only valid when TimePointGranularity is “SPECIFIC”.
 *
 * **CreateExplainability with a Forecast ARN**
 *
 * You can specify a maximum of 50 time series and 500 time points.
 *
 * The following parameters are required when providing a Predictor ARN:
 * + `ExplainabilityName` - A unique name for the Explainability.
 * + `ResourceArn` - The Arn of the forecast.
 * + `TimePointGranularity` - Either “ALL” or “SPECIFIC”.
 * + `TimeSeriesGranularity` - Either “ALL” or “SPECIFIC”.
 *
 * If you set TimeSeriesGranularity to “SPECIFIC”, you must also provide the following:
 * + `DataSource` - The S3 location of the CSV file specifying your time series.
 * + `Schema` - The Schema defines the attributes and attribute types listed in the Data Source.
 *
 * If you set TimePointGranularity to “SPECIFIC”, you must also provide the following:
 * + `StartDateTime` - The first timestamp in the range of time points.
 * + `EndDateTime` - The last timestamp in the range of time points.
 */
public suspend inline fun ForecastClient.createExplainability(crossinline block: CreateExplainabilityRequest.Builder.() -> Unit): CreateExplainabilityResponse = createExplainability(CreateExplainabilityRequest.Builder().apply(block).build())

/**
 * Exports an Explainability resource created by the CreateExplainability operation. Exported files are exported to an Amazon Simple Storage Service (Amazon S3) bucket.
 *
 * You must specify a DataDestination object that includes an Amazon S3 bucket and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
 *
 * The `Status` of the export job must be `ACTIVE` before you can access the export in your Amazon S3 bucket. To get the status, use the DescribeExplainabilityExport operation.
 */
public suspend inline fun ForecastClient.createExplainabilityExport(crossinline block: CreateExplainabilityExportRequest.Builder.() -> Unit): CreateExplainabilityExportResponse = createExplainabilityExport(CreateExplainabilityExportRequest.Builder().apply(block).build())

/**
 * Creates a forecast for each item in the `TARGET_TIME_SERIES` dataset that was used to train the predictor. This is known as inference. To retrieve the forecast for a single item at low latency, use the operation. To export the complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket, use the CreateForecastExportJob operation.
 *
 * The range of the forecast is determined by the `ForecastHorizon` value, which you specify in the CreatePredictor request. When you query a forecast, you can request a specific date range within the forecast.
 *
 * To get a list of all your forecasts, use the ListForecasts operation.
 *
 * The forecasts generated by Amazon Forecast are in the same time zone as the dataset that was used to create the predictor.
 *
 * For more information, see howitworks-forecast.
 *
 * The `Status` of the forecast must be `ACTIVE` before you can query or export the forecast. Use the DescribeForecast operation to get the status.
 *
 * By default, a forecast includes predictions for every item (`item_id`) in the dataset group that was used to train the predictor. However, you can use the `TimeSeriesSelector` object to generate a forecast on a subset of time series. Forecast creation is skipped for any time series that you specify that are not in the input dataset. The forecast export file will not contain these time series or their forecasted values.
 */
public suspend inline fun ForecastClient.createForecast(crossinline block: CreateForecastRequest.Builder.() -> Unit): CreateForecastResponse = createForecast(CreateForecastRequest.Builder().apply(block).build())

/**
 * Exports a forecast created by the CreateForecast operation to your Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions:
 *
 * <forecastexportjobname>_<exporttimestamp>_<partnumber>
 *
 * where the <exporttimestamp> component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).
 *
 * You must specify a DataDestination object that includes an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
 *
 * For more information, see howitworks-forecast.
 *
 * To get a list of all your forecast export jobs, use the ListForecastExportJobs operation.
 *
 * The `Status` of the forecast export job must be `ACTIVE` before you can access the forecast in your Amazon S3 bucket. To get the status, use the DescribeForecastExportJob operation.
 */
public suspend inline fun ForecastClient.createForecastExportJob(crossinline block: CreateForecastExportJobRequest.Builder.() -> Unit): CreateForecastExportJobResponse = createForecastExportJob(CreateForecastExportJobRequest.Builder().apply(block).build())

/**
 * Creates a predictor monitor resource for an existing auto predictor. Predictor monitoring allows you to see how your predictor's performance changes over time. For more information, see [Predictor Monitoring](https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring.html).
 */
public suspend inline fun ForecastClient.createMonitor(crossinline block: CreateMonitorRequest.Builder.() -> Unit): CreateMonitorResponse = createMonitor(CreateMonitorRequest.Builder().apply(block).build())

/**
 * This operation creates a legacy predictor that does not include all the predictor functionalities provided by Amazon Forecast. To create a predictor that is compatible with all aspects of Forecast, use CreateAutoPredictor.
 *
 * Creates an Amazon Forecast predictor.
 *
 * In the request, provide a dataset group and either specify an algorithm or let Amazon Forecast choose an algorithm for you using AutoML. If you specify an algorithm, you also can override algorithm-specific hyperparameters.
 *
 * Amazon Forecast uses the algorithm to train a predictor using the latest version of the datasets in the specified dataset group. You can then generate a forecast using the CreateForecast operation.
 *
 *  To see the evaluation metrics, use the GetAccuracyMetrics operation.
 *
 * You can specify a featurization configuration to fill and aggregate the data fields in the `TARGET_TIME_SERIES` dataset to improve model training. For more information, see FeaturizationConfig.
 *
 * For RELATED_TIME_SERIES datasets, `CreatePredictor` verifies that the `DataFrequency` specified when the dataset was created matches the `ForecastFrequency`. TARGET_TIME_SERIES datasets don't have this restriction. Amazon Forecast also verifies the delimiter and timestamp format. For more information, see howitworks-datasets-groups.
 *
 * By default, predictors are trained and evaluated at the 0.1 (P10), 0.5 (P50), and 0.9 (P90) quantiles. You can choose custom forecast types to train and evaluate your predictor by setting the `ForecastTypes`.
 *
 * **AutoML**
 *
 * If you want Amazon Forecast to evaluate each algorithm and choose the one that minimizes the `objective function`, set `PerformAutoML` to `true`. The `objective function` is defined as the mean of the weighted losses over the forecast types. By default, these are the p10, p50, and p90 quantile losses. For more information, see EvaluationResult.
 *
 * When AutoML is enabled, the following properties are disallowed:
 * + `AlgorithmArn`
 * + `HPOConfig`
 * + `PerformHPO`
 * + `TrainingParameters`
 *
 * To get a list of all of your predictors, use the ListPredictors operation.
 *
 * Before you can use the predictor to create a forecast, the `Status` of the predictor must be `ACTIVE`, signifying that training has completed. To get the status, use the DescribePredictor operation.
 */
public suspend inline fun ForecastClient.createPredictor(crossinline block: CreatePredictorRequest.Builder.() -> Unit): CreatePredictorResponse = createPredictor(CreatePredictorRequest.Builder().apply(block).build())

/**
 * Exports backtest forecasts and accuracy metrics generated by the CreateAutoPredictor or CreatePredictor operations. Two folders containing CSV or Parquet files are exported to your specified S3 bucket.
 *
 *  The export file names will match the following conventions:
 *
 * `<ExportJobName>_<ExportTimestamp>_<PartNumber>.csv`
 *
 * The <exporttimestamp> component is in Java SimpleDate format (yyyy-MM-ddTHH-mm-ssZ).
 *
 * You must specify a DataDestination object that includes an Amazon S3 bucket and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
 *
 * The `Status` of the export job must be `ACTIVE` before you can access the export in your Amazon S3 bucket. To get the status, use the DescribePredictorBacktestExportJob operation.
 */
public suspend inline fun ForecastClient.createPredictorBacktestExportJob(crossinline block: CreatePredictorBacktestExportJobRequest.Builder.() -> Unit): CreatePredictorBacktestExportJobResponse = createPredictorBacktestExportJob(CreatePredictorBacktestExportJobRequest.Builder().apply(block).build())

/**
 * What-if analysis is a scenario modeling technique where you make a hypothetical change to a time series and compare the forecasts generated by these changes against the baseline, unchanged time series. It is important to remember that the purpose of a what-if analysis is to understand how a forecast can change given different modifications to the baseline time series.
 *
 * For example, imagine you are a clothing retailer who is considering an end of season sale to clear space for new styles. After creating a baseline forecast, you can use a what-if analysis to investigate how different sales tactics might affect your goals.
 *
 * You could create a scenario where everything is given a 25% markdown, and another where everything is given a fixed dollar markdown. You could create a scenario where the sale lasts for one week and another where the sale lasts for one month. With a what-if analysis, you can compare many different scenarios against each other.
 *
 * Note that a what-if analysis is meant to display what the forecasting model has learned and how it will behave in the scenarios that you are evaluating. Do not blindly use the results of the what-if analysis to make business decisions. For instance, forecasts might not be accurate for novel scenarios where there is no reference available to determine whether a forecast is good.
 *
 * The TimeSeriesSelector object defines the items that you want in the what-if analysis.
 */
public suspend inline fun ForecastClient.createWhatIfAnalysis(crossinline block: CreateWhatIfAnalysisRequest.Builder.() -> Unit): CreateWhatIfAnalysisResponse = createWhatIfAnalysis(CreateWhatIfAnalysisRequest.Builder().apply(block).build())

/**
 * A what-if forecast is a forecast that is created from a modified version of the baseline forecast. Each what-if forecast incorporates either a replacement dataset or a set of transformations to the original dataset.
 */
public suspend inline fun ForecastClient.createWhatIfForecast(crossinline block: CreateWhatIfForecastRequest.Builder.() -> Unit): CreateWhatIfForecastResponse = createWhatIfForecast(CreateWhatIfForecastRequest.Builder().apply(block).build())

/**
 * Exports a forecast created by the CreateWhatIfForecast operation to your Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions:
 *
 * `≈<ForecastExportJobName>_<ExportTimestamp>_<PartNumber>`
 *
 * The <exporttimestamp> component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).
 *
 * You must specify a DataDestination object that includes an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
 *
 * For more information, see howitworks-forecast.
 *
 * To get a list of all your what-if forecast export jobs, use the ListWhatIfForecastExports operation.
 *
 * The `Status` of the forecast export job must be `ACTIVE` before you can access the forecast in your Amazon S3 bucket. To get the status, use the DescribeWhatIfForecastExport operation.
 */
public suspend inline fun ForecastClient.createWhatIfForecastExport(crossinline block: CreateWhatIfForecastExportRequest.Builder.() -> Unit): CreateWhatIfForecastExportResponse = createWhatIfForecastExport(CreateWhatIfForecastExportRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Forecast dataset that was created using the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation. You can only delete datasets that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status use the [DescribeDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html) operation.
 *
 * Forecast does not automatically update any dataset groups that contain the deleted dataset. In order to update the dataset group, use the [UpdateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html) operation, omitting the deleted dataset's ARN.
 */
public suspend inline fun ForecastClient.deleteDataset(crossinline block: DeleteDatasetRequest.Builder.() -> Unit): DeleteDatasetResponse = deleteDataset(DeleteDatasetRequest.Builder().apply(block).build())

/**
 * Deletes a dataset group created using the [CreateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html) operation. You can only delete dataset groups that have a status of `ACTIVE`, `CREATE_FAILED`, or `UPDATE_FAILED`. To get the status, use the [DescribeDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html) operation.
 *
 * This operation deletes only the dataset group, not the datasets in the group.
 */
public suspend inline fun ForecastClient.deleteDatasetGroup(crossinline block: DeleteDatasetGroupRequest.Builder.() -> Unit): DeleteDatasetGroupResponse = deleteDatasetGroup(DeleteDatasetGroupRequest.Builder().apply(block).build())

/**
 * Deletes a dataset import job created using the [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation. You can delete only dataset import jobs that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the [DescribeDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html) operation.
 */
public suspend inline fun ForecastClient.deleteDatasetImportJob(crossinline block: DeleteDatasetImportJobRequest.Builder.() -> Unit): DeleteDatasetImportJobResponse = deleteDatasetImportJob(DeleteDatasetImportJobRequest.Builder().apply(block).build())

/**
 * Deletes an Explainability resource.
 *
 * You can delete only predictor that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeExplainability operation.
 */
public suspend inline fun ForecastClient.deleteExplainability(crossinline block: DeleteExplainabilityRequest.Builder.() -> Unit): DeleteExplainabilityResponse = deleteExplainability(DeleteExplainabilityRequest.Builder().apply(block).build())

/**
 * Deletes an Explainability export.
 */
public suspend inline fun ForecastClient.deleteExplainabilityExport(crossinline block: DeleteExplainabilityExportRequest.Builder.() -> Unit): DeleteExplainabilityExportResponse = deleteExplainabilityExport(DeleteExplainabilityExportRequest.Builder().apply(block).build())

/**
 * Deletes a forecast created using the CreateForecast operation. You can delete only forecasts that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeForecast operation.
 *
 * You can't delete a forecast while it is being exported. After a forecast is deleted, you can no longer query the forecast.
 */
public suspend inline fun ForecastClient.deleteForecast(crossinline block: DeleteForecastRequest.Builder.() -> Unit): DeleteForecastResponse = deleteForecast(DeleteForecastRequest.Builder().apply(block).build())

/**
 * Deletes a forecast export job created using the CreateForecastExportJob operation. You can delete only export jobs that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeForecastExportJob operation.
 */
public suspend inline fun ForecastClient.deleteForecastExportJob(crossinline block: DeleteForecastExportJobRequest.Builder.() -> Unit): DeleteForecastExportJobResponse = deleteForecastExportJob(DeleteForecastExportJobRequest.Builder().apply(block).build())

/**
 * Deletes a monitor resource. You can only delete a monitor resource with a status of `ACTIVE`, `ACTIVE_STOPPED`, `CREATE_FAILED`, or `CREATE_STOPPED`.
 */
public suspend inline fun ForecastClient.deleteMonitor(crossinline block: DeleteMonitorRequest.Builder.() -> Unit): DeleteMonitorResponse = deleteMonitor(DeleteMonitorRequest.Builder().apply(block).build())

/**
 * Deletes a predictor created using the DescribePredictor or CreatePredictor operations. You can delete only predictor that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribePredictor operation.
 */
public suspend inline fun ForecastClient.deletePredictor(crossinline block: DeletePredictorRequest.Builder.() -> Unit): DeletePredictorResponse = deletePredictor(DeletePredictorRequest.Builder().apply(block).build())

/**
 * Deletes a predictor backtest export job.
 */
public suspend inline fun ForecastClient.deletePredictorBacktestExportJob(crossinline block: DeletePredictorBacktestExportJobRequest.Builder.() -> Unit): DeletePredictorBacktestExportJobResponse = deletePredictorBacktestExportJob(DeletePredictorBacktestExportJobRequest.Builder().apply(block).build())

/**
 * Deletes an entire resource tree. This operation will delete the parent resource and its child resources.
 *
 * Child resources are resources that were created from another resource. For example, when a forecast is generated from a predictor, the forecast is the child resource and the predictor is the parent resource.
 *
 * Amazon Forecast resources possess the following parent-child resource hierarchies:
 * + **Dataset**: dataset import jobs
 * + **Dataset Group**: predictors, predictor backtest export jobs, forecasts, forecast export jobs
 * + **Predictor**: predictor backtest export jobs, forecasts, forecast export jobs
 * + **Forecast**: forecast export jobs
 *
 * `DeleteResourceTree` will only delete Amazon Forecast resources, and will not delete datasets or exported files stored in Amazon S3.
 */
public suspend inline fun ForecastClient.deleteResourceTree(crossinline block: DeleteResourceTreeRequest.Builder.() -> Unit): DeleteResourceTreeResponse = deleteResourceTree(DeleteResourceTreeRequest.Builder().apply(block).build())

/**
 * Deletes a what-if analysis created using the CreateWhatIfAnalysis operation. You can delete only what-if analyses that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeWhatIfAnalysis operation.
 *
 * You can't delete a what-if analysis while any of its forecasts are being exported.
 */
public suspend inline fun ForecastClient.deleteWhatIfAnalysis(crossinline block: DeleteWhatIfAnalysisRequest.Builder.() -> Unit): DeleteWhatIfAnalysisResponse = deleteWhatIfAnalysis(DeleteWhatIfAnalysisRequest.Builder().apply(block).build())

/**
 * Deletes a what-if forecast created using the CreateWhatIfForecast operation. You can delete only what-if forecasts that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeWhatIfForecast operation.
 *
 * You can't delete a what-if forecast while it is being exported. After a what-if forecast is deleted, you can no longer query the what-if analysis.
 */
public suspend inline fun ForecastClient.deleteWhatIfForecast(crossinline block: DeleteWhatIfForecastRequest.Builder.() -> Unit): DeleteWhatIfForecastResponse = deleteWhatIfForecast(DeleteWhatIfForecastRequest.Builder().apply(block).build())

/**
 * Deletes a what-if forecast export created using the CreateWhatIfForecastExport operation. You can delete only what-if forecast exports that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the DescribeWhatIfForecastExport operation.
 */
public suspend inline fun ForecastClient.deleteWhatIfForecastExport(crossinline block: DeleteWhatIfForecastExportRequest.Builder.() -> Unit): DeleteWhatIfForecastExportResponse = deleteWhatIfForecastExport(DeleteWhatIfForecastExportRequest.Builder().apply(block).build())

/**
 * Describes a predictor created using the CreateAutoPredictor operation.
 */
public suspend inline fun ForecastClient.describeAutoPredictor(crossinline block: DescribeAutoPredictorRequest.Builder.() -> Unit): DescribeAutoPredictorResponse = describeAutoPredictor(DescribeAutoPredictorRequest.Builder().apply(block).build())

/**
 * Describes an Amazon Forecast dataset created using the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation.
 *
 * In addition to listing the parameters specified in the `CreateDataset` request, this operation includes the following dataset properties:
 * + `CreationTime`
 * + `LastModificationTime`
 * + `Status`
 */
public suspend inline fun ForecastClient.describeDataset(crossinline block: DescribeDatasetRequest.Builder.() -> Unit): DescribeDatasetResponse = describeDataset(DescribeDatasetRequest.Builder().apply(block).build())

/**
 * Describes a dataset group created using the [CreateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html) operation.
 *
 * In addition to listing the parameters provided in the `CreateDatasetGroup` request, this operation includes the following properties:
 * + `DatasetArns` - The datasets belonging to the group.
 * + `CreationTime`
 * + `LastModificationTime`
 * + `Status`
 */
public suspend inline fun ForecastClient.describeDatasetGroup(crossinline block: DescribeDatasetGroupRequest.Builder.() -> Unit): DescribeDatasetGroupResponse = describeDatasetGroup(DescribeDatasetGroupRequest.Builder().apply(block).build())

/**
 * Describes a dataset import job created using the [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation.
 *
 * In addition to listing the parameters provided in the `CreateDatasetImportJob` request, this operation includes the following properties:
 * + `CreationTime`
 * + `LastModificationTime`
 * + `DataSize`
 * + `FieldStatistics`
 * + `Status`
 * + `Message` - If an error occurred, information about the error.
 */
public suspend inline fun ForecastClient.describeDatasetImportJob(crossinline block: DescribeDatasetImportJobRequest.Builder.() -> Unit): DescribeDatasetImportJobResponse = describeDatasetImportJob(DescribeDatasetImportJobRequest.Builder().apply(block).build())

/**
 * Describes an Explainability resource created using the CreateExplainability operation.
 */
public suspend inline fun ForecastClient.describeExplainability(crossinline block: DescribeExplainabilityRequest.Builder.() -> Unit): DescribeExplainabilityResponse = describeExplainability(DescribeExplainabilityRequest.Builder().apply(block).build())

/**
 * Describes an Explainability export created using the CreateExplainabilityExport operation.
 */
public suspend inline fun ForecastClient.describeExplainabilityExport(crossinline block: DescribeExplainabilityExportRequest.Builder.() -> Unit): DescribeExplainabilityExportResponse = describeExplainabilityExport(DescribeExplainabilityExportRequest.Builder().apply(block).build())

/**
 * Describes a forecast created using the CreateForecast operation.
 *
 * In addition to listing the properties provided in the `CreateForecast` request, this operation lists the following properties:
 * + `DatasetGroupArn` - The dataset group that provided the training data.
 * + `CreationTime`
 * + `LastModificationTime`
 * + `Status`
 * + `Message` - If an error occurred, information about the error.
 */
public suspend inline fun ForecastClient.describeForecast(crossinline block: DescribeForecastRequest.Builder.() -> Unit): DescribeForecastResponse = describeForecast(DescribeForecastRequest.Builder().apply(block).build())

/**
 * Describes a forecast export job created using the CreateForecastExportJob operation.
 *
 * In addition to listing the properties provided by the user in the `CreateForecastExportJob` request, this operation lists the following properties:
 * + `CreationTime`
 * + `LastModificationTime`
 * + `Status`
 * + `Message` - If an error occurred, information about the error.
 */
public suspend inline fun ForecastClient.describeForecastExportJob(crossinline block: DescribeForecastExportJobRequest.Builder.() -> Unit): DescribeForecastExportJobResponse = describeForecastExportJob(DescribeForecastExportJobRequest.Builder().apply(block).build())

/**
 * Describes a monitor resource. In addition to listing the properties provided in the CreateMonitor request, this operation lists the following properties:
 * + `Baseline`
 * + `CreationTime`
 * + `LastEvaluationTime`
 * + `LastEvaluationState`
 * + `LastModificationTime`
 * + `Message`
 * + `Status`
 */
public suspend inline fun ForecastClient.describeMonitor(crossinline block: DescribeMonitorRequest.Builder.() -> Unit): DescribeMonitorResponse = describeMonitor(DescribeMonitorRequest.Builder().apply(block).build())

/**
 * This operation is only valid for legacy predictors created with CreatePredictor. If you are not using a legacy predictor, use DescribeAutoPredictor.
 *
 * Describes a predictor created using the CreatePredictor operation.
 *
 * In addition to listing the properties provided in the `CreatePredictor` request, this operation lists the following properties:
 * + `DatasetImportJobArns` - The dataset import jobs used to import training data.
 * + `AutoMLAlgorithmArns` - If AutoML is performed, the algorithms that were evaluated.
 * + `CreationTime`
 * + `LastModificationTime`
 * + `Status`
 * + `Message` - If an error occurred, information about the error.
 */
public suspend inline fun ForecastClient.describePredictor(crossinline block: DescribePredictorRequest.Builder.() -> Unit): DescribePredictorResponse = describePredictor(DescribePredictorRequest.Builder().apply(block).build())

/**
 * Describes a predictor backtest export job created using the CreatePredictorBacktestExportJob operation.
 *
 * In addition to listing the properties provided by the user in the `CreatePredictorBacktestExportJob` request, this operation lists the following properties:
 * + `CreationTime`
 * + `LastModificationTime`
 * + `Status`
 * + `Message` (if an error occurred)
 */
public suspend inline fun ForecastClient.describePredictorBacktestExportJob(crossinline block: DescribePredictorBacktestExportJobRequest.Builder.() -> Unit): DescribePredictorBacktestExportJobResponse = describePredictorBacktestExportJob(DescribePredictorBacktestExportJobRequest.Builder().apply(block).build())

/**
 * Describes the what-if analysis created using the CreateWhatIfAnalysis operation.
 *
 * In addition to listing the properties provided in the `CreateWhatIfAnalysis` request, this operation lists the following properties:
 * + `CreationTime`
 * + `LastModificationTime`
 * + `Message` - If an error occurred, information about the error.
 * + `Status`
 */
public suspend inline fun ForecastClient.describeWhatIfAnalysis(crossinline block: DescribeWhatIfAnalysisRequest.Builder.() -> Unit): DescribeWhatIfAnalysisResponse = describeWhatIfAnalysis(DescribeWhatIfAnalysisRequest.Builder().apply(block).build())

/**
 * Describes the what-if forecast created using the CreateWhatIfForecast operation.
 *
 * In addition to listing the properties provided in the `CreateWhatIfForecast` request, this operation lists the following properties:
 * + `CreationTime`
 * + `LastModificationTime`
 * + `Message` - If an error occurred, information about the error.
 * + `Status`
 */
public suspend inline fun ForecastClient.describeWhatIfForecast(crossinline block: DescribeWhatIfForecastRequest.Builder.() -> Unit): DescribeWhatIfForecastResponse = describeWhatIfForecast(DescribeWhatIfForecastRequest.Builder().apply(block).build())

/**
 * Describes the what-if forecast export created using the CreateWhatIfForecastExport operation.
 *
 * In addition to listing the properties provided in the `CreateWhatIfForecastExport` request, this operation lists the following properties:
 * + `CreationTime`
 * + `LastModificationTime`
 * + `Message` - If an error occurred, information about the error.
 * + `Status`
 */
public suspend inline fun ForecastClient.describeWhatIfForecastExport(crossinline block: DescribeWhatIfForecastExportRequest.Builder.() -> Unit): DescribeWhatIfForecastExportResponse = describeWhatIfForecastExport(DescribeWhatIfForecastExportRequest.Builder().apply(block).build())

/**
 * Provides metrics on the accuracy of the models that were trained by the CreatePredictor operation. Use metrics to see how well the model performed and to decide whether to use the predictor to generate a forecast. For more information, see [Predictor Metrics](https://docs.aws.amazon.com/forecast/latest/dg/metrics.html).
 *
 * This operation generates metrics for each backtest window that was evaluated. The number of backtest windows (`NumberOfBacktestWindows`) is specified using the EvaluationParameters object, which is optionally included in the `CreatePredictor` request. If `NumberOfBacktestWindows` isn't specified, the number defaults to one.
 *
 * The parameters of the `filling` method determine which items contribute to the metrics. If you want all items to contribute, specify `zero`. If you want only those items that have complete data in the range being evaluated to contribute, specify `nan`. For more information, see FeaturizationMethod.
 *
 * Before you can get accuracy metrics, the `Status` of the predictor must be `ACTIVE`, signifying that training has completed. To get the status, use the DescribePredictor operation.
 */
public suspend inline fun ForecastClient.getAccuracyMetrics(crossinline block: GetAccuracyMetricsRequest.Builder.() -> Unit): GetAccuracyMetricsResponse = getAccuracyMetrics(GetAccuracyMetricsRequest.Builder().apply(block).build())

/**
 * Returns a list of dataset groups created using the [CreateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html) operation. For each dataset group, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the dataset group ARN with the [DescribeDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html) operation.
 */
public suspend inline fun ForecastClient.listDatasetGroups(crossinline block: ListDatasetGroupsRequest.Builder.() -> Unit): ListDatasetGroupsResponse = listDatasetGroups(ListDatasetGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of dataset import jobs created using the [CreateDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html) operation. For each import job, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the ARN with the [DescribeDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html) operation. You can filter the list by providing an array of [Filter](https://docs.aws.amazon.com/forecast/latest/dg/API_Filter.html) objects.
 */
public suspend inline fun ForecastClient.listDatasetImportJobs(crossinline block: ListDatasetImportJobsRequest.Builder.() -> Unit): ListDatasetImportJobsResponse = listDatasetImportJobs(ListDatasetImportJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of datasets created using the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation. For each dataset, a summary of its properties, including its Amazon Resource Name (ARN), is returned. To retrieve the complete set of properties, use the ARN with the [DescribeDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html) operation.
 */
public suspend inline fun ForecastClient.listDatasets(crossinline block: ListDatasetsRequest.Builder.() -> Unit): ListDatasetsResponse = listDatasets(ListDatasetsRequest.Builder().apply(block).build())

/**
 * Returns a list of Explainability resources created using the CreateExplainability operation. This operation returns a summary for each Explainability. You can filter the list using an array of Filter objects.
 *
 * To retrieve the complete set of properties for a particular Explainability resource, use the ARN with the DescribeExplainability operation.
 */
public suspend inline fun ForecastClient.listExplainabilities(crossinline block: ListExplainabilitiesRequest.Builder.() -> Unit): ListExplainabilitiesResponse = listExplainabilities(ListExplainabilitiesRequest.Builder().apply(block).build())

/**
 * Returns a list of Explainability exports created using the CreateExplainabilityExport operation. This operation returns a summary for each Explainability export. You can filter the list using an array of Filter objects.
 *
 * To retrieve the complete set of properties for a particular Explainability export, use the ARN with the DescribeExplainability operation.
 */
public suspend inline fun ForecastClient.listExplainabilityExports(crossinline block: ListExplainabilityExportsRequest.Builder.() -> Unit): ListExplainabilityExportsResponse = listExplainabilityExports(ListExplainabilityExportsRequest.Builder().apply(block).build())

/**
 * Returns a list of forecast export jobs created using the CreateForecastExportJob operation. For each forecast export job, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, use the ARN with the DescribeForecastExportJob operation. You can filter the list using an array of Filter objects.
 */
public suspend inline fun ForecastClient.listForecastExportJobs(crossinline block: ListForecastExportJobsRequest.Builder.() -> Unit): ListForecastExportJobsResponse = listForecastExportJobs(ListForecastExportJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of forecasts created using the CreateForecast operation. For each forecast, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, specify the ARN with the DescribeForecast operation. You can filter the list using an array of Filter objects.
 */
public suspend inline fun ForecastClient.listForecasts(crossinline block: ListForecastsRequest.Builder.() -> Unit): ListForecastsResponse = listForecasts(ListForecastsRequest.Builder().apply(block).build())

/**
 * Returns a list of the monitoring evaluation results and predictor events collected by the monitor resource during different windows of time.
 *
 * For information about monitoring see predictor-monitoring. For more information about retrieving monitoring results see [Viewing Monitoring Results](https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html).
 */
public suspend inline fun ForecastClient.listMonitorEvaluations(crossinline block: ListMonitorEvaluationsRequest.Builder.() -> Unit): ListMonitorEvaluationsResponse = listMonitorEvaluations(ListMonitorEvaluationsRequest.Builder().apply(block).build())

/**
 * Returns a list of monitors created with the CreateMonitor operation and CreateAutoPredictor operation. For each monitor resource, this operation returns of a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve a complete set of properties of a monitor resource by specify the monitor's ARN in the DescribeMonitor operation.
 */
public suspend inline fun ForecastClient.listMonitors(crossinline block: ListMonitorsRequest.Builder.() -> Unit): ListMonitorsResponse = listMonitors(ListMonitorsRequest.Builder().apply(block).build())

/**
 * Returns a list of predictor backtest export jobs created using the CreatePredictorBacktestExportJob operation. This operation returns a summary for each backtest export job. You can filter the list using an array of Filter objects.
 *
 * To retrieve the complete set of properties for a particular backtest export job, use the ARN with the DescribePredictorBacktestExportJob operation.
 */
public suspend inline fun ForecastClient.listPredictorBacktestExportJobs(crossinline block: ListPredictorBacktestExportJobsRequest.Builder.() -> Unit): ListPredictorBacktestExportJobsResponse = listPredictorBacktestExportJobs(ListPredictorBacktestExportJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of predictors created using the CreateAutoPredictor or CreatePredictor operations. For each predictor, this operation returns a summary of its properties, including its Amazon Resource Name (ARN).
 *
 * You can retrieve the complete set of properties by using the ARN with the DescribeAutoPredictor and DescribePredictor operations. You can filter the list using an array of Filter objects.
 */
public suspend inline fun ForecastClient.listPredictors(crossinline block: ListPredictorsRequest.Builder.() -> Unit): ListPredictorsResponse = listPredictors(ListPredictorsRequest.Builder().apply(block).build())

/**
 * Lists the tags for an Amazon Forecast resource.
 */
public suspend inline fun ForecastClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of what-if analyses created using the CreateWhatIfAnalysis operation. For each what-if analysis, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if analysis ARN with the DescribeWhatIfAnalysis operation.
 */
public suspend inline fun ForecastClient.listWhatIfAnalyses(crossinline block: ListWhatIfAnalysesRequest.Builder.() -> Unit): ListWhatIfAnalysesResponse = listWhatIfAnalyses(ListWhatIfAnalysesRequest.Builder().apply(block).build())

/**
 * Returns a list of what-if forecast exports created using the CreateWhatIfForecastExport operation. For each what-if forecast export, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if forecast export ARN with the DescribeWhatIfForecastExport operation.
 */
public suspend inline fun ForecastClient.listWhatIfForecastExports(crossinline block: ListWhatIfForecastExportsRequest.Builder.() -> Unit): ListWhatIfForecastExportsResponse = listWhatIfForecastExports(ListWhatIfForecastExportsRequest.Builder().apply(block).build())

/**
 * Returns a list of what-if forecasts created using the CreateWhatIfForecast operation. For each what-if forecast, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if forecast ARN with the DescribeWhatIfForecast operation.
 */
public suspend inline fun ForecastClient.listWhatIfForecasts(crossinline block: ListWhatIfForecastsRequest.Builder.() -> Unit): ListWhatIfForecastsResponse = listWhatIfForecasts(ListWhatIfForecastsRequest.Builder().apply(block).build())

/**
 * Resumes a stopped monitor resource.
 */
public suspend inline fun ForecastClient.resumeResource(crossinline block: ResumeResourceRequest.Builder.() -> Unit): ResumeResourceResponse = resumeResource(ResumeResourceRequest.Builder().apply(block).build())

/**
 * Stops a resource.
 *
 * The resource undergoes the following states: `CREATE_STOPPING` and `CREATE_STOPPED`. You cannot resume a resource once it has been stopped.
 *
 * This operation can be applied to the following resources (and their corresponding child resources):
 * + Dataset Import Job
 * + Predictor Job
 * + Forecast Job
 * + Forecast Export Job
 * + Predictor Backtest Export Job
 * + Explainability Job
 * + Explainability Export Job
 */
public suspend inline fun ForecastClient.stopResource(crossinline block: StopResourceRequest.Builder.() -> Unit): StopResourceResponse = stopResource(StopResourceRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are also deleted.
 */
public suspend inline fun ForecastClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes the specified tags from a resource.
 */
public suspend inline fun ForecastClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Replaces the datasets in a dataset group with the specified datasets.
 *
 * The `Status` of the dataset group must be `ACTIVE` before you can use the dataset group to create a predictor. Use the [DescribeDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html) operation to get the status.
 */
public suspend inline fun ForecastClient.updateDatasetGroup(crossinline block: UpdateDatasetGroupRequest.Builder.() -> Unit): UpdateDatasetGroupResponse = updateDatasetGroup(UpdateDatasetGroupRequest.Builder().apply(block).build())
