// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.Baseline
import aws.sdk.kotlin.services.forecast.model.DescribeMonitorResponse
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeMonitorOperationDeserializer: HttpDeserializer.NonStreaming<DescribeMonitorResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeMonitorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeMonitorError(context, call, payload)
        }
        val builder = DescribeMonitorResponse.Builder()

        if (payload != null) {
            deserializeDescribeMonitorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeMonitorError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMonitorOperationBody(builder: DescribeMonitorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASELINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Baseline"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ESTIMATEDEVALUATIONTIMEREMAININGINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedEvaluationTimeRemainingInMinutes"))
    val LASTEVALUATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastEvaluationState"))
    val LASTEVALUATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastEvaluationTime"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val MONITORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MonitorArn"))
    val MONITORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MonitorName"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASELINE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(ESTIMATEDEVALUATIONTIMEREMAININGINMINUTES_DESCRIPTOR)
        field(LASTEVALUATIONSTATE_DESCRIPTOR)
        field(LASTEVALUATIONTIME_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(MONITORARN_DESCRIPTOR)
        field(MONITORNAME_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASELINE_DESCRIPTOR.index -> builder.baseline = deserializeBaselineDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ESTIMATEDEVALUATIONTIMEREMAININGINMINUTES_DESCRIPTOR.index -> builder.estimatedEvaluationTimeRemainingInMinutes = deserializeLong()
                LASTEVALUATIONSTATE_DESCRIPTOR.index -> builder.lastEvaluationState = deserializeString()
                LASTEVALUATIONTIME_DESCRIPTOR.index -> builder.lastEvaluationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                MONITORARN_DESCRIPTOR.index -> builder.monitorArn = deserializeString()
                MONITORNAME_DESCRIPTOR.index -> builder.monitorName = deserializeString()
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
