// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.DataSource
import aws.sdk.kotlin.services.forecast.model.DescribeExplainabilityResponse
import aws.sdk.kotlin.services.forecast.model.ExplainabilityConfig
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.sdk.kotlin.services.forecast.model.Schema
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeExplainabilityOperationDeserializer: HttpDeserializer.NonStreaming<DescribeExplainabilityResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeExplainabilityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeExplainabilityError(context, call, payload)
        }
        val builder = DescribeExplainabilityResponse.Builder()

        if (payload != null) {
            deserializeDescribeExplainabilityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeExplainabilityError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExplainabilityOperationBody(builder: DescribeExplainabilityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataSource"))
    val ENABLEVISUALIZATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableVisualization"))
    val ENDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndDateTime"))
    val ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedTimeRemainingInMinutes"))
    val EXPLAINABILITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExplainabilityArn"))
    val EXPLAINABILITYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExplainabilityConfig"))
    val EXPLAINABILITYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExplainabilityName"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val SCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Schema"))
    val STARTDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StartDateTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DATASOURCE_DESCRIPTOR)
        field(ENABLEVISUALIZATION_DESCRIPTOR)
        field(ENDDATETIME_DESCRIPTOR)
        field(ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR)
        field(EXPLAINABILITYARN_DESCRIPTOR)
        field(EXPLAINABILITYCONFIG_DESCRIPTOR)
        field(EXPLAINABILITYNAME_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(SCHEMA_DESCRIPTOR)
        field(STARTDATETIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATASOURCE_DESCRIPTOR.index -> builder.dataSource = deserializeDataSourceDocument(deserializer)
                ENABLEVISUALIZATION_DESCRIPTOR.index -> builder.enableVisualization = deserializeBoolean()
                ENDDATETIME_DESCRIPTOR.index -> builder.endDateTime = deserializeString()
                ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR.index -> builder.estimatedTimeRemainingInMinutes = deserializeLong()
                EXPLAINABILITYARN_DESCRIPTOR.index -> builder.explainabilityArn = deserializeString()
                EXPLAINABILITYCONFIG_DESCRIPTOR.index -> builder.explainabilityConfig = deserializeExplainabilityConfigDocument(deserializer)
                EXPLAINABILITYNAME_DESCRIPTOR.index -> builder.explainabilityName = deserializeString()
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                SCHEMA_DESCRIPTOR.index -> builder.schema = deserializeSchemaDocument(deserializer)
                STARTDATETIME_DESCRIPTOR.index -> builder.startDateTime = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
