// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.DataDestination
import aws.sdk.kotlin.services.forecast.model.DescribeExplainabilityExportResponse
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeExplainabilityExportOperationDeserializer: HttpDeserializer.NonStreaming<DescribeExplainabilityExportResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeExplainabilityExportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeExplainabilityExportError(context, call, payload)
        }
        val builder = DescribeExplainabilityExportResponse.Builder()

        if (payload != null) {
            deserializeDescribeExplainabilityExportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeExplainabilityExportError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExplainabilityExportOperationBody(builder: DescribeExplainabilityExportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Destination"))
    val EXPLAINABILITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExplainabilityArn"))
    val EXPLAINABILITYEXPORTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExplainabilityExportArn"))
    val EXPLAINABILITYEXPORTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExplainabilityExportName"))
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Format"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(EXPLAINABILITYARN_DESCRIPTOR)
        field(EXPLAINABILITYEXPORTARN_DESCRIPTOR)
        field(EXPLAINABILITYEXPORTNAME_DESCRIPTOR)
        field(FORMAT_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESTINATION_DESCRIPTOR.index -> builder.destination = deserializeDataDestinationDocument(deserializer)
                EXPLAINABILITYARN_DESCRIPTOR.index -> builder.explainabilityArn = deserializeString()
                EXPLAINABILITYEXPORTARN_DESCRIPTOR.index -> builder.explainabilityExportArn = deserializeString()
                EXPLAINABILITYEXPORTNAME_DESCRIPTOR.index -> builder.explainabilityExportName = deserializeString()
                FORMAT_DESCRIPTOR.index -> builder.format = deserializeString()
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
