// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.DatasetType
import aws.sdk.kotlin.services.forecast.model.DescribeDatasetResponse
import aws.sdk.kotlin.services.forecast.model.Domain
import aws.sdk.kotlin.services.forecast.model.EncryptionConfig
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.sdk.kotlin.services.forecast.model.Schema
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeDatasetOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDatasetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDatasetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDatasetError(context, call, payload)
        }
        val builder = DescribeDatasetResponse.Builder()

        if (payload != null) {
            deserializeDescribeDatasetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDatasetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDatasetOperationBody(builder: DescribeDatasetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATAFREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataFrequency"))
    val DATASETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DatasetArn"))
    val DATASETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DatasetName"))
    val DATASETTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DatasetType"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Domain"))
    val ENCRYPTIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EncryptionConfig"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val SCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Schema"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DATAFREQUENCY_DESCRIPTOR)
        field(DATASETARN_DESCRIPTOR)
        field(DATASETNAME_DESCRIPTOR)
        field(DATASETTYPE_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(ENCRYPTIONCONFIG_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(SCHEMA_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATAFREQUENCY_DESCRIPTOR.index -> builder.dataFrequency = deserializeString()
                DATASETARN_DESCRIPTOR.index -> builder.datasetArn = deserializeString()
                DATASETNAME_DESCRIPTOR.index -> builder.datasetName = deserializeString()
                DATASETTYPE_DESCRIPTOR.index -> builder.datasetType = deserializeString().let { DatasetType.fromValue(it) }
                DOMAIN_DESCRIPTOR.index -> builder.domain = deserializeString().let { Domain.fromValue(it) }
                ENCRYPTIONCONFIG_DESCRIPTOR.index -> builder.encryptionConfig = deserializeEncryptionConfigDocument(deserializer)
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                SCHEMA_DESCRIPTOR.index -> builder.schema = deserializeSchemaDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
