// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.DataConfig
import aws.sdk.kotlin.services.forecast.model.DescribeAutoPredictorResponse
import aws.sdk.kotlin.services.forecast.model.EncryptionConfig
import aws.sdk.kotlin.services.forecast.model.ExplainabilityInfo
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.sdk.kotlin.services.forecast.model.MonitorInfo
import aws.sdk.kotlin.services.forecast.model.OptimizationMetric
import aws.sdk.kotlin.services.forecast.model.ReferencePredictorSummary
import aws.sdk.kotlin.services.forecast.model.TimeAlignmentBoundary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeAutoPredictorOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAutoPredictorResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAutoPredictorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAutoPredictorError(context, call, payload)
        }
        val builder = DescribeAutoPredictorResponse.Builder()

        if (payload != null) {
            deserializeDescribeAutoPredictorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAutoPredictorError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAutoPredictorOperationBody(builder: DescribeAutoPredictorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataConfig"))
    val DATASETIMPORTJOBARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DatasetImportJobArns"))
    val ENCRYPTIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EncryptionConfig"))
    val ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedTimeRemainingInMinutes"))
    val EXPLAINABILITYINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExplainabilityInfo"))
    val FORECASTDIMENSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ForecastDimensions"))
    val FORECASTFREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ForecastFrequency"))
    val FORECASTHORIZON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ForecastHorizon"))
    val FORECASTTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ForecastTypes"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val MONITORINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MonitorInfo"))
    val OPTIMIZATIONMETRIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OptimizationMetric"))
    val PREDICTORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PredictorArn"))
    val PREDICTORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PredictorName"))
    val REFERENCEPREDICTORSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReferencePredictorSummary"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TIMEALIGNMENTBOUNDARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeAlignmentBoundary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DATACONFIG_DESCRIPTOR)
        field(DATASETIMPORTJOBARNS_DESCRIPTOR)
        field(ENCRYPTIONCONFIG_DESCRIPTOR)
        field(ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR)
        field(EXPLAINABILITYINFO_DESCRIPTOR)
        field(FORECASTDIMENSIONS_DESCRIPTOR)
        field(FORECASTFREQUENCY_DESCRIPTOR)
        field(FORECASTHORIZON_DESCRIPTOR)
        field(FORECASTTYPES_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(MONITORINFO_DESCRIPTOR)
        field(OPTIMIZATIONMETRIC_DESCRIPTOR)
        field(PREDICTORARN_DESCRIPTOR)
        field(PREDICTORNAME_DESCRIPTOR)
        field(REFERENCEPREDICTORSUMMARY_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TIMEALIGNMENTBOUNDARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATACONFIG_DESCRIPTOR.index -> builder.dataConfig = deserializeDataConfigDocument(deserializer)
                DATASETIMPORTJOBARNS_DESCRIPTOR.index -> builder.datasetImportJobArns =
                    deserializer.deserializeList(DATASETIMPORTJOBARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENCRYPTIONCONFIG_DESCRIPTOR.index -> builder.encryptionConfig = deserializeEncryptionConfigDocument(deserializer)
                ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR.index -> builder.estimatedTimeRemainingInMinutes = deserializeLong()
                EXPLAINABILITYINFO_DESCRIPTOR.index -> builder.explainabilityInfo = deserializeExplainabilityInfoDocument(deserializer)
                FORECASTDIMENSIONS_DESCRIPTOR.index -> builder.forecastDimensions =
                    deserializer.deserializeList(FORECASTDIMENSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FORECASTFREQUENCY_DESCRIPTOR.index -> builder.forecastFrequency = deserializeString()
                FORECASTHORIZON_DESCRIPTOR.index -> builder.forecastHorizon = deserializeInt()
                FORECASTTYPES_DESCRIPTOR.index -> builder.forecastTypes =
                    deserializer.deserializeList(FORECASTTYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                MONITORINFO_DESCRIPTOR.index -> builder.monitorInfo = deserializeMonitorInfoDocument(deserializer)
                OPTIMIZATIONMETRIC_DESCRIPTOR.index -> builder.optimizationMetric = deserializeString().let { OptimizationMetric.fromValue(it) }
                PREDICTORARN_DESCRIPTOR.index -> builder.predictorArn = deserializeString()
                PREDICTORNAME_DESCRIPTOR.index -> builder.predictorName = deserializeString()
                REFERENCEPREDICTORSUMMARY_DESCRIPTOR.index -> builder.referencePredictorSummary = deserializeReferencePredictorSummaryDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                TIMEALIGNMENTBOUNDARY_DESCRIPTOR.index -> builder.timeAlignmentBoundary = deserializeTimeAlignmentBoundaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
