// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.AutoMlOverrideStrategy
import aws.sdk.kotlin.services.forecast.model.CreatePredictorRequest
import aws.sdk.kotlin.services.forecast.model.EncryptionConfig
import aws.sdk.kotlin.services.forecast.model.EvaluationParameters
import aws.sdk.kotlin.services.forecast.model.FeaturizationConfig
import aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig
import aws.sdk.kotlin.services.forecast.model.InputDataConfig
import aws.sdk.kotlin.services.forecast.model.OptimizationMetric
import aws.sdk.kotlin.services.forecast.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePredictorOperationSerializer: HttpSerializer.NonStreaming<CreatePredictorRequest> {
    override fun serialize(context: ExecutionContext, input: CreatePredictorRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreatePredictorOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreatePredictorOperationBody(context: ExecutionContext, input: CreatePredictorRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALGORITHMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmArn"))
    val AUTOMLOVERRIDESTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AutoMLOverrideStrategy"))
    val ENCRYPTIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EncryptionConfig"))
    val EVALUATIONPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EvaluationParameters"))
    val FEATURIZATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FeaturizationConfig"))
    val FORECASTHORIZON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ForecastHorizon"))
    val FORECASTTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ForecastTypes"))
    val HPOCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HPOConfig"))
    val INPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputDataConfig"))
    val OPTIMIZATIONMETRIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OptimizationMetric"))
    val PERFORMAUTOML_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PerformAutoML"))
    val PERFORMHPO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PerformHPO"))
    val PREDICTORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PredictorName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TRAININGPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("TrainingParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHMARN_DESCRIPTOR)
        field(AUTOMLOVERRIDESTRATEGY_DESCRIPTOR)
        field(ENCRYPTIONCONFIG_DESCRIPTOR)
        field(EVALUATIONPARAMETERS_DESCRIPTOR)
        field(FEATURIZATIONCONFIG_DESCRIPTOR)
        field(FORECASTHORIZON_DESCRIPTOR)
        field(FORECASTTYPES_DESCRIPTOR)
        field(HPOCONFIG_DESCRIPTOR)
        field(INPUTDATACONFIG_DESCRIPTOR)
        field(OPTIMIZATIONMETRIC_DESCRIPTOR)
        field(PERFORMAUTOML_DESCRIPTOR)
        field(PERFORMHPO_DESCRIPTOR)
        field(PREDICTORNAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRAININGPARAMETERS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.algorithmArn?.let { field(ALGORITHMARN_DESCRIPTOR, it) }
        input.autoMlOverrideStrategy?.let { field(AUTOMLOVERRIDESTRATEGY_DESCRIPTOR, it.value) }
        input.encryptionConfig?.let { field(ENCRYPTIONCONFIG_DESCRIPTOR, it, ::serializeEncryptionConfigDocument) }
        input.evaluationParameters?.let { field(EVALUATIONPARAMETERS_DESCRIPTOR, it, ::serializeEvaluationParametersDocument) }
        input.featurizationConfig?.let { field(FEATURIZATIONCONFIG_DESCRIPTOR, it, ::serializeFeaturizationConfigDocument) }
        input.forecastHorizon?.let { field(FORECASTHORIZON_DESCRIPTOR, it) }
        if (input.forecastTypes != null) {
            listField(FORECASTTYPES_DESCRIPTOR) {
                for (el0 in input.forecastTypes) {
                    serializeString(el0)
                }
            }
        }
        input.hpoConfig?.let { field(HPOCONFIG_DESCRIPTOR, it, ::serializeHyperParameterTuningJobConfigDocument) }
        input.inputDataConfig?.let { field(INPUTDATACONFIG_DESCRIPTOR, it, ::serializeInputDataConfigDocument) }
        input.optimizationMetric?.let { field(OPTIMIZATIONMETRIC_DESCRIPTOR, it.value) }
        input.performAutoMl?.let { field(PERFORMAUTOML_DESCRIPTOR, it) }
        input.performHpo?.let { field(PERFORMHPO_DESCRIPTOR, it) }
        input.predictorName?.let { field(PREDICTORNAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        if (input.trainingParameters != null) {
            mapField(TRAININGPARAMETERS_DESCRIPTOR) {
                input.trainingParameters.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
