// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The metrics for a time range within the evaluation portion of a dataset. This object is part of the EvaluationResult object.
 *
 * The `TestWindowStart` and `TestWindowEnd` parameters are determined by the `BackTestWindowOffset` parameter of the EvaluationParameters object.
 */
public class WindowSummary private constructor(builder: Builder) {
    /**
     * The type of evaluation.
     * + `SUMMARY` - The average metrics across all windows.
     * + `COMPUTED` - The metrics for the specified window.
     */
    public val evaluationType: aws.sdk.kotlin.services.forecast.model.EvaluationType? = builder.evaluationType
    /**
     * The number of data points within the window.
     */
    public val itemCount: kotlin.Int? = builder.itemCount
    /**
     * Provides metrics used to evaluate the performance of a predictor.
     */
    public val metrics: aws.sdk.kotlin.services.forecast.model.Metrics? = builder.metrics
    /**
     * The timestamp that defines the end of the window.
     */
    public val testWindowEnd: aws.smithy.kotlin.runtime.time.Instant? = builder.testWindowEnd
    /**
     * The timestamp that defines the start of the window.
     */
    public val testWindowStart: aws.smithy.kotlin.runtime.time.Instant? = builder.testWindowStart

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.WindowSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WindowSummary(")
        append("evaluationType=$evaluationType,")
        append("itemCount=$itemCount,")
        append("metrics=$metrics,")
        append("testWindowEnd=$testWindowEnd,")
        append("testWindowStart=$testWindowStart")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = evaluationType?.hashCode() ?: 0
        result = 31 * result + (itemCount ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (testWindowEnd?.hashCode() ?: 0)
        result = 31 * result + (testWindowStart?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WindowSummary

        if (evaluationType != other.evaluationType) return false
        if (itemCount != other.itemCount) return false
        if (metrics != other.metrics) return false
        if (testWindowEnd != other.testWindowEnd) return false
        if (testWindowStart != other.testWindowStart) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.WindowSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of evaluation.
         * + `SUMMARY` - The average metrics across all windows.
         * + `COMPUTED` - The metrics for the specified window.
         */
        public var evaluationType: aws.sdk.kotlin.services.forecast.model.EvaluationType? = null
        /**
         * The number of data points within the window.
         */
        public var itemCount: kotlin.Int? = null
        /**
         * Provides metrics used to evaluate the performance of a predictor.
         */
        public var metrics: aws.sdk.kotlin.services.forecast.model.Metrics? = null
        /**
         * The timestamp that defines the end of the window.
         */
        public var testWindowEnd: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp that defines the start of the window.
         */
        public var testWindowStart: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.WindowSummary) : this() {
            this.evaluationType = x.evaluationType
            this.itemCount = x.itemCount
            this.metrics = x.metrics
            this.testWindowEnd = x.testWindowEnd
            this.testWindowStart = x.testWindowStart
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.WindowSummary = WindowSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.Metrics] inside the given [block]
         */
        public fun metrics(block: aws.sdk.kotlin.services.forecast.model.Metrics.Builder.() -> kotlin.Unit) {
            this.metrics = aws.sdk.kotlin.services.forecast.model.Metrics.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
