// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The path to the file(s) in an Amazon Simple Storage Service (Amazon S3) bucket, and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the file(s). Optionally, includes an Key Management Service (KMS) key. This object is part of the DataSource object that is submitted in the CreateDatasetImportJob request, and part of the DataDestination object.
 */
public class S3Config private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Key Management Service (KMS) key.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The path to an Amazon Simple Storage Service (Amazon S3) bucket or file(s) in an Amazon S3 bucket.
     */
    public val path: kotlin.String = requireNotNull(builder.path) { "A non-null value must be provided for path" }
    /**
     * The ARN of the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket or files. If you provide a value for the `KMSKeyArn` key, the role must allow access to the key.
     *
     * Passing a role across Amazon Web Services accounts is not allowed. If you pass a role that isn't in your account, you get an `InvalidInputException` error.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.S3Config = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Config(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("path=$path,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (path.hashCode())
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Config

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (path != other.path) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.S3Config = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Key Management Service (KMS) key.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The path to an Amazon Simple Storage Service (Amazon S3) bucket or file(s) in an Amazon S3 bucket.
         */
        public var path: kotlin.String? = null
        /**
         * The ARN of the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket or files. If you provide a value for the `KMSKeyArn` key, the role must allow access to the key.
         *
         * Passing a role across Amazon Web Services accounts is not allowed. If you pass a role that isn't in your account, you get an `InvalidInputException` error.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.S3Config) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.path = x.path
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.S3Config = S3Config(this)

        internal fun correctErrors(): Builder {
            if (path == null) path = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
